<?php
require_once 'db_connect.php';

echo "=== TESTING PAGE DISPLAY ===\n\n";

// Test menupage-veg.php logic
echo "MENUPAGE-VEG.PHP SIMULATION:\n";
$breakfast_items = [];
$lunch_items = [];
$dinner_items = [];

$stmt = $conn->prepare("SELECT id, name, description, price, image FROM menu_items WHERE main_category = 'Veg' ORDER BY sub_category, id");
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    $row['sub_category'] = $row['sub_category'] ?? 'Breakfast';
    
    if ($row['sub_category'] === 'Breakfast') {
        $breakfast_items[] = $row;
    } elseif ($row['sub_category'] === 'Lunch') {
        $lunch_items[] = $row;
    } elseif ($row['sub_category'] === 'Dinner') {
        $dinner_items[] = $row;
    }
}

echo "Breakfast items count: " . count($breakfast_items) . "\n";
echo "Lunch items count: " . count($lunch_items) . "\n";
echo "Dinner items count: " . count($dinner_items) . "\n";

if (count($breakfast_items) > 0) {
    echo "\nBreakfast Items (Would Display):\n";
    foreach ($breakfast_items as $item) {
        echo "  - " . $item['name'] . " (Price: ₹" . number_format($item['price'], 2) . ", Image: " . ($item['image'] ? 'Yes' : 'No') . ")\n";
    }
}

if (count($lunch_items) > 0) {
    echo "\nLunch Items (Would Display):\n";
    foreach ($lunch_items as $item) {
        echo "  - " . $item['name'] . " (Price: ₹" . number_format($item['price'], 2) . ", Image: " . ($item['image'] ? 'Yes' : 'No') . ")\n";
    }
}

if (count($dinner_items) > 0) {
    echo "\nDinner Items (Would Display):\n";
    foreach ($dinner_items as $item) {
        echo "  - " . $item['name'] . " (Price: ₹" . number_format($item['price'], 2) . ", Image: " . ($item['image'] ? 'Yes' : 'No') . ")\n";
    }
}

// Test menupage-nonveg.php logic
echo "\n\nMENUPAGE-NONVEG.PHP SIMULATION:\n";
$breakfast_items = [];
$lunch_items = [];
$dinner_items = [];

$stmt = $conn->prepare("SELECT id, name, description, price, image FROM menu_items WHERE main_category = 'Non-Veg' ORDER BY sub_category, id");
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    $row['sub_category'] = $row['sub_category'] ?? 'Breakfast';
    
    if ($row['sub_category'] === 'Breakfast') {
        $breakfast_items[] = $row;
    } elseif ($row['sub_category'] === 'Lunch') {
        $lunch_items[] = $row;
    } elseif ($row['sub_category'] === 'Dinner') {
        $dinner_items[] = $row;
    }
}

echo "Breakfast items count: " . count($breakfast_items) . "\n";
echo "Lunch items count: " . count($lunch_items) . "\n";
echo "Dinner items count: " . count($dinner_items) . "\n";

if (count($breakfast_items) > 0) {
    echo "\nBreakfast Items (Would Display):\n";
    foreach ($breakfast_items as $item) {
        echo "  - " . $item['name'] . " (Price: ₹" . number_format($item['price'], 2) . ", Image: " . ($item['image'] ? 'Yes' : 'No') . ")\n";
    }
}

// Test drinks.php logic
echo "\n\nDRINKS.PHP SIMULATION:\n";
$hot_drinks = [];
$cool_drinks = [];
$fresh_juices = [];
$ice_cream = [];

$stmt = $conn->prepare("SELECT id, name, description, price, image FROM menu_items WHERE main_category = 'Drinks' ORDER BY sub_category, id");
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    $row['sub_category'] = $row['sub_category'] ?? 'Hot Drinks';
    
    if ($row['sub_category'] === 'Hot Drinks') {
        $hot_drinks[] = $row;
    } elseif ($row['sub_category'] === 'Cool Drinks') {
        $cool_drinks[] = $row;
    } elseif ($row['sub_category'] === 'Fresh Juices') {
        $fresh_juices[] = $row;
    } elseif ($row['sub_category'] === 'Ice Cream') {
        $ice_cream[] = $row;
    }
}

echo "Hot drinks count: " . count($hot_drinks) . "\n";
echo "Cool drinks count: " . count($cool_drinks) . "\n";
echo "Fresh juices count: " . count($fresh_juices) . "\n";
echo "Ice cream count: " . count($ice_cream) . "\n";

if (count($hot_drinks) > 0) {
    echo "\nHot Drinks (Would Display):\n";
    foreach ($hot_drinks as $item) {
        echo "  - " . $item['name'] . " (Price: ₹" . number_format($item['price'], 2) . ", Image: " . ($item['image'] ? 'Yes' : 'No') . ")\n";
    }
}

echo "\n=== END TEST ===\n";
?>
