<?php
session_start();
require_once 'db_connect.php';

// Fetch weekly specials from database
$weekly_specials = [];
$result = $conn->query("SELECT * FROM weekly_specials ORDER BY created_date DESC");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $weekly_specials[] = $row;
    }
}

// Helper function to get badge HTML
function getBadgeHTML($badge_type) {
    switch($badge_type) {
        case 'hot':
            return '<span class="badge hot">HOT 🔥</span>';
        case 'new':
            return '<span class="badge new">NEW ⭐</span>';
        case 'offer':
            return '<span class="badge offer">Offer 💰</span>';
        default:
            return '';
    }
}
?>
<!DOCTYPE html>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Bermiz</title>
	<link rel="icon" href="assets/images/favicon/icon.png">
	<link href="../../../css2?family=Elsie&display=swap" rel="stylesheet">
	<link href="../../../css2-1?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/all.min.css">
	<link rel="stylesheet" href="assets/css/slick.css">
	<link rel="stylesheet" href="assets/css/aos.css">
	<link rel="stylesheet" href="assets/css/animate.css">
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/photoswipe.min.css">
	<link rel="stylesheet" href="assets/css/default-skin.min.css">
	<link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/media-query.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<style>
		/* Payment Method Styles */
		.payment-methods { display: flex; flex-direction: column; gap: 16px; }
		.payment-option { position: relative; margin-bottom: 4px; }
		.payment-radio { position: absolute; top: 20px; left: 16px; opacity: 0; cursor: pointer; width: 18px; height: 18px; }
		.payment-label { 
			display: flex; 
			align-items: center; 
			padding: 16px 18px 16px 60px; 
			border: 2px solid #e8e8e8; 
			border-radius: 8px; 
			cursor: pointer; 
			transition: all 0.3s ease;
			background: white;
		}
		.payment-label:hover { border-color: #667eea; background: #f9fbff; }
		.payment-radio:checked + .payment-label { border-color: #667eea; background: #f0f4ff; }
		.payment-label i { font-size: 24px; color: #667eea; margin-right: 14px; min-width: 24px; text-align: center; }
		.payment-label > div { flex: 1; }
		.payment-name { font-weight: 600; color: #1c1c1c; font-size: 15px; display: block; line-height: 1.3; }
		.payment-desc { font-size: 13px; color: #9c9c9c; display: block; margin-top: 4px; }
		.payment-form { margin-top: 12px; padding: 16px; background: #f9f9f9; border: 1px solid #e8e8e8; border-radius: 6px; display: none; margin-left: 60px; }
		.payment-form input.form-control,
		.payment-form select.form-control { 
			padding: 11px 12px; 
			border: 1px solid #d1d8dd; 
			border-radius: 6px; 
			margin-bottom: 10px;
			font-size: 14px;
		}
		.form-row-small { display: grid; grid-template-columns: 1fr 1fr; gap: 10px; }
		.btn-payment { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; padding: 11px 16px; border-radius: 6px; font-weight: 600; cursor: pointer; width: 100%; font-size: 14px; transition: all 0.3s ease; }
		.btn-payment:hover { opacity: 0.9; transform: translateY(-2px); box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4); }
	</style>
</head>
<body>
	<div class="site_content">
		<!-- Preloader Start -->
<!-- ===== RESTAURANT PRELOADER ===== -->
<div id="preloader">

  <!-- INLINE SVG COFFEE -->
  <svg width="140" height="140"
       viewBox="0 0 140 140"
       xmlns="http://www.w3.org/2000/svg">

    <!-- Cup body -->
    <rect x="40" y="65" width="60" height="35"
          rx="8" fill="#78350f"/>

    <!-- Cup handle -->
    <path d="M100 72 Q115 82 100 92"
          fill="none"
          stroke="#78350f"
          stroke-width="5"/>

    <!-- Saucer -->
    <ellipse cx="70" cy="105" rx="40" ry="6"
             fill="#e5e7eb"/>

    <!-- Steam 1 -->
    <path d="M55 60 C45 50 65 40 55 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 2 -->
    <path d="M70 60 C60 50 80 40 70 30"
          stroke="#f59e0b"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.3s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 3 -->
    <path d="M85 60 C75 50 95 40 85 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.6s"
               repeatCount="indefinite"/>
    </path>

    <!-- Text -->
    <text x="70" y="130"
          text-anchor="middle"
          font-size="11"
          fill="#92400e">
      Brewing Coffee…
    </text>

  </svg>

</div>

		<!-- Preloader End --><!-- ================= TOP INFO HEADER ================= -->
<div class="top-header">
    <div class="container-fluid top-header-inner">

        <div class="welcome-text">
            Welcome to Bermiz Restaurant & Catering Services
        </div>

        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-twitter"></i></a>
            <a href="#"><i class="fa-brands fa-instagram"></i></a>
            <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
            <a href="#"><i class="fa-brands fa-youtube"></i></a>
        </div>

    </div>
</div>

<!-- ================= CONTACT STRIP ================= -->
<div class="top-header-container">
    
    <div class="logo-area">
        <a href="index.php">
        <img src="assets/images/Homepage1/logo.png" class="strip-logo">
		</a>
    </div>

    <div class="header-right-side">
        
        <div class="contact-group">
            
            <div class="contact-item">
                <i class="fas fa-phone-alt contact-icon"></i> <div>
                    <h5 class="contact-title">Call Us:</h5>
                    <p class="contact-text">+91 98765 43210</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-envelope contact-icon"></i>
                <div>
                    <h5 class="contact-title">Mail Us:</h5>
                    <p class="contact-text">bermizrestaurant@gmail.com</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-map-marker-alt contact-icon"></i>
                <div>
                    <h5 class="contact-title">Location:</h5>
                    <p class="contact-text">Coimbatore, Tamil Nadu</p>
                </div>
            </div>

        </div> 
 <div class="auth-actions" id="authContainer">
    <?php if (isset($_SESSION['user_name'])): ?>
        
        <div class="user-menu-dropdown">
            <button class="user-btn">
                <i class="fa fa-user-circle"></i> <span class="u-name"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <i class="fa fa-caret-down"></i> </button>

            <div class="dropdown-content">
                <a href="profile.php">
                    <i class="fa fa-id-card"></i> View Profile
                </a>
                <a href="logout.php" class="logout-item">
                    <i class="fa fa-sign-out"></i> Logout
                </a>
            </div>
        </div>

    <?php else: ?>

        <a href="login.php" class="btn-auth btn-login">Sign In</a>
        <a href="login.php?show=signup" class="btn-auth btn-signup">Sign Up</a>

    <?php endif; ?>
</div>

    </div>
	<style>/* ========================================= */
/* TOP HEADER LAYOUT                        */
/* ========================================= */
</style>
</div>
	
		<!-- Header Section Start -->
<header id="header-homepage1" class="menupage1-header">
	<div class="header-full-section">
		<!-- Logo -->
		<div class="header-logo">
			<a href="index.php">
				<img src="assets/images/Homepage1/logo.png" alt="header-logo" class="homepage1-logo">
			</a>
		</div>


		<!-- Desktop Menu -->
		<div class="header-menu-wrap">
			<div class="header-nav-wrap">
				<nav class="navbar navbar-expand-xl p-0">
					<div class="navbar-collapse" id="navbarSupportedContent">
						<ul class="navbar-nav mx-auto align-items-center">

							<!-- HOME -->
							<li class="nav-item">
								<a class="nav-link" href="index.php">Home</a>
							</li>

							<!-- ABOUT US DROPDOWN -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">About Us</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="about-us.php">About</a></li>
									<li><a class="dropdown-item" href="chefspage2.php">Chefs</a></li>
									<li><a class="dropdown-item" href="blogpage-1.php">Blog</a></li>
									<li><a class="dropdown-item" href="faq.php">FAQ</a></li>
								</ul>
							</li>

							<!-- MENU -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">Menu</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="menupage-veg.php">Veg</a></li>
									<li><a class="dropdown-item" href="menupage-nonveg.php">Non-Veg</a></li>
									<li><a class="dropdown-item" href="drinks.php">Drinks</a></li>
                                </ul>
							</li>

							<!-- WEEKLY SPECIAL -->
							<li class="nav-item">
								<a class="nav-link" href="weekly.php">Weekly Special</a>
							</li>

							<!-- Catering & Events -->
							<li class="nav-item">
								<a class="nav-link" href="catering-events.php">Catering & Events</a>
							</li>

							<!-- RESERVATION -->
							<li class="nav-item">
								<a class="nav-link" href="online-delivery.php">Online Delivery</a>
							</li>

							<!-- GALLERY -->
							<li class="nav-item">
								<a class="nav-link" href="gallery.php">Gallery</a>
							</li>

							<!-- CONTACT -->
							<li class="nav-item">
								<a class="nav-link" href="contact-us.php">Contact Us</a>
							</li>

						</ul>
					</div>
				</nav>
			</div>
		</div>

		<!-- CART ICON -->
<div class="header-cart-sec">

    <!-- Mobile Toggle -->
    <div class="mobile-menu-icon d-xl-none">
        <a data-bs-toggle="collapse" href="#navbarSupportedmobile" role="button">
            <i class="fa-solid fa-bars"></i>
        </a>
    </div>

    <!-- CART (DESKTOP ONLY) -->
    <div class="header-cart-btn d-none d-xl-flex">
        <a href="cart-view.php">
            <i class="fa fa-shopping-cart"></i>
            <span class="cart-count">0</span>
        </a>
    </div>

    <!-- BOOKING (DESKTOP ONLY) -->
    <div class="header-cart-sec-first d-none d-xl-block">
        <a href="reservation-1.php" class="booking-btn-text">
            Booking
        </a>
    </div>

</div>



</div>

	</div>

	<!-- MOBILE MENU -->
<div class="mobile-menu-wrap d-lg-none d-block">
    <div class="mb-header-left">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedmobile">
            <span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedmobile">
            <span class="close-menu"><i class="fa-regular fa-xmark"></i></span>

            <nav id='cssmenu'>
                <ul class="open-detail-menu">

                    <?php if (isset($_SESSION['user_name'])): ?>
                        <li style="border-bottom: 1px solid #ffffffff; background: #931A2A;">
                            <a href="profile.php" style="color: #ffffffff; font-weight: 700;">
                                <i class="fa fa-user-circle" style="margin-right:8px;"></i> 
                                Hello, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li><a href="index.php">Home</a></li>

                    <li><a href="javascript:void(0);">About Us</a>
                        <ul class="sub-back-wrap">
                            <li><a href="about-us.php">About</a></li>
                            <li><a href="chefspage2.php">Chefs</a></li>
                            <li><a href="blogpage-1.php">Blog</a></li>
                            <li><a href="faq.php">FAQ</a></li>
                        </ul>
                    </li>

                    <li><a href="javascript:void(0);">Menu</a>
                        <ul class="sub-back-wrap">
                            <li><a href="menupage-veg.php">Veg</a></li>
                            <li><a href="menupage-nonveg.php">Non-Veg</a></li>
                            <li><a href="drinks.php">Drinks</a></li>
                        </ul>
                    </li>

                    <li><a href="weekly-special.php">Weekly Special</a></li>
                    <li><a href="catering-events.php">Catering & Events</a></li>
                    <li><a href="online-delivery.php">Online Delivery</a></li>
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contact-us.php">Contact Us</a></li>
                    
                    <li class="mobile-extra">
                        <a href="cart-view.php" class="mobile-cart">
                            <i class="fa fa-shopping-cart"></i>
                            Cart <span class="mobile-cart-count">0</span>
                        </a>
                    </li>

                    <li class="mobile-extra">
                        <a href="reservation-1.php" class="booking-link">Booking</a>
                    </li>

                    <li class="mobile-auth-text">
                        <?php if (isset($_SESSION['user_name'])): ?>
                            <a href="logout.php" class="mobile-login-link" style="color: #dc3545;">
                                <i class="fa fa-sign-out"></i> Logout
                            </a>
                        <?php else: ?>
                            <a href="login.php" class="mobile-login-link">Sign In</a>
                            <a href="login.php?show=signup" class="mobile-signup-link">Sign Up</a>
                        <?php endif; ?>
                    </li>
                    </ul>
            </nav>
        </div>
    </div>
</div>				</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="header-boder"></div>
</header>

		<!-- Header Section End -->

		<!-- Hero Section Start -->
<section id="menupage-1-section">
    <div class="menupage-1-section-img">
        <div class="menupage-1-overlay"></div>
        <div class="menupage-1-conten text-center">
            <h1 class="menupage-1-hero-txt1 wow fadeInDown" data-wow-duration="1s" data-wow-delay="0.5s">
                Takeaway Order
            </h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center transparent-breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.php">Home</a>
                    </li>
                    <li class="breadcrumb-item active text-white" aria-current="page">Takeaway</li>
                </ol>
            </nav>
        </div>
    </div>
    <div class="menupage1-boder"></div>
</section>
		<!-- Hero Section End -->

		<!-- Takeaway Section Start -->
		<section id="Takeaway-section">
			<div class="container mt-30" style="max-width: 900px; margin-top: 40px; margin-bottom: 40px;">
				<div class="row">
					<!-- Payment Methods -->
					<div class="col-lg-8">
						<div style="background: white; border: 1px solid #e8e8e8; border-radius: 8px; padding: 24px; margin-bottom: 20px; box-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);">
							<div style="margin-bottom: 20px; padding-bottom: 16px; border-bottom: 1px solid #f0f0f0;">
								<h3 style="font-size: 18px; font-weight: 600; color: #333; margin: 0;"><i class="fa fa-credit-card"></i> Select Payment Method</h3>
							</div>

							<div class="payment-methods">
								<!-- UPI Payment -->
								<div class="payment-option">
									<input type="radio" id="upi" name="paymentMethod" value="upi" class="payment-radio">
									<label for="upi" class="payment-label">
										<i class="fa fa-mobile"></i>
										<div>
											<span class="payment-name">UPI</span>
											<span class="payment-desc">Google Pay, PhonePe, Paytm</span>
										</div>
									</label>
									<div class="payment-form" id="upiForm">
										<input type="text" class="form-control" placeholder="Enter UPI ID">
										<button type="button" class="btn btn-payment">Proceed to Pay</button>
									</div>
								</div>

								<!-- Debit/Credit Card -->
								<div class="payment-option">
									<input type="radio" id="card" name="paymentMethod" value="card" class="payment-radio">
									<label for="card" class="payment-label">
										<i class="fa fa-credit-card"></i>
										<div>
											<span class="payment-name">Debit/Credit Card</span>
											<span class="payment-desc">Visa, Mastercard, RuPay</span>
										</div>
									</label>
									<div class="payment-form" id="cardForm">
										<input type="text" class="form-control" placeholder="Card Holder Name">
										<input type="text" class="form-control" placeholder="Card Number (16 digits)" maxlength="16">
										<div class="form-row-small">
											<input type="text" class="form-control" placeholder="MM/YY" maxlength="5">
											<input type="text" class="form-control" placeholder="CVV" maxlength="3">
										</div>
										<button type="button" class="btn btn-payment">Proceed to Pay ₹</button>
									</div>
								</div>

								<!-- Net Banking -->
								<div class="payment-option">
									<input type="radio" id="netbanking" name="paymentMethod" value="netbanking" class="payment-radio">
									<label for="netbanking" class="payment-label">
										<i class="fa fa-university"></i>
										<div>
											<span class="payment-name">Net Banking</span>
											<span class="payment-desc">All major Indian banks</span>
										</div>
									</label>
									<div class="payment-form" id="netbankingForm">
										<select class="form-control">
											<option value="">-- Select Your Bank --</option>
											<option value="sbi">State Bank of India</option>
											<option value="hdfc">HDFC Bank</option>
											<option value="icici">ICICI Bank</option>
											<option value="axis">Axis Bank</option>
										</select>
										<button type="button" class="btn btn-payment">Proceed to Pay ₹</button>
									</div>
								</div>

								<!-- Wallet -->
								<div class="payment-option">
									<input type="radio" id="wallet" name="paymentMethod" value="wallet" class="payment-radio">
									<label for="wallet" class="payment-label">
										<i class="fa fa-wallet"></i>
										<div>
											<span class="payment-name">Digital Wallet</span>
											<span class="payment-desc">Paytm, Amazon Pay</span>
										</div>
									</label>
									<div class="payment-form" id="walletForm">
										<select class="form-control">
											<option value="">-- Select Wallet --</option>
											<option value="paytm">Paytm Wallet</option>
											<option value="amazonpay">Amazon Pay</option>
										</select>
										<button type="button" class="btn btn-payment">Proceed to Pay ₹</button>
									</div>
								</div>

								<!-- Cash on Delivery -->
								<div class="payment-option">
									<input type="radio" id="cod" name="paymentMethod" value="cod" class="payment-radio" checked>
									<label for="cod" class="payment-label">
										<i class="fa fa-money"></i>
										<div>
											<span class="payment-name">Cash on Delivery</span>
											<span class="payment-desc">Pay at counter</span>
										</div>
									</label>
									<div class="payment-form" id="codForm" style="display: block;">
										<p style="color: #28a745; font-size: 13px; margin: 0; padding: 10px; background: #f0f8f0; border-radius: 6px;">Order now, pay at counter.</p>
									</div>
								</div>
							</div>
						</div>

						<!-- Terms & Conditions -->
						<div style="background: white; border: 1px solid #e8e8e8; border-radius: 8px; padding: 24px; margin-bottom: 20px; box-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);">
							<div style="display: flex; align-items: center; margin-bottom: 15px;">
								<input type="checkbox" id="terms" required style="margin-right: 8px;">
								<label for="terms" style="margin: 0; font-size: 14px;">I agree to Terms & Conditions</label>
							</div>
							<button type="button" onclick="placeOrder()" class="btn btn-payment" style="padding: 14px; font-size: 16px;">Place Takeaway Order</button>
						</div>
					</div>

					<!-- Order Summary -->
					<div class="col-lg-4">
						<div style="background: white; border: 1px solid #e8e8e8; border-radius: 8px; padding: 24px; position: sticky; top: 20px; box-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);">
							<h3 style="font-size: 16px; font-weight: 600; color: #333; margin-bottom: 16px;"><i class="fa fa-shopping-bag"></i> Order Summary</h3>
							<div style="margin-bottom: 12px; padding-bottom: 12px; border-bottom: 1px solid #f0f0f0;">
								<div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
									<span style="color: #666; font-size: 14px;">Subtotal:</span>
									<span id="subtotal" style="font-weight: 600; color: #1c1c1c;">₹0</span>
								</div>
								<div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
									<span style="color: #666; font-size: 14px;">Taxes & Charges:</span>
									<span id="taxes" style="font-weight: 600; color: #1c1c1c;">₹0</span>
								</div>
							</div>
							<div style="display: flex; justify-content: space-between; margin-top: 12px;">
								<span style="font-weight: 600; color: #333; font-size: 15px;">Total Amount:</span>
								<span id="totalAmount" style="font-weight: 700; color: #667eea; font-size: 18px;">₹0</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- Takeaway Section End -->

		<!-- Footer Start -->
	<footer class="restaurant-footer">
    <div class="footer-container">

        <!-- Left Top Logo + Text -->
        <div class="footer-brand">
            <img src="assets/images/Homepage1/footer-logo.png" alt="Restaurant Logo" class="footer-logo">
            <p class="footer-desc">
                A premium dining experience with handcrafted dishes, fresh ingredients, 
                and an elegant ambiance. Your comfort is our priority.
            </p>
        </div>

        <!-- Quick Links -->
        <div class="footer-links">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="reservation-1.php">Reserve a Table</a></li>
                
                <li><a href="#menupage-veg.php">Explore Menu</a></li>
                <li><a href="#weekly.php">Special Offers</a></li>
                <li><a href="#catering-events.php">Catering Service</a></li>
            </ul>
        </div>

        <!-- Contact Section -->
        <div class="footer-contact">
            <h4>Contact Us</h4>
            <p> 123 Food Street, Chennai</p>
            <p> +91 98765 43210</p>
            <p>✉ support@restaurant.com</p>

            <div class="footer-social">
                <a href="#"><i class="fa fa-facebook"></i></a>
                <a href="#"><i class="fa fa-instagram"></i></a>
                <a href="#"><i class="fa fa-twitter"></i></a>
                <a href="#"><i class="fa fa-youtube"></i></a>
            </div>
        </div>

        <!-- Working Hours -->
        <div class="footer-hours">
            <h4>Working Hours</h4>
            <p>Mon – Fri : 09:00 - 22:00</p>
            <p>Saturday : 11:00 - 23:30</p>
            <p>Sunday : 11:00 - 23:00</p>
        </div>

    </div>

    <div class="footer-bottom">
        <p>© 2025 Your Restaurant Name. All Rights Reserved.</p>
        <div class="footer-bottom-links">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Service</a>
        </div>
    </div>
</footer>
		<!-- Footer Section End -->
		<!-- Fixed Search Bar Start -->
		<div>
			<div class="fixed-serach-icon ">
				<div class="fixed-search ">
					<a href="javascript:void(0)">
						<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<mask id="mask0_504_17203" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
								<rect width="24" height="24" fill="white"></rect>
							</mask>
							<g mask="url(#mask0_504_17203)">
								<circle cx="11.7666" cy="11.7666" r="8.98856" stroke="#F5E6D3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
								<path d="M18.0183 18.4851L21.5423 22" stroke="#F5E6D3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
							</g>
						</svg>
					</a>
				</div>
			</div> 
			<div class="search-popup">
				<span class="search-back-drop"></span>
				<button class="close-search"><span class="fa fa-times"></span></button>
				<div class="search-inner">
					<form method="post" action="index.php">
						<div class="form-group">
							<input type="search" name="search-field" value="" placeholder="Search..." required="">
							<button type="submit"><i class="fa fa-search"></i></button>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- Fixed Search Bar End -->
		<!-- Hero Video Modal Start -->
		<div class="modal fade homepage-video-modal" id="hero-video-modal">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<video class="video-sec" controls="" loop="" muted="" autoplay="">
							<source src="assets/images/Homepage1/video.mp4" type="video/mp4">
							</video>
						</div>
					</div>
				</div>
			</div>
			<!-- Hero Video Modal End -->
			<!--Scroll Top to Bottom Start -->
			<div class="scroll-top" data-scroll="up">		
			</div>
			<!--Scroll Top to Bottom  End -->
		</div>
		<script src="assets/js/jquery-min-3.6.0.js"></script>
		<script src="assets/js/slick.min.js"></script>
		<script src="assets/js/bootstrap.bundle.min.js"></script>
		<script src="assets/js/aos.js"></script>
		<script src="assets/js/jquery-ui.min.js"></script>
		<script src="assets/js/datepicker.js"></script>
		<script src="assets/js/wow.min.js"></script>
		<script src="assets/js/photoswipe.min.js"></script>
		<script src="assets/js/photoswipe-ui-default.min.js"></script>
		<script src="assets/js/gallery-popup.js"></script>
		<script src="assets/js/TweenMax.min.js"></script>
		<script src="assets/js/ScrollMagic.js"></script>
		<script src="assets/js/animation.gsap.min.js"></script>
		<script src="assets/js/scolling.js"></script>
		<script src="assets/js/custom.js"></script>
</body>
</html>

		<!-- Footer End -->

    <script src="assets/js/jquery-min-3.6.0.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js" defer></script>
    <script>
        // 3. SPEED OPTIMIZATION: Immediate Preloader Removal
        // This ensures the screen doesn't stay white/loading if external JS is slow
        window.addEventListener('load', function() {
            const preloader = document.getElementById('preloader');
            if(preloader) {
                preloader.style.opacity = '0';
                setTimeout(() => { preloader.style.display = 'none'; }, 300);
            }
        });

        // Payment Toggle Logic
        document.addEventListener('DOMContentLoaded', function() {
            // Radio button logic
            const radios = document.querySelectorAll('.payment-radio');
            radios.forEach(radio => {
                radio.addEventListener('change', function() {
                    // Hide all forms
                    document.querySelectorAll('.payment-form').forEach(f => f.style.display = 'none');
                    // Show selected form
                    const selectedForm = document.getElementById(this.value + 'Form');
                    if(selectedForm) selectedForm.style.display = 'block';
                });
            });

            // Load Cart Data
            loadCart();
        });

        function loadCart() {
            const formData = new FormData();
            formData.append('action', 'fetch');

            fetch('cart-actions.php', { method: 'POST', body: formData })
            .then(r => r.json())
            .then(data => {
                if (data.success && data.items && data.items.length > 0) {
                    let subtotal = 0;
                    data.items.forEach(item => {
                        subtotal += (parseFloat(item.product_price) || 0) * (parseInt(item.quantity) || 1);
                    });
                    const taxes = Math.round(subtotal * 0.05);
                    const total = subtotal + taxes;

                    document.getElementById('subtotal').textContent = '₹' + subtotal;
                    document.getElementById('taxes').textContent = '₹' + taxes;
                    document.getElementById('totalAmount').textContent = '₹' + total;
                }
            })
            .catch(err => console.log('Cart empty or error'));
        }

        function placeOrder() {
            if (!document.getElementById('terms').checked) {
                alert('Please accept terms and conditions');
                return;
            }
            alert('✅ Order Placed Successfully!');
            setTimeout(() => { window.location.href = 'index.php'; }, 2000);
        }
    </script>
    
</body>
</html>