<?php
require_once 'db_connect.php';

// Execute SQL file to create tables
$sqlFile = 'database_schema.sql';

if (file_exists($sqlFile)) {
    $sql = file_get_contents($sqlFile);
    
    // Split by semicolon and execute each statement
    $statements = array_filter(array_map('trim', explode(';', $sql)));
    
    foreach ($statements as $statement) {
        if (!empty($statement)) {
            if (!$conn->query($statement)) {
                die("Error executing: " . $conn->error);
            }
        }
    }
    
    echo "✓ Database tables created successfully!<br>";
    echo "✓ orders table created<br>";
    echo "✓ order_items table created<br>";
} else {
    die("database_schema.sql not found");
}

$conn->close();
?>
