﻿<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Bermiz</title>
	<link rel="icon" href="assets/images/favicon/icon.png">
	<link href="../../../css2?family=Elsie&display=swap" rel="stylesheet">
	<link href="../../../css2-1?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/all.min.css">
	<link rel="stylesheet" href="assets/css/slick.css">
	<link rel="stylesheet" href="assets/css/aos.css">
	<link rel="stylesheet" href="assets/css/animate.css">
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/photoswipe.min.css">
	<link rel="stylesheet" href="assets/css/default-skin.min.css">
	<link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/media-query.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<body>
	<div class="site_content">
		<!-- Preloader Start -->
<!-- ===== RESTAURANT PRELOADER ===== -->
<div id="preloader">

  <!-- INLINE SVG COFFEE -->
  <svg width="140" height="140"
       viewBox="0 0 140 140"
       xmlns="http://www.w3.org/2000/svg">

    <!-- Cup body -->
    <rect x="40" y="65" width="60" height="35"
          rx="8" fill="#78350f"/>

    <!-- Cup handle -->
    <path d="M100 72 Q115 82 100 92"
          fill="none"
          stroke="#78350f"
          stroke-width="5"/>

    <!-- Saucer -->
    <ellipse cx="70" cy="105" rx="40" ry="6"
             fill="#e5e7eb"/>

    <!-- Steam 1 -->
    <path d="M55 60 C45 50 65 40 55 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 2 -->
    <path d="M70 60 C60 50 80 40 70 30"
          stroke="#f59e0b"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.3s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 3 -->
    <path d="M85 60 C75 50 95 40 85 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.6s"
               repeatCount="indefinite"/>
    </path>

    <!-- Text -->
    <text x="70" y="130"
          text-anchor="middle"
          font-size="11"
          fill="#92400e">
      Brewing Coffee…
    </text>

  </svg>

</div>

		<!-- Preloader End --><!-- ================= TOP INFO HEADER ================= -->
<div class="top-header">
    <div class="container-fluid top-header-inner">

        <div class="welcome-text">
            Welcome to Bermiz Restaurant & Catering Services
        </div>

        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-twitter"></i></a>
            <a href="#"><i class="fa-brands fa-instagram"></i></a>
            <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
            <a href="#"><i class="fa-brands fa-youtube"></i></a>
        </div>

    </div>
</div>

<!-- ================= CONTACT STRIP ================= -->
<div class="top-header-container">
    
    <div class="logo-area">
        <a href="index.php">
        <img src="assets/images/Homepage1/logo.png" class="strip-logo">
		</a>
    </div>

    <div class="header-right-side">
        
        <div class="contact-group">
            
            <div class="contact-item">
                <i class="fas fa-phone-alt contact-icon"></i> <div>
                    <h5 class="contact-title">Call Us:</h5>
                    <p class="contact-text">+91 98765 43210</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-envelope contact-icon"></i>
                <div>
                    <h5 class="contact-title">Mail Us:</h5>
                    <p class="contact-text">bermizrestaurant@gmail.com</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-map-marker-alt contact-icon"></i>
                <div>
                    <h5 class="contact-title">Location:</h5>
                    <p class="contact-text">Coimbatore, Tamil Nadu</p>
                </div>
            </div>

        </div> 
 <div class="auth-actions" id="authContainer">
    <?php if (isset($_SESSION['user_name'])): ?>
        
        <div class="user-menu-dropdown">
            <button class="user-btn">
                <i class="fa fa-user-circle"></i> <span class="u-name"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <i class="fa fa-caret-down"></i> </button>

            <div class="dropdown-content">
                <a href="profile.php">
                    <i class="fa fa-id-card"></i> View Profile
                </a>
                <a href="logout.php" class="logout-item">
                    <i class="fa fa-sign-out"></i> Logout
                </a>
            </div>
        </div>

    <?php else: ?>

        <a href="login.php" class="btn-auth btn-login">Sign In</a>
        <a href="login.php?show=signup" class="btn-auth btn-signup">Sign Up</a>

    <?php endif; ?>
</div>

    </div>
	<style>/* ========================================= */
/* TOP HEADER LAYOUT                        */
/* ========================================= */
</style>
</div>
	
		<!-- Header Section Start -->
<header id="header-homepage1" class="menupage1-header">
	<div class="header-full-section">
		<!-- Logo -->
		<div class="header-logo">
			<a href="index.php">
				<img src="assets/images/Homepage1/logo.png" alt="header-logo" class="homepage1-logo">
			</a>
		</div>


		<!-- Desktop Menu -->
		<div class="header-menu-wrap">
			<div class="header-nav-wrap">
				<nav class="navbar navbar-expand-xl p-0">
					<div class="navbar-collapse" id="navbarSupportedContent">
						<ul class="navbar-nav mx-auto align-items-center">

							<!-- HOME -->
							<li class="nav-item">
								<a class="nav-link" href="index.php">Home</a>
							</li>

							<!-- ABOUT US DROPDOWN -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">About Us</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="about-us.php">About</a></li>
									<li><a class="dropdown-item" href="chefspage2.php">Chefs</a></li>
									<li><a class="dropdown-item" href="blogpage-1.php">Blog</a></li>
									<li><a class="dropdown-item" href="faq.php">FAQ</a></li>
								</ul>
							</li>

							<!-- MENU -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">Menu</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="menupage-veg.php">Veg</a></li>
									<li><a class="dropdown-item" href="menupage-nonveg.php">Non-Veg</a></li>
									<li><a class="dropdown-item" href="drinks.php">Drinks</a></li>
                                </ul>
							</li>

							<!-- WEEKLY SPECIAL -->
							<li class="nav-item">
								<a class="nav-link" href="weekly.php">Weekly Special</a>
							</li>

							<!-- Catering & Events -->
							<li class="nav-item">
								<a class="nav-link" href="catering-events.php">Catering & Events</a>
							</li>

							<!-- RESERVATION -->
							<li class="nav-item">
								<a class="nav-link" href="online-delivery.php">Online Delivery</a>
							</li>

							<!-- GALLERY -->
							<li class="nav-item">
								<a class="nav-link" href="gallery.php">Gallery</a>
							</li>

							<!-- CONTACT -->
							<li class="nav-item">
								<a class="nav-link" href="contact-us.php">Contact Us</a>
							</li>

						</ul>
					</div>
				</nav>
			</div>
		</div>

		<!-- CART ICON -->
<div class="header-cart-sec">

    <!-- Mobile Toggle -->
    <div class="mobile-menu-icon d-xl-none">
        <a data-bs-toggle="collapse" href="#navbarSupportedmobile" role="button">
            <i class="fa-solid fa-bars"></i>
        </a>
    </div>

    <!-- CART (DESKTOP ONLY) -->
    <div class="header-cart-btn d-none d-xl-flex">
        <a href="cart-view.php">
            <i class="fa fa-shopping-cart"></i>
            <span class="cart-count">0</span>
        </a>
    </div>

    <!-- BOOKING (DESKTOP ONLY) -->
    <div class="header-cart-sec-first d-none d-xl-block">
        <a href="reservation-1.php" class="booking-btn-text">
            Booking
        </a>
    </div>

</div>



</div>

	</div>

	<!-- MOBILE MENU -->
	<div class="mobile-menu-wrap d-lg-none d-block">
		<div class="mb-header-left">
			<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedmobile">
				<span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
			</button>

			<div class="collapse navbar-collapse" id="navbarSupportedmobile">
				<span class="close-menu"><i class="fa-regular fa-xmark"></i></span>

				<nav id='cssmenu'>
					<ul class="open-detail-menu">

						<li><a href="index.php">Home</a></li>

						<li><a href="javascript:void(0);">About Us</a>
							<ul class="sub-back-wrap">
								<li><a href="about-us.php">About</a></li>
								<li><a href="chefspage2.php">Chefs</a></li>
								<li><a href="blogpage-1.php">Blog</a></li>
								<li><a href="faq.php">FAQ</a></li>
							</ul>
						</li>

						<li><a href="javascript:void(0);">Menu</a>
							<ul class="sub-back-wrap">
								<li><a href="menupage-veg.php">Veg</a></li>
								<li><a href="menupage-nonveg.php">Non-Veg</a></li>
								<li><a href="drinks.php">Drinks</a></li>
							</ul>
						</li>

						<li><a href="weekly-special.php">Weekly Special</a></li>
						<li><a href="catering-events.php">Catering & Events</a></li>
						<li><a href="online-delivery.php">online Delivery</a></li>
						<li><a href="gallery.php">Gallery</a></li>
						<li><a href="contact-us.php">Contact Us</a></li>
						
<!-- MOBILE CART -->
<li class="mobile-extra">
    <a href="cart-view.php" class="mobile-cart">
        <i class="fa fa-shopping-cart"></i>
        Cart <span class="mobile-cart-count">0</span>
    </a>
</li>

<!-- MOBILE BOOKING -->
<li class="mobile-extra">
    
		<a href="reservation-1.php" class="booking-link">Booking</a>

      
	
</li>
<li class="mobile-auth-text">
    <a href="login.php" class="mobile-login-link">Sign In</a>
     <a href="login.php?show=signup" class="mobile-signup-link">Sign Up</a>
</li>
					</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="header-boder"></div>
</header>



		<!-- Header Section End -->
		<!-- Hero Section Start -->
<section id="menupage-1-section">
    <div class="menupage-1-section-img">
        <div class="menupage-1-overlay"></div>
        
        <div class="menupage-1-conten text-center"> <h1 class="menupage-1-hero-txt1 wow fadeInDown" data-wow-duration="1s" data-wow-delay="0.5s">
                Reservation
            </h1>

            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center transparent-breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.php">
                            <span class="home-icon">
                                <svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <mask id="mask0_564_5237" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                                        <rect width="24" height="24" fill="white"></rect>
                                    </mask>
                                    <g mask="url(#mask0_564_5237)">
                                        <path d="M9.15722 20.7714V17.7047C9.1572 16.9246 9.79312 16.2908 10.581 16.2856H13.4671C14.2587 16.2856 14.9005 16.9209 14.9005 17.7047V17.7047V20.7809C14.9003 21.4432 15.4343 21.9845 16.103 22H18.0271C19.9451 22 21.5 20.4607 21.5 18.5618V18.5618V9.83784C21.4898 9.09083 21.1355 8.38935 20.538 7.93303L13.9577 2.6853C12.8049 1.77157 11.1662 1.77157 10.0134 2.6853L3.46203 7.94256C2.86226 8.39702 2.50739 9.09967 2.5 9.84736V18.5618C2.5 20.4607 4.05488 22 5.97291 22H7.89696C8.58235 22 9.13797 21.4499 9.13797 20.7714V20.7714" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </g>
                                </svg>
                            </span>
                            Home
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-white" aria-current="page">Reservation</li>
                </ol>
            </nav>

        </div>
    </div>
    <div class="menupage1-boder"></div>
</section>
		<!-- Hero Section End -->
		<!-- Reservation Content Section Start -->
		<section id="reservation-sec2">
			<div class="menupage-1-reser-overlay2"></div>
			<div class="container">
				<div class="reservation-sec2-full" data-aos="fade-down">
					<div class="reser-top">
						
						<h2 class="reser-txt2-menu2">Book A Table</h2>
						<p class="reser-txt3-menu2">You can Call Us directly at <a href="tel:+01(234)5678899"><span class="menupage1-no2">+01 (234) 567 8899</span></a></p>
					</div>
					<div class="reser-bottom-sec">
    <form class="menupage1-form" method="POST" action="reservation.php">
        <div class="form-menupage1">
            <div class="single-input-form-menupage1">
                <input type="text" name="name" placeholder="Name" class="menupage1-form-custom name-icon" required>
            </div>
            <div class="single-input-form-menupage1">
                <input type="email" name="email" placeholder="Email Address" class="menupage1-form-custom email-icon" required>
            </div>
            <div class="single-input-form-menupage1">
                <input type="tel" name="number" placeholder="Phone Number" class="menupage1-form-custom mobile-icon" required>
            </div>
            <div class="single-input-form-menupage1">
                <select name="guests" class="menupage1-form-custom arrow-icon">
                    <option value="1 Person">1 Person</option>
                    <option value="2 Persons">2 Persons</option>
                    <option value="3 Persons">3 Persons</option>
                    <option value="4 Persons">4 Persons</option>
                </select>
            </div>
            <div class="single-input-form-menupage1">
                <input type="text" name="reservation_date" id="datepicker" autocomplete="off" placeholder="dd/mm/yy" class="menupage1-form-custom arrow-icon" required>
            </div>
            <div class="single-input-form-menupage1">
                <select name="reservation_time" class="menupage1-form-custom arrow-icon">
                    <option value="08:00 am">08:00 am</option>
                    <option value="09:00 am">09:00 am</option>
                    <option value="10:00 am">10:00 am</option>
                    <option value="07:00 pm">07:00 pm</option>
                </select>
            </div>
        </div>
      <div class="menupage-1-book-now-btn">
    <?php if (isset($_SESSION['user_id'])): ?>
        <button type="submit" class="btn-book-now">
            Book Now
        </button>
    <?php else: ?>
        <button type="button" class="btn-book-now" onclick="scrollToLogin()">
            Book Now
        </button>
    <?php endif; ?>
</div>
    </form>
</div>
				</div>
				<script>function scrollToLogin() {
    // 1. Alert the user (Optional)
    alert("Please sign in first to book a table.");

    // 2. Find your login section or the login button at the top
    // Replace '#login-area' with your actual sign-in section ID or class
    const loginSection = document.querySelector('#login-area'); 

    if (loginSection) {
        loginSection.scrollIntoView({ behavior: 'smooth' });
    } else {
        // Fallback: Scroll to top of the page if section not found
        window.scrollTo({ top: 0, behavior: 'smooth' });
    }
}</script><style>/* Style for both the real and the placeholder button */
.btn-book-now {
    position: relative;
    padding: 15px 20px;
    background: transparent;
    color: #EAB308; /* Gold Text */
    border: 2px solid #EAB308; /* Gold Border */
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 2px;
    cursor: pointer;
    overflow: hidden;
    transition: 0.4s;
    z-index: 1;
}
/* Add to assets/css/media-query.css or style.css */
@media (max-width: 768px) {
    /* Push the form above the overlay */
    .reservation-sec2-full {
        position: relative;
        z-index: 1; 
    }
    
    /* Ensure the overlay stays in the back */
    .menupage-1-reser-overlay2 {
        z-index: 1;
    }
}
.menupage-1-reser-overlay2{
    position: absolute;
    width: 100%;
    height: 100%;
    left: 0;
    right: 0;
    bottom: 0;
    top: 0;
    background: #F5E6D3;
}
.menupage1-form-custom{
    width: 370px;
    height: 64px;
    border: 1px solid #000000ff;
    color:#FFF;
    font-size: 18px;
    font-family: Lexend;
    line-height: 24px;
    padding: 20px;
    background-color: rgba(21, 11, 11, 0.2);
}
.menupage1-no2{
    color:#931A2A;
}
.reser-txt1-menu2 {
    color:#931A2A  	;
    text-align: center;
    font-size: 20px;
    font-family: Lexend;
    line-height: 24px;
    text-transform: uppercase;
}.reser-txt3-menu2 {
    color: #4a1515ff;
    text-align: center;
    font-size: 18px;
    font-family: Lexend;
    margin-top: 40px;
}.reser-txt2-menu2 {
    color: #5a1a1aff;
    text-align: center;
    font-size: 60px;
    font-family: Elsie;
    line-height: 70px;
    margin-top: 20px;
}
#reservation-sec2{
	background-color: #F5E6D3;
    position: relative;
    padding: 100px 0;
    height: 740px;
}
/* Mobile Responsive Styles for Reservation Section */
@media only screen and (max-width: 768px) {
    
    /* 1. Section Spacing */
    #reservation-sec2 {
        padding: 50px 0; /* Reduces top/bottom padding */
        height: auto;    /* Allows section to grow with content */
    }

    .reservation-sec2-full {
        width: 90%;      /* Adds side margins so it doesn't touch edges */
        margin: 0 auto;  /* Centers the container */
        padding: 20px;   /* Reduces internal padding */
    }

    /* 2. Typography Adjustments */
    .reser-txt2-menu2 {
        font-size: 28px !important; /* Smaller heading for mobile */
        line-height: 1.2;
        margin-bottom: 10px;
    }

    .reser-txt3-menu2 {
        font-size: 15px !important; /* Readable text size */
        margin-bottom: 25px;
    }
    
    .menupage1-no2 {
        font-size: 16px; /* Phone number size */
    }

    /* 3. Form Layout - Stack inputs vertically */
    .form-menupage1 {
        display: flex;       /* Use flexbox */
        flex-direction: column; /* Stack items top to bottom */
        gap: 15px;           /* Space between inputs */
    }

    .single-input-form-menupage1 {
        width: 100%;         /* Force full width */
        margin: 0;           /* Reset margins */
    }

    /* 4. Input Field Styling */
    .menupage1-form-custom {
        width: 100%;         /* Ensure input fills the container */
        height: 50px;        /* Taller inputs are easier to tap on phones */
        font-size: 16px;     /* Prevents iOS from zooming in when typing */
        padding: 0 15px;     /* Add padding for text */
    }

    /* 5. Button Adjustments */
    .menupage-1-book-now-btn {
        margin-top: 10px;
        text-align: center;
    }

    .btn-book-now {
        width: 100%;         /* Full width button looks better on mobile */
        padding: 15px;       /* Large touch target */
        font-size: 18px;
    }
}
/* The sliding background layer */
.btn-book-now::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 0%; /* Starts empty */
    height: 100%;
    background: #EAB308;
    z-index: -1; /* Puts it behind text */
    transition: 0.4s cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-book-now:hover {
    color: #000; /* Text turns black for contrast */
}

.btn-book-now:hover::before {
    width: 100%; /* Slides to fill */
}</style>
			</div>
				</section>
		<!-- Reservation Content Section End -->
		<!-- Mobile App Section Start -->
		<section id="reservarion1-fast-ordering-sec">
			<div class="container line reservarion1-fast-ordering-sec">
				<span class="line-3"></span>
				<span class="line-4"></span>
				<span class="line-5"> </span>
				<div class="fast-ordering-sec-full">
					<div class="fast-ordering-left" data-aos="fade-right">
						<div class="fast-top-sec">
							<p class="fast-order-txt1"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>Fast ORDERING<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
						</div>
						<h2 class="fast-order-txt2">Download Our Mobile App</h2>
						<p class="fast-order-txt3">Vitae neque libero ullamcorper gravida fusce donec feugiat massa dui. Turpis massa et ipsum orci, sem commodo. Sapien hendrerit cursus eros, netus lacus, risus in quis vitae.</p>
						<div class="fast-otder-media-sec">
							<div>
								<a href="javascript:void(0)"><img src="assets/images/Homepage1/google.png" alt="google-img" class="img-fluid"></a>
							</div>
							<div>
								<a href="javascript:void(0)"><img src="assets/images/Homepage1/appstrore.png" alt="appstore-img" class="img-fluid"></a>
							</div>
						</div>
					</div>
					<div class="fast-ordering-right" data-aos="fade-left">
						<img src="assets/images/Homepage1/fast-order-img.png" alt="mobile-img" class="img-fluid">
					</div>
				</div>
			</div>
		</section>
		<!-- Mobile App Section End -->
		<!-- Gallery Section Start -->
		<section id="homepage1-gallery-sec" class="reservation-1-bottom">
			<div class="custom-lines-bg">
				<div class="line container">
					<span class="line-3"></span>
					<span class="line-4"></span>
					<span class="line-5"> </span>
				</div>
			</div>
			<div class="container reservation-1-bottom1 line">
				<span class="line-3"></span>
				<span class="line-4"></span>
				<span class="line-5"> </span>
				<div class="gallery-top-sec">
					<p class="gallery-txt1"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>OUR GALLERY<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
					<h2 class="gallery-txt">Bermiz Hot Dishes</h2>
				</div>
			</div>
			<div class="gallery-food-slider wow fadeInUp" id="gallery" data-wow-duration="0.5s">
				<div class="swiper-wrapper gallery-item-sec">
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-1.png" data-caption="Kebab" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-1.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-1.png" data-caption="Kebab" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Kebab</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-2.png" data-caption="Finger Roll" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-2.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-2.png" data-caption="Finger Roll" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Finger Roll</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>	
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-3.png" data-caption="Chicken" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-3.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-3.png" data-caption="Chicken" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Chicken</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>	
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-4.png" data-caption="Pasta" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-4.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-4.png" data-caption="Pasta" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Pasta</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-5.png" data-caption="Roll" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-5.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-5.png" data-caption="Roll" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Roll</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>
					</div>
					<div class="swiper-slide gallery-slide">
						<div class="gallery-item">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-1.png" data-caption="Kebab" data-width="600" data-height="800">
								<img src="assets/images/Homepage1/gallery-1.png" class="img-fluid" alt="gallery item">
								<div class="content-overlay-home2"></div>
							</a>		
						</div>
						<div class="home2-gallery-overlay fadeIn-bottom fadeIn-right">
							<a class="gallery-popup" href="assets/images/Homepage1/gallery-1.png" data-caption="Kebab" data-width="600" data-height="800">
								<p class="gallery-overlay-txt1">Kebab</p>
								<div class="home2-search-icon">
									<svg width="40" height="40" viewbox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
										<mask style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="40" height="40">
											<rect width="40" height="40" fill="white"></rect>
										</mask>
										<g mask="url(#mask0_540_5055)">
											<circle cx="19.6111" cy="19.6108" r="14.9809" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
											<path d="M30.0305 30.8086L35.9039 36.6667" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
										</g>
									</svg>
								</div>
							</a>
						</div>
					</div>
				</div>
			</div>
			<div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="pswp__bg"></div>
				<div class="pswp__scroll-wrap">
					<div class="pswp__container">
						<div class="pswp__item"></div>
						<div class="pswp__item"></div>
						<div class="pswp__item"></div>
					</div>
					<div class="pswp__ui pswp__ui--hidden">
						<div class="pswp__top-bar">
							<!--  Controls are self-explanatory. Order can be changed. -->
							<div class="pswp__counter"></div>
							<button class="pswp__button pswp__button--close" title="Close (Esc)"></button>
							<button class="pswp__button pswp__button--share" title="Share"></button>
							<button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>
							<button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>
							<div class="pswp__preloader">
								<div class="pswp__preloader__icn">
									<div class="pswp__preloader__cut">
										<div class="pswp__preloader__donut"></div>
									</div>
								</div>
							</div>
						</div>
						<div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
							<div class="pswp__share-tooltip"></div>
						</div>
						<button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)">
						</button>
						<button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)">
						</button>
						<div class="pswp__caption">
							<div class="pswp__caption__center"></div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- Gallery Section End -->
		 
		<!-- Testimonial Section Start -->
		<section id="menupage-1-testimonials-sec" class="res1-testimonial-sec">
			<div class="menupage-1-testimo-overlay"></div>
			<div class="container line">
				<span class="line-3"></span>
				<span class="line-4"></span>
				<span class="line-5"> </span>
				<div class="home2-testimonials-sec-full">
					<div class="home2-test-top">
						<p class="homemenu-txt1 wow fadeInUp  " data-wow-duration="0.5s"><span class="pr-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span>TESTIMONIALS<span class="pf-10"><img src="assets/images/Homepage1/yellow-star.png" alt="yellow-star"></span></p>
						<h2 class="homemenu-txt2 homemenu-txt22 wow fadeInUp " data-wow-duration="1.4s">The Reviews Of Customers When Coming To Our Restaurant!</h2>
					</div>
					<div class="home2-test-bottom wow fadeInUp" data-wow-duration="1.6s">
						<div class="home2-test-bottom-full">
							<div class="home2-test-slider">
								<p class="home2-test-txt1">“ This bermiz restaurant has left the best impressions! Hospitable hosts, delicious dishes, beautiful presentation, wide wine
								list and wonderful dessert. I recommend to everyone! I would like to come back here again and again.”</p>
								<p class="home2-test-txt2">PAUL SERGEO</p>
							</div>
							<div class="home2-test-slider">
								<p class="home2-test-txt1">“ This bermiz restaurant has left the best impressions! Hospitable hosts, delicious dishes, beautiful presentation, wide wine
								list and wonderful dessert. I recommend to everyone! I would like to come back here again and again.”</p>
								<p class="home2-test-txt2">PAUL SERGEO</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section> 
		<!-- Testimonial Section End -->
		<!-- Footer Section Start -->
<footer class="restaurant-footer">
    <div class="footer-container">

        <!-- Left Top Logo + Text -->
        <div class="footer-brand">
            <img src="assets/images/Homepage1/footer-logo.png" alt="Restaurant Logo" class="footer-logo">
            <p class="footer-desc">
                A premium dining experience with handcrafted dishes, fresh ingredients, 
                and an elegant ambiance. Your comfort is our priority.
            </p>
        </div>

        <!-- Quick Links -->
        <div class="footer-links">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="reservation-1.php">Reserve a Table</a></li>
                
                <li><a href="#menupage-veg.php">Explore Menu</a></li>
                <li><a href="#weekly.php">Special Offers</a></li>
                <li><a href="#catering-events.php">Catering Service</a></li>
            </ul>
        </div>

        <!-- Contact Section -->
        <div class="footer-contact">
            <h4>Contact Us</h4>
            <p> 123 Food Street, Chennai</p>
            <p> +91 98765 43210</p>
            <p>✉ support@restaurant.com</p>

            <div class="footer-social">
                <a href="#"><i class="fa fa-facebook"></i></a>
                <a href="#"><i class="fa fa-instagram"></i></a>
                <a href="#"><i class="fa fa-twitter"></i></a>
                <a href="#"><i class="fa fa-youtube"></i></a>
            </div>
        </div>

        <!-- Working Hours -->
        <div class="footer-hours">
            <h4>Working Hours</h4>
            <p>Mon – Fri : 09:00 - 22:00</p>
            <p>Saturday : 11:00 - 23:30</p>
            <p>Sunday : 11:00 - 23:00</p>
        </div>

    </div>

    <div class="footer-bottom">
        <p>© 2025 Your Restaurant Name. All Rights Reserved.</p>
        <div class="footer-bottom-links">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Service</a>
        </div>
    </div>
</footer>
		<!-- Footer Section End -->
		<!-- Fixed Search Bar Start -->
		<div>
			<div class="fixed-serach-icon ">
				<div class="fixed-search ">
					<a href="javascript:void(0)">
						<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<mask id="mask0_504_17203" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
								<rect width="24" height="24" fill="white"></rect>
							</mask>
							<g mask="url(#mask0_504_17203)">
								<circle cx="11.7666" cy="11.7666" r="8.98856" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
								<path d="M18.0183 18.4851L21.5423 22" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
							</g>
						</svg>
					</a>
				</div>
			</div> 
			<div class="search-popup">
				<span class="search-back-drop"></span>
				<button class="close-search"><span class="fa fa-times"></span></button>
				<div class="search-inner">
					<form method="post" action="index.php">
						<div class="form-group">
							<input type="search" name="search-field" value="" placeholder="Search..." required="">
							<button type="submit"><i class="fa fa-search"></i></button>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- Fixed Search Bar End -->
		<!--Scroll Top to Bottom Start -->
		<div class="scroll-top" data-scroll="up" style="">		
		</div>
		<!--Scroll Top to Bottom  End -->
	</div>
	<script src="assets/js/jquery-min-3.6.0.js"></script>
	<script src="assets/js/slick.min.js"></script>
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<script src="assets/js/jquery-ui.min.js"></script>
	<script src="assets/js/datepicker.js"></script>
	<script src="assets/js/aos.js"></script>
	<script src="assets/js/wow.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script src="assets/js/photoswipe.min.js"></script>
	<script src="assets/js/photoswipe-ui-default.min.js"></script>
	<script src="assets/js/gallery-popup.js"></script>
	<script src="assets/js/custom.js"></script>
</body>
</html>