<?php
session_start();

/* 🔐 Backend protection */
if (!isset($_SESSION['user_id'])) {
    die("Unauthorized access");
}

/* ===============================
   LOAD PHPMailer
================================ */
require_once __DIR__ . '/PHPMailer/src/PHPMailer.php';
require_once __DIR__ . '/PHPMailer/src/SMTP.php';
require_once __DIR__ . '/PHPMailer/src/Exception.php';

/* ===============================
   DATABASE CONNECTION
================================ */
$conn = new mysqli("localhost", "root", "", "bermiz_db");
if ($conn->connect_error) {
    die("Database connection failed");
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $userId  = $_SESSION['user_id'];
    $name    = $_POST['name'];
    $email   = $_POST['email'];
    $phone   = $_POST['number'];
    $message = $_POST['comment'];

    /* ===============================
       SAVE TO DATABASE
    ================================ */
    $stmt = $conn->prepare(
        "INSERT INTO contact_messages (user_id, name, email, phone, message)
         VALUES (?, ?, ?, ?, ?)"
    );
    $stmt->bind_param("issss", $userId, $name, $email, $phone, $message);
    $stmt->execute();

    /* ===============================
       SEND EMAIL TO ADMIN
    ================================ */
    $mail = new \PHPMailer\PHPMailer\PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'pradeepnatarajan400@gmail.com';
        $mail->Password   = 'jhaz xdav sibf gufm'; // already verified
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        $mail->setFrom('pradeepnatarajan400@gmail.com', 'Bermiz Website');
        $mail->addAddress('badpradii@gmail.com');
        $mail->addReplyTo($email, $name);

        $mail->isHTML(true);
        $mail->Subject = "📩 New Contact Message";

        $mail->Body = "
        <h3>New Contact Message</h3>
        <p><b>Name:</b> $name</p>
        <p><b>Email:</b> $email</p>
        <p><b>Phone:</b> $phone</p>
        <p><b>Message:</b><br>$message</p>
        ";

        $mail->send();

        echo "<script>
                alert('Message sent successfully! We will contact you soon.');
                window.location.href='index.php';
              </script>";

    } catch (Exception $e) {
        echo 'Mailer Error: ' . $e->getMessage();
    }
}

$conn->close();
?>
