<?php
session_start();
?><!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Bermiz</title>
	<link rel="icon" href="assets/images/favicon/icon.png">
	<link href="../../../css2?family=Elsie&display=swap" rel="stylesheet">
	<link href="../../../css2-1?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/all.min.css">
	<link rel="stylesheet" href="assets/css/slick.css">
	<link rel="stylesheet" href="assets/css/aos.css">
	<link rel="stylesheet" href="assets/css/animate.css">
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/photoswipe.min.css">
	<link rel="stylesheet" href="assets/css/default-skin.min.css">
	<link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/media-query.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<body>
	<div class="site_content">
		<!-- Preloader Start -->
<!-- ===== RESTAURANT PRELOADER ===== -->
<div id="preloader">

  <!-- INLINE SVG COFFEE -->
  <svg width="140" height="140"
       viewBox="0 0 140 140"
       xmlns="http://www.w3.org/2000/svg">

    <!-- Cup body -->
    <rect x="40" y="65" width="60" height="35"
          rx="8" fill="#78350f"/>

    <!-- Cup handle -->
    <path d="M100 72 Q115 82 100 92"
          fill="none"
          stroke="#78350f"
          stroke-width="5"/>

    <!-- Saucer -->
    <ellipse cx="70" cy="105" rx="40" ry="6"
             fill="#e5e7eb"/>

    <!-- Steam 1 -->
    <path d="M55 60 C45 50 65 40 55 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 2 -->
    <path d="M70 60 C60 50 80 40 70 30"
          stroke="#f59e0b"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.3s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 3 -->
    <path d="M85 60 C75 50 95 40 85 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.6s"
               repeatCount="indefinite"/>
    </path>

    <!-- Text -->
    <text x="70" y="130"
          text-anchor="middle"
          font-size="11"
          fill="#92400e">
      Brewing Coffee…
    </text>

  </svg>

</div>



		<!-- Preloader End --><!-- ================= TOP INFO HEADER ================= -->
<div class="top-header">
    <div class="container-fluid top-header-inner">

        <div class="welcome-text">
            Welcome to Bermiz Restaurant & Catering Services
        </div>

        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-twitter"></i></a>
            <a href="#"><i class="fa-brands fa-instagram"></i></a>
            <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
            <a href="#"><i class="fa-brands fa-youtube"></i></a>
        </div>

    </div>
</div>

<!-- ================= CONTACT STRIP ================= -->
<div class="top-header-container">
    
    <div class="logo-area">
        <a href="index.php">
        <img src="assets/images/Homepage1/logo.png" class="strip-logo">
		</a>
    </div>

    <div class="header-right-side">
        
        <div class="contact-group">
            
            <div class="contact-item">
                <i class="fas fa-phone-alt contact-icon"></i> <div>
                    <h5 class="contact-title">Call Us:</h5>
                    <p class="contact-text">+91 98765 43210</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-envelope contact-icon"></i>
                <div>
                    <h5 class="contact-title">Mail Us:</h5>
                    <p class="contact-text">bermizrestaurant@gmail.com</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-map-marker-alt contact-icon"></i>
                <div>
                    <h5 class="contact-title">Location:</h5>
                    <p class="contact-text">Coimbatore, Tamil Nadu</p>
                </div>
            </div>

        </div> 
<div class="auth-actions" id="authContainer">
    <?php if (isset($_SESSION['user_name'])): ?>
        
        <div class="user-menu-dropdown">
            <button class="user-btn">
                <i class="fa fa-user-circle"></i> <span class="u-name"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <i class="fa fa-caret-down"></i> </button>

            <div class="dropdown-content">
                <a href="profile.php">
                    <i class="fa fa-id-card"></i> View Profile
                </a>
                <a href="logout.php" class="logout-item">
                    <i class="fa fa-sign-out"></i> Logout
                </a>
            </div>
        </div>

    <?php else: ?>

        <a href="login.php" class="btn-auth btn-login">Sign In</a>
        <a href="login.php?show=signup" class="btn-auth btn-signup">Sign Up</a>

    <?php endif; ?>
</div>

    </div>
	<style>/* ========================================= */
/* TOP HEADER LAYOUT                        */
/* ========================================= */
</style>
</div>
	
		<!-- Header Section Start -->
<header id="header-homepage1" class="menupage1-header">
	<div class="header-full-section">
		<!-- Logo -->
		<div class="header-logo">
			<a href="index.php">
				<img src="assets/images/Homepage1/logo.png" alt="header-logo" class="homepage1-logo">
			</a>
		</div>


		<!-- Desktop Menu -->
		<div class="header-menu-wrap">
			<div class="header-nav-wrap">
				<nav class="navbar navbar-expand-xl p-0">
					<div class="navbar-collapse" id="navbarSupportedContent">
						<ul class="navbar-nav mx-auto align-items-center">

							<!-- HOME -->
							<li class="nav-item">
								<a class="nav-link" href="index.php">Home</a>
							</li>

							<!-- ABOUT US DROPDOWN -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">About Us</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="about-us.php">About</a></li>
									<li><a class="dropdown-item" href="chefspage2.php">Chefs</a></li>
									<li><a class="dropdown-item" href="blogpage-1.php">Blog</a></li>
									<li><a class="dropdown-item" href="faq.php">FAQ</a></li>
								</ul>
							</li>

							<!-- MENU -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">Menu</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="menupage-veg.php">Veg</a></li>
									<li><a class="dropdown-item" href="menupage-nonveg.php">Non-Veg</a></li>
									<li><a class="dropdown-item" href="drinks.php">Drinks</a></li>
                                </ul>
							</li>

							<!-- WEEKLY SPECIAL -->
							<li class="nav-item">
								<a class="nav-link" href="weekly.php">Weekly Special</a>
							</li>

							<!-- Catering & Events -->
							<li class="nav-item">
								<a class="nav-link" href="catering-events.php">Catering & Events</a>
							</li>

							<!-- RESERVATION -->
							<li class="nav-item">
								<a class="nav-link" href="online-delivery.php">Online Delivery</a>
							</li>

							<!-- GALLERY -->
							<li class="nav-item">
								<a class="nav-link" href="gallery.php">Gallery</a>
							</li>

							<!-- CONTACT -->
							<li class="nav-item">
								<a class="nav-link" href="contact-us.php">Contact Us</a>
							</li>

						</ul>
					</div>
				</nav>
			</div>
		</div>

		<!-- CART ICON -->
<div class="header-cart-sec">

    <!-- Mobile Toggle -->
    <div class="mobile-menu-icon d-xl-none">
        <a data-bs-toggle="collapse" href="#navbarSupportedmobile" role="button">
            <i class="fa-solid fa-bars"></i>
        </a>
    </div>

    <!-- CART (DESKTOP ONLY) -->
    <div class="header-cart-btn d-none d-xl-flex">
        <a href="cart-view.php">
            <i class="fa fa-shopping-cart"></i>
            <span class="cart-count">0</span>
        </a>
    </div>

    <!-- BOOKING (DESKTOP ONLY) -->
    <div class="header-cart-sec-first d-none d-xl-block">
        <a href="reservation-1.php" class="booking-btn-text">
            Booking
        </a>
    </div>

</div>



</div>

	</div>

	<!-- MOBILE MENU -->
<div class="mobile-menu-wrap d-lg-none d-block">
    <div class="mb-header-left">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedmobile">
            <span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedmobile">
            <span class="close-menu"><i class="fa-regular fa-xmark"></i></span>

            <nav id='cssmenu'>
                <ul class="open-detail-menu">

                    <?php if (isset($_SESSION['user_name'])): ?>
                        <li style="border-bottom: 1px solid #ffffffff; background: #931A2A;">
                            <a href="profile.php" style="color: #ffffffff; font-weight: 700;">
                                <i class="fa fa-user-circle" style="margin-right:8px;"></i> 
                                Hello, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li><a href="index.php">Home</a></li>

                    <li><a href="javascript:void(0);">About Us</a>
                        <ul class="sub-back-wrap">
                            <li><a href="about-us.php">About</a></li>
                            <li><a href="chefspage2.php">Chefs</a></li>
                            <li><a href="blogpage-1.php">Blog</a></li>
                            <li><a href="faq.php">FAQ</a></li>
                        </ul>
                    </li>

                    <li><a href="javascript:void(0);">Menu</a>
                        <ul class="sub-back-wrap">
                            <li><a href="menupage-veg.php">Veg</a></li>
                            <li><a href="menupage-nonveg.php">Non-Veg</a></li>
                            <li><a href="drinks.php">Drinks</a></li>
                        </ul>
                    </li>

                    <li><a href="weekly-special.php">Weekly Special</a></li>
                    <li><a href="catering-events.php">Catering & Events</a></li>
                    <li><a href="online-delivery.php">Online Delivery</a></li>
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contact-us.php">Contact Us</a></li>
                    
                    <li class="mobile-extra">
                        <a href="cart-view.php" class="mobile-cart">
                            <i class="fa fa-shopping-cart"></i>
                            Cart <span class="mobile-cart-count">0</span>
                        </a>
                    </li>

                    <li class="mobile-extra">
                        <a href="reservation-1.php" class="booking-link">Booking</a>
                    </li>

                    <li class="mobile-auth-text">
                        <?php if (isset($_SESSION['user_name'])): ?>
                            <a href="logout.php" class="mobile-login-link" style="color: #dc3545;">
                                <i class="fa fa-sign-out"></i> Logout
                            </a>
                        <?php else: ?>
                            <a href="login.php" class="mobile-login-link">Sign In</a>
                            <a href="login.php?show=signup" class="mobile-signup-link">Sign Up</a>
                        <?php endif; ?>
                    </li>
                    </ul>
            </nav>
        </div>
    </div>
</div>				</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="header-boder"></div>
</header>
<!-- Header Section End -->
<section class="login-wrapper">


    <div class="login-container" id="loginBlock">
        
<div class="form-container sign-up-container" style="display: flex; align-items: center; justify-content: center; padding: 40px 20px;">
    <!-- Step 1: Registration Form (collect all details except OTP) -->
    <form id="signupForm" style="display: block; width: 100%; max-width: 400px; text-align: center;">
        <h1 style="text-align: center; margin-bottom: 10px; white-space: nowrap; font-size: 32px;">Create Account</h1>
        <span style="display: block; text-align: center; margin-bottom: 30px; color: #666;">Enter your details to register</span>
        <input type="text" id="su_name" placeholder=" Full Name" required style="width: 100%; padding: 12px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box;" />
        <input type="password" id="su_pass" placeholder=" Password" required style="width: 100%; padding: 12px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box;" />
        <input type="password" id="su_confirm" placeholder=" Confirm Password" required style="width: 100%; padding: 12px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box;" />
        <input type="email" id="su_email" placeholder=" Email" required style="width: 100%; padding: 12px; margin-bottom: 30px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box;" />
        <button type="button" id="sendOtpBtn" onclick="sendOtp()" style="width: 100%; padding: 12px; background: #667eea; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; font-weight: bold; margin-bottom: 20px;">Send OTP</button>
        <p id="otpMessage" style="color: #28a745; font-size: 13px; margin-top: 10px; display: none;"></p>
        <p id="otpError" style="color: #dc3545; font-size: 13px; margin-top: 10px; display: none;"></p>
    </form>

    <!-- Step 2: OTP Verification -->
    <form id="otpVerificationForm" style="display: none; width: 100%; max-width: 400px; margin: 0 auto;">
        <div style="text-align: center; margin-bottom: 30px;">
            <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; margin: 0 auto 15px; display: flex; align-items: center; justify-content: center;">
                <i class="fa fa-shield" style="color: white; font-size: 28px;"></i>
            </div>
            <h1 style="margin: 0; color: #333; text-align: center;">Verify OTP</h1>
            <span style="color: #666; font-size: 14px; display: block; margin-top: 10px; text-align: center;">Enter the 6-digit code sent to your email</span>
        </div>
        
        <p style="color: #667eea; font-size: 13px; margin: 15px 0; text-align: center; font-weight: 600;" id="otpEmailDisplay"></p>
        
        <div style="margin: 25px 0;">
            <input type="text" id="otp_code" placeholder="000000" maxlength="6" required style="width: 100%; text-align: center; font-size: 24px; letter-spacing: 10px; font-weight: bold; padding: 12px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box;" />
        </div>
        
        <button type="button" id="verifyOtpBtn" onclick="verifyOtp()" style="width: 100%; margin-bottom: 10px; padding: 12px; background: #667eea; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; font-weight: bold;">Verify OTP</button>
        <button type="button" id="resendOtpBtn" onclick="resendOtp()" style="width: 100%; background: #6c757d; color: white; margin-bottom: 15px; padding: 12px; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; font-weight: bold;">Resend OTP</button>
        
        <p id="verifyError" style="color: #dc3545; font-size: 13px; margin-top: 10px; display: none; text-align: center;"></p>
        
        <p style="text-align: center; color: #999; font-size: 12px; margin-top: 15px;">
            <span id="otpTimer" style="color: #667eea; font-weight: bold;">10:00</span> remaining
        </p>
    </form>

    <!-- Step 3: Registration Confirmation (after OTP verified) -->
    <form id="confirmationForm" style="display: none; width: 100%; max-width: 400px; margin: 0 auto;">
        <div style="text-align: center; margin-bottom: 30px;">
            <div style="width: 80px; height: 80px; background: #d4edda; border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center;">
                <i class="fa fa-check" style="color: #28a745; font-size: 40px;"></i>
            </div>
            <h1 style="margin: 0; color: #333; text-align: center;">Email Verified!</h1>
            <span style="color: #666; font-size: 14px; display: block; margin-top: 10px; text-align: center;">Your email has been verified successfully</span>
        </div>
        
        <div style="background: #f8f9ff; border-left: 4px solid #667eea; padding: 15px; border-radius: 5px; margin: 20px 0; text-align: center;">
            <p style="margin: 0; color: #333; font-weight: 600;" id="confirmEmailDisplay"></p>
            <p style="margin: 5px 0 0 0; color: #666; font-size: 13px;">Ready to complete your registration</p>
        </div>
        
        <button type="button" id="joinBtn" onclick="completeRegistration()" style="width: 100%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; padding: 12px; border-radius: 5px; margin-top: 20px; cursor: pointer; font-size: 16px; font-weight: bold;">Join Bermiz</button>
        
        <p id="confirmError" style="color: #dc3545; font-size: 13px; margin-top: 15px; display: none; text-align: center;"></p>
    </form>
</div>

        <div class="form-container sign-in-container">
    <form id="loginForm"> <h1>Sign in</h1>
        <span>Welcome back to Bermiz</span>
        <input type="email" id="si_email" placeholder="Email" required />
        <input type="password" id="si_pass" placeholder="Password" required />
        <a href="forgot-password.php">Forgot your password?</a>
        <button type="submit">Dine In</button>
    </form>
</div>

        <div class="toggle-container overlay-container">
            <div class="overlay">
                <div class="overlay-panel overlay-left">
                    <h1>Welcome Back!</h1>
                    <p>To keep connected with us please login with your personal info</p>
                    <button class="ghost" id="signInBtn">Sign In</button>
                </div>
                <div class="overlay-panel overlay-right">
                    <h1>Hello, Foodie!</h1>
                    <p>Enter your details to book your favorite meal and start your journey with us</p>
                    <button class="ghost" id="signUpBtn">Sign Up</button>
                </div>
            </div>
        </div>
    </div>

 
    <script>
    // ==========================================
    // 1. SLIDING ANIMATION LOGIC
    // ==========================================
    const signUpButton = document.getElementById('signUpBtn');
    const signInButton = document.getElementById('signInBtn');
    const loginContainer = document.getElementById('loginBlock');

    // Function to slide to "Sign Up"
    const showSignUp = () => {
        loginContainer.classList.add("right-panel-active");
        // Reset signup flow when clicking sign up button
        resetSignupFlow();
    };

    // Function to slide to "Sign In"
    const showSignIn = () => {
        loginContainer.classList.remove("right-panel-active");
    };

    // Attach clicks to the toggle buttons
    if (signUpButton && signInButton) {
        signUpButton.addEventListener('click', showSignUp);
        signInButton.addEventListener('click', showSignIn);
    }

    // Check URL to see if we should open Sign Up automatically
    window.addEventListener('DOMContentLoaded', () => {
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.get('show') === 'signup') {
            showSignUp();
        }
    });


    // ==========================================
    // 2. OTP FLOW VARIABLES & FUNCTIONS
    // ==========================================
    let verifiedEmail = null;
    let otpAttempts = 0;
    const MAX_OTP_ATTEMPTS = 3;

    // Reset signup flow
    function resetSignupFlow() {
        verifiedEmail = null;
        otpAttempts = 0;
        document.getElementById('signupForm').style.display = 'block';
        document.getElementById('otpVerificationForm').style.display = 'none';
        document.getElementById('confirmationForm').style.display = 'none';
        document.getElementById('su_name').value = '';
        document.getElementById('su_email').value = '';
        document.getElementById('su_pass').value = '';
        document.getElementById('su_confirm').value = '';
        document.getElementById('otp_code').value = '';
        clearMessages();
    }

    // Clear all error/success messages
    function clearMessages() {
        document.getElementById('otpMessage').style.display = 'none';
        document.getElementById('otpError').style.display = 'none';
        document.getElementById('verifyError').style.display = 'none';
    }

    // ==========================================
    // 3. SEND OTP FUNCTION
    // ==========================================
    async function sendOtp() {
        const name = document.getElementById('su_name').value.trim();
        const email = document.getElementById('su_email').value.trim();
        const password = document.getElementById('su_pass').value;
        const confirm_password = document.getElementById('su_confirm').value;
        const sendOtpBtn = document.getElementById('sendOtpBtn');
        const otpMessage = document.getElementById('otpMessage');
        const otpError = document.getElementById('otpError');
        clearMessages();
        // Validate fields
        if (!name || !email || !password || !confirm_password) {
            otpError.textContent = '❌ All fields are required';
            otpError.style.display = 'block';
            return;
        }
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailRegex.test(email)) {
            otpError.textContent = '❌ Please enter a valid email address';
            otpError.style.display = 'block';
            return;
        }
        if (password.length < 6) {
            otpError.textContent = '❌ Password must be at least 6 characters';
            otpError.style.display = 'block';
            return;
        }
        if (password !== confirm_password) {
            otpError.textContent = '❌ Passwords do not match';
            otpError.style.display = 'block';
            return;
        }
        // Disable button during request
        sendOtpBtn.disabled = true;
        sendOtpBtn.textContent = 'Sending...';
        try {
            const response = await fetch('auth.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    action: 'send_otp',
                    name: name,
                    email: email,
                    password: password,
                    confirm_password: confirm_password
                })
            });
            const result = await response.json();
            if (result.status === 'success') {
                verifiedEmail = email;
                otpMessage.textContent = '✅ ' + result.message;
                otpMessage.style.display = 'block';
                setTimeout(() => {
                    document.getElementById('signupForm').style.display = 'none';
                    document.getElementById('otpVerificationForm').style.display = 'block';
                    document.getElementById('otpEmailDisplay').textContent = 'OTP sent to: ' + email;
                }, 1500);
            } else {
                otpError.textContent = '❌ ' + result.message;
                otpError.style.display = 'block';
            }
        } catch (error) {
            console.error('Error:', error);
            otpError.textContent = '❌ Failed to send OTP. Check your connection.';
            otpError.style.display = 'block';
        } finally {
            sendOtpBtn.disabled = false;
            sendOtpBtn.textContent = 'Send OTP';
        }
    }

    // ==========================================
    // 4. VERIFY OTP FUNCTION
    // ==========================================
    async function verifyOtp() {
        const otp = document.getElementById('otp_code').value.trim();
        const verifyOtpBtn = document.getElementById('verifyOtpBtn');
        const verifyError = document.getElementById('verifyError');

        clearMessages();

        if (otp.length !== 6 || isNaN(otp)) {
            verifyError.textContent = '❌ Please enter a valid 6-digit OTP';
            verifyError.style.display = 'block';
            return;
        }

        if (otpAttempts >= MAX_OTP_ATTEMPTS) {
            verifyError.textContent = '❌ Maximum attempts exceeded. Please send OTP again.';
            verifyError.style.display = 'block';
            resetSignupFlow();
            return;
        }

        verifyOtpBtn.disabled = true;
        verifyOtpBtn.textContent = 'Verifying...';

        try {
            const response = await fetch('auth.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    action: 'verify_otp',
                    email: verifiedEmail,
                    otp: otp
                })
            });

            const result = await response.json();

            if (result.status === 'success') {
                // Show confirmation form with Join Bermiz button
                document.getElementById('otpVerificationForm').style.display = 'none';
                document.getElementById('confirmationForm').style.display = 'block';
                document.getElementById('confirmEmailDisplay').textContent = 'Email: ' + verifiedEmail;
            } else {
                otpAttempts++;
                verifyError.textContent = '❌ ' + result.message + ' (Attempt ' + otpAttempts + '/' + MAX_OTP_ATTEMPTS + ')';
                verifyError.style.display = 'block';
            }
        } catch (error) {
            console.error('Error:', error);
            verifyError.textContent = '❌ Failed to verify OTP. Try again.';
            verifyError.style.display = 'block';
        } finally {
            verifyOtpBtn.disabled = false;
            verifyOtpBtn.textContent = 'Verify OTP';
        }
    }

    // ==========================================
    // 5. RESEND OTP FUNCTION
    // ==========================================
    async function resendOtp() {
        if (!verifiedEmail) {
            alert('Please enter an email first');
            return;
        }
        
        otpAttempts = 0; // Reset attempts
        document.getElementById('otp_code').value = '';
        document.getElementById('signupForm').style.display = 'block';
        document.getElementById('otpVerificationForm').style.display = 'none';
        await sendOtp();
    }

    // ==========================================
    // 6. COMPLETE REGISTRATION FUNCTION
    // ==========================================
    async function completeRegistration() {
        const joinBtn = document.getElementById('joinBtn');
        const confirmError = document.getElementById('confirmError');
        
        joinBtn.disabled = true;
        joinBtn.textContent = 'Registering...';
        
        try {
            const response = await fetch('auth.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    action: 'signup',
                    email: verifiedEmail
                })
            });

            const result = await response.json();

            if (result.status === 'success') {
                // Show success message
                document.getElementById('confirmationForm').style.display = 'none';
                const successMsg = document.createElement('div');
                successMsg.innerHTML = `
                    <div style="width: 100%; min-height: 100%; display: flex; flex-direction: column; align-items: center; justify-content: center; padding: 40px; background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);">
                        <div style="width: 80px; height: 80px; background: white; border-radius: 50%; margin: 0 auto 30px; display: flex; align-items: center; justify-content: center; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
                            <i class="fa fa-check" style="color: #28a745; font-size: 45px;"></i>
                        </div>
                        <h2 style="color: #155724; margin: 0 0 20px 0; font-size: 32px; font-weight: bold; text-align: center;">✅ Registration Successful!</h2>
                        <p style="color: #155724; margin: 0 0 15px 0; font-size: 16px; text-align: center;">Your account has been created successfully.</p>
                        <p style="color: #155724; margin: 0 0 40px 0; font-size: 14px; text-align: center;">You can now login with your email and password.</p>
                        <button onclick="showSignIn()" style="background: #667eea; color: white; border: none; padding: 15px 40px; border-radius: 5px; cursor: pointer; font-size: 16px; font-weight: bold; transition: all 0.3s ease; box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);">Go to Sign In</button>
                    </div>
                `;
                const signUpContainer = document.querySelector('.form-container.sign-up-container');
                signUpContainer.innerHTML = successMsg.innerHTML;
                signUpContainer.style.height = '100%';
                signUpContainer.style.display = 'flex';
                signUpContainer.style.alignItems = 'center';
                signUpContainer.style.justifyContent = 'center';
                signUpContainer.style.overflow = 'hidden';
                resetSignupFlow();
            } else {
                confirmError.textContent = '❌ ' + result.message;
                confirmError.style.display = 'block';
            }
        } catch (error) {
            console.error('Error:', error);
            confirmError.textContent = '❌ Registration failed. Try again.';
            confirmError.style.display = 'block';
        } finally {
            joinBtn.disabled = false;
            joinBtn.textContent = 'Join Bermiz';
        }
    }

    // ==========================================
    // 7. BACKEND CONNECTION (SEND DATA TO PHP)
    // ==========================================

    // --- HANDLE SIGN UP (after OTP verification) ---
    // No signup form submit needed; registration is automatic after OTP verification

    // --- HANDLE LOGIN ---
    const loginForm = document.getElementById('loginForm');
    if (loginForm) {
        loginForm.addEventListener('submit', async (e) => {
            e.preventDefault();

            const email = document.getElementById('si_email').value;
            const password = document.getElementById('si_pass').value;

            try {
                const response = await fetch('auth.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({
                        action: 'login',
                        email: email,
                        password: password
                    })
                });

                const result = await response.json();

                if (result.status === 'success') {
                    window.location.href = result.redirect;
                } else {
                    alert('❌ ' + result.message);
                }

            } catch (error) {
                console.error('Error:', error);
                alert("❌ Login failed. Check console for details.");
            }
        });
    }
</script>

</section>







<footer class="restaurant-footer">
    <div class="footer-container">

        <!-- Left Top Logo + Text -->
        <div class="footer-brand">
            <img src="assets/images/Homepage1/footer-logo.png" alt="Restaurant Logo" class="footer-logo">
            <p class="footer-desc">
                A premium dining experience with handcrafted dishes, fresh ingredients, 
                and an elegant ambiance. Your comfort is our priority.
            </p>
        </div>

        <!-- Quick Links -->
        <div class="footer-links">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="reservation-1.php">Reserve a Table</a></li>
                
                <li><a href="#menupage-veg.php">Explore Menu</a></li>
                <li><a href="#weekly.php">Special Offers</a></li>
                <li><a href="#catering-events.php">Catering Service</a></li>
            </ul>
        </div>

        <!-- Contact Section -->
        <div class="footer-contact">
            <h4>Contact Us</h4>
            <p> 123 Food Street, Chennai</p>
            <p> +91 98765 43210</p>
            <p>✉ support@restaurant.com</p>

            <div class="footer-social">
                <a href="#"><i class="fa fa-facebook"></i></a>
                <a href="#"><i class="fa fa-instagram"></i></a>
                <a href="#"><i class="fa fa-twitter"></i></a>
                <a href="#"><i class="fa fa-youtube"></i></a>
            </div>
        </div>

        <!-- Working Hours -->
        <div class="footer-hours">
            <h4>Working Hours</h4>
            <p>Mon – Fri : 09:00 - 22:00</p>
            <p>Saturday : 11:00 - 23:30</p>
            <p>Sunday : 11:00 - 23:00</p>
        </div>

    </div>

    <div class="footer-bottom">
        <p>© 2025 Your Restaurant Name. All Rights Reserved.</p>
        <div class="footer-bottom-links">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Service</a>
        </div>
    </div>
</footer>

			<!-- Footer Section End -->
			<!-- Fixed Search Bar Start -->
			<div>
				<div class="fixed-serach-icon ">
					<div class="fixed-search ">
						<a href="javascript:void(0)">
							<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<mask id="mask0_504_17203" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
									<rect width="24" height="24" fill="white"></rect>
								</mask>
								<g mask="url(#mask0_504_17203)">
									<circle cx="11.7666" cy="11.7666" r="8.98856" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
									<path d="M18.0183 18.4851L21.5423 22" stroke="#0B1315" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
								</g>
							</svg>
						</a>
					</div>
				</div> 
				<div class="search-popup">
					<span class="search-back-drop"></span>
					<button class="close-search"><span class="fa fa-times"></span></button>
					<div class="search-inner">
						<form method="post" action="index.php">
							<div class="form-group">
								<input type="search" name="search-field" value="" placeholder="Search..." required="">
								<button type="submit"><i class="fa fa-search"></i></button>
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- Fixed Search Bar End -->
			<!-- Hero Video Modal Start -->
			<div class="modal fade homepage-video-modal" id="hero-video-modal">
				<div class="modal-dialog modal-dialog-centered">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<div class="modal-body">
							<video class="video-sec" controls="" loop="" muted="" autoplay="">
								<source src="assets/images/Homepage1/video.mp4" type="video/mp4">
								</video>
							</div>
						</div>
					</div>
				</div>
				<!-- Hero Video Modal End -->
				<!--Scroll Top to Bottom Start -->
				<div class="scroll-top" data-scroll="up">		
				</div>
				<!--Scroll Top to Bottom  End -->
			</div>
        
			<script src="assets/js/jquery-min-3.6.0.js"></script>
			<script src="assets/js/slick.min.js"></script>
			<script src="assets/js/bootstrap.bundle.min.js"></script>
			<script src="assets/js/aos.js"></script>
			<script src="assets/js/jquery-ui.min.js"></script>
			<script src="assets/js/datepicker.js"></script>
			<script src="assets/js/wow.min.js"></script>
			<script src="assets/js/photoswipe.min.js"></script>
			<script src="assets/js/photoswipe-ui-default.min.js"></script>
			<script src="assets/js/gallery-popup.js"></script>
			<script src="assets/js/TweenMax.min.js"></script>
			<script src="assets/js/ScrollMagic.js"></script>
			<script src="assets/js/animation.gsap.min.js"></script>
			<script src="assets/js/scolling.js"></script>
			<script src="assets/js/custom.js"></script>
            </body>
</html>