-- Create Orders Table
CREATE TABLE IF NOT EXISTS `orders` (
  `id` INT PRIMARY KEY AUTO_INCREMENT,
  `order_id` VARCHAR(50) UNIQUE NOT NULL,
  `user_id` INT NOT NULL,
  `user_name` VARCHAR(255) NOT NULL,
  `user_phone` VARCHAR(20),
  `user_email` VARCHAR(255),
  `delivery_address` TEXT,
  `delivery_street` VARCHAR(255),
  `delivery_city` VARCHAR(100),
  `delivery_state` VARCHAR(100),
  `delivery_postal` VARCHAR(10),
  `special_instructions` TEXT,
  `payment_method` VARCHAR(50),
  `subtotal` DECIMAL(10, 2) DEFAULT 0,
  `delivery_charge` DECIMAL(10, 2) DEFAULT 0,
  `taxes` DECIMAL(10, 2) DEFAULT 0,
  `discount` DECIMAL(10, 2) DEFAULT 0,
  `total_amount` DECIMAL(10, 2) DEFAULT 0,
  `order_status` ENUM('pending', 'confirmed', 'preparing', 'out_for_delivery', 'delivered', 'cancelled') DEFAULT 'pending',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  INDEX `idx_user_id` (`user_id`),
  INDEX `idx_order_id` (`order_id`),
  INDEX `idx_status` (`order_status`)
);

-- Create Order Items Table
CREATE TABLE IF NOT EXISTS `order_items` (
  `id` INT PRIMARY KEY AUTO_INCREMENT,
  `order_id` INT NOT NULL,
  `product_name` VARCHAR(255) NOT NULL,
  `product_price` DECIMAL(10, 2) NOT NULL,
  `quantity` INT NOT NULL DEFAULT 1,
  `item_total` DECIMAL(10, 2) DEFAULT 0,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (`order_id`) REFERENCES `orders`(`id`) ON DELETE CASCADE,
  INDEX `idx_order_id` (`order_id`)
);

-- Add indexes for better query performance
ALTER TABLE `orders` ADD INDEX IF NOT EXISTS `idx_user_id` (`user_id`);
