<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Bermiz</title>
	<link rel="icon" href="assets/images/favicon/icon.png">
	<link href="../../../css2?family=Elsie&display=swap" rel="stylesheet">
	<link href="../../../css2-1?family=Elsie&family=Lexend:wght@400;500&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/all.min.css">
	<link rel="stylesheet" href="assets/css/slick.css">
	<link rel="stylesheet" href="assets/css/aos.css">
	<link rel="stylesheet" href="assets/css/animate.css">
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="assets/css/photoswipe.min.css">
	<link rel="stylesheet" href="assets/css/default-skin.min.css">
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
	<link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/media-query.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<body>
	<div class="site_content">
		<!-- Preloader Start -->
<!-- ===== RESTAURANT PRELOADER ===== -->
<div id="preloader">

  <!-- INLINE SVG COFFEE -->
  <svg width="140" height="140"
       viewBox="0 0 140 140"
       xmlns="http://www.w3.org/2000/svg">

    <!-- Cup body -->
    <rect x="40" y="65" width="60" height="35"
          rx="8" fill="#78350f"/>

    <!-- Cup handle -->
    <path d="M100 72 Q115 82 100 92"
          fill="none"
          stroke="#78350f"
          stroke-width="5"/>

    <!-- Saucer -->
    <ellipse cx="70" cy="105" rx="40" ry="6"
             fill="#e5e7eb"/>

    <!-- Steam 1 -->
    <path d="M55 60 C45 50 65 40 55 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 2 -->
    <path d="M70 60 C60 50 80 40 70 30"
          stroke="#f59e0b"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.3s"
               repeatCount="indefinite"/>
    </path>

    <!-- Steam 3 -->
    <path d="M85 60 C75 50 95 40 85 30"
          stroke="#d97706"
          stroke-width="4"
          fill="none">
      <animate attributeName="opacity"
               values="0;1;0"
               dur="1.2s"
               begin="0.6s"
               repeatCount="indefinite"/>
    </path>

    <!-- Text -->
    <text x="70" y="130"
          text-anchor="middle"
          font-size="11"
          fill="#92400e">
      Brewing Coffee…
    </text>

  </svg>

</div>

		<!-- Preloader End --><!-- ================= TOP INFO HEADER ================= -->
<div class="top-header">
    <div class="container-fluid top-header-inner">

        <div class="welcome-text">
            Welcome to Bermiz Restaurant & Catering Services
        </div>

        <div class="social-icons">
            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
            <a href="#"><i class="fa-brands fa-twitter"></i></a>
            <a href="#"><i class="fa-brands fa-instagram"></i></a>
            <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
            <a href="#"><i class="fa-brands fa-youtube"></i></a>
        </div>

    </div>
</div>

<!-- ================= CONTACT STRIP ================= -->
<div class="top-header-container">
    
    <div class="logo-area">
        <a href="index.php">
        <img src="assets/images/Homepage1/logo.png" class="strip-logo">
		</a>
    </div>

    <div class="header-right-side">
        
        <div class="contact-group">
            
            <div class="contact-item">
                <i class="fas fa-phone-alt contact-icon"></i> <div>
                    <h5 class="contact-title">Call Us:</h5>
                    <p class="contact-text">+91 98765 43210</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-envelope contact-icon"></i>
                <div>
                    <h5 class="contact-title">Mail Us:</h5>
                    <p class="contact-text">bermizrestaurant@gmail.com</p>
                </div>
            </div>

            <div class="contact-item">
                <i class="fas fa-map-marker-alt contact-icon"></i>
                <div>
                    <h5 class="contact-title">Location:</h5>
                    <p class="contact-text">Coimbatore, Tamil Nadu</p>
                </div>
            </div>

        </div> 
 <div class="auth-actions" id="authContainer">
    <?php if (isset($_SESSION['user_name'])): ?>
        
        <div class="user-menu-dropdown">
            <button class="user-btn">
                <i class="fa fa-user-circle"></i> <span class="u-name"><?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                <i class="fa fa-caret-down"></i> </button>

            <div class="dropdown-content">
                <a href="profile.php">
                    <i class="fa fa-id-card"></i> View Profile
                </a>
                <a href="logout.php" class="logout-item">
                    <i class="fa fa-sign-out"></i> Logout
                </a>
            </div>
        </div>

    <?php else: ?>

        <a href="login.php" class="btn-auth btn-login">Sign In</a>
        <a href="login.php?show=signup" class="btn-auth btn-signup">Sign Up</a>

    <?php endif; ?>
</div>

    </div>
	<style>/* ========================================= */
/* TOP HEADER LAYOUT                        */
/* ========================================= */
</style>
</div>
	
		<!-- Header Section Start -->
<header id="header-homepage1" class="menupage1-header">
	<div class="header-full-section">
		<!-- Logo -->
		<div class="header-logo">
			<a href="index.php">
				<img src="assets/images/Homepage1/logo.png" alt="header-logo" class="homepage1-logo">
			</a>
		</div>


		<!-- Desktop Menu -->
		<div class="header-menu-wrap">
			<div class="header-nav-wrap">
				<nav class="navbar navbar-expand-xl p-0">
					<div class="navbar-collapse" id="navbarSupportedContent">
						<ul class="navbar-nav mx-auto align-items-center">

							<!-- HOME -->
							<li class="nav-item">
								<a class="nav-link" href="index.php">Home</a>
							</li>

							<!-- ABOUT US DROPDOWN -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">About Us</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="about-us.php">About</a></li>
									<li><a class="dropdown-item" href="chefspage2.php">Chefs</a></li>
									<li><a class="dropdown-item" href="blogpage-1.php">Blog</a></li>
									<li><a class="dropdown-item" href="faq.php">FAQ</a></li>
								</ul>
							</li>

							<!-- MENU -->
							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="javascript:void(0);">Menu</a>
								<ul class="dropdown-menu">
									<li><a class="dropdown-item" href="menupage-veg.php">Veg</a></li>
									<li><a class="dropdown-item" href="menupage-nonveg.php">Non-Veg</a></li>
									<li><a class="dropdown-item" href="drinks.php">Drinks</a></li>
                                </ul>
							</li>

							<!-- WEEKLY SPECIAL -->
							<li class="nav-item">
								<a class="nav-link" href="weekly.php">Weekly Special</a>
							</li>

							<!-- Catering & Events -->
							<li class="nav-item">
								<a class="nav-link" href="catering-events.php">Catering & Events</a>
							</li>

							<!-- RESERVATION -->
							<li class="nav-item">
								<a class="nav-link" href="online-delivery.php">Online Delivery</a>
							</li>

							<!-- GALLERY -->
							<li class="nav-item">
								<a class="nav-link" href="gallery.php">Gallery</a>
							</li>

							<!-- CONTACT -->
							<li class="nav-item">
								<a class="nav-link" href="contact-us.php">Contact Us</a>
							</li>

						</ul>
					</div>
				</nav>
			</div>
		</div>

		<!-- CART ICON -->
<div class="header-cart-sec">

    <!-- Mobile Toggle -->
    <div class="mobile-menu-icon d-xl-none">
        <a data-bs-toggle="collapse" href="#navbarSupportedmobile" role="button">
            <i class="fa-solid fa-bars"></i>
        </a>
    </div>

    <!-- CART (DESKTOP ONLY) -->
    <div class="header-cart-btn d-none d-xl-flex">
        <a href="cart-view.php">
            <i class="fa fa-shopping-cart"></i>
            <span class="cart-count">0</span>
        </a>
    </div>

    <!-- BOOKING (DESKTOP ONLY) -->
    <div class="header-cart-sec-first d-none d-xl-block">
        <a href="reservation-1.php" class="booking-btn-text">
            Booking
        </a>
    </div>

</div>



</div>

	</div>

	<!-- MOBILE MENU -->
<div class="mobile-menu-wrap d-lg-none d-block">
    <div class="mb-header-left">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedmobile">
            <span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedmobile">
            <span class="close-menu"><i class="fa-regular fa-xmark"></i></span>

            <nav id='cssmenu'>
                <ul class="open-detail-menu">

                    <?php if (isset($_SESSION['user_name'])): ?>
                        <li style="border-bottom: 1px solid #ffffffff; background: #931A2A;">
                            <a href="profile.php" style="color: #ffffffff; font-weight: 700;">
                                <i class="fa fa-user-circle" style="margin-right:8px;"></i> 
                                Hello, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li><a href="index.php">Home</a></li>

                    <li><a href="javascript:void(0);">About Us</a>
                        <ul class="sub-back-wrap">
                            <li><a href="about-us.php">About</a></li>
                            <li><a href="chefspage2.php">Chefs</a></li>
                            <li><a href="blogpage-1.php">Blog</a></li>
                            <li><a href="faq.php">FAQ</a></li>
                        </ul>
                    </li>

                    <li><a href="javascript:void(0);">Menu</a>
                        <ul class="sub-back-wrap">
                            <li><a href="menupage-veg.php">Veg</a></li>
                            <li><a href="menupage-nonveg.php">Non-Veg</a></li>
                            <li><a href="drinks.php">Drinks</a></li>
                        </ul>
                    </li>

                    <li><a href="weekly-special.php">Weekly Special</a></li>
                    <li><a href="catering-events.php">Catering & Events</a></li>
                    <li><a href="online-delivery.php">Online Delivery</a></li>
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contact-us.php">Contact Us</a></li>
                    
                    <li class="mobile-extra">
                        <a href="cart-view.php" class="mobile-cart">
                            <i class="fa fa-shopping-cart"></i>
                            Cart <span class="mobile-cart-count">0</span>
                        </a>
                    </li>

                    <li class="mobile-extra">
                        <a href="reservation-1.php" class="booking-link">Booking</a>
                    </li>

                    <li class="mobile-auth-text">
                        <?php if (isset($_SESSION['user_name'])): ?>
                            <a href="logout.php" class="mobile-login-link" style="color: #dc3545;">
                                <i class="fa fa-sign-out"></i> Logout
                            </a>
                        <?php else: ?>
                            <a href="login.php" class="mobile-login-link">Sign In</a>
                            <a href="login.php?show=signup" class="mobile-signup-link">Sign Up</a>
                        <?php endif; ?>
                    </li>
                    </ul>
            </nav>
        </div>
    </div>
</div>				</ul>
				</nav>
			</div>
		</div>
	</div>
	<div class="header-boder"></div>
</header>



<style>
/* ===================================================== */
/* EVENT PAGE STYLING — SAFE VERSION (NO HEADER IMPACT)  */
/* ===================================================== */

/* SECTION TITLE */
.event-title {
    text-align:center; 
    font-size:40px; 
    font-weight:600;
    padding:40px 0 5px; 
    color:#F5E6D3; 
    text-shadow:0 0 6px #d6a868;
}

.event-subtext { 
    text-align:center; 
    color:#9f9885; 
    font-size:17px; 
    max-width:700px; 
    margin:auto; 
}

/* EVENT GRID */
.event-grid { 
    max-width:1200px; 
    margin:40px auto; 
    display:grid; 
    gap:35px;
    grid-template-columns: repeat(2, 1fr);
    padding:35px 20px;
}

.event-card { 
    background:#F5E6D3; 
    border:2px solid rgba(255,215,0,0.3);
    border-radius:15px; 
    overflow:hidden; 
    box-shadow:0 0 14px rgba(255,215,0,.2);
    opacity:0; 
    transform:translateY(40px); 
    transition:.6s ease;
}

.event-card.visible { 
    opacity:1; 
    transform:translateY(0); 
}

.event-card img { 
    width:100%; 
    height:280px; 
    object-fit:cover; 
}

/* CARD BODY */
.event-body { 
    padding:25px 22px; 
    background-color:#671616;
}

.event-body h2 { 
    font-size:24px; 
    color:#fff; 
    margin-bottom:10px; 
}

.event-body p { 
    font-size:15px; 
    color:#e2d3a5; 
}

.price-range { 
    font-size:18px; 
    color: #fff; 
    font-weight:600; 
    margin-top:8px; 
}

/* BUTTONS */
.btn-book, 
.btn-whatsapp {
    display:inline-block; 
    padding:8px 14px; 
    border-radius:6px; 
    font-weight:600; 
    margin-top:10px;
}

.btn-book { 
    background:#d4a33a; 
    color:#000; 
}

.btn-book:hover {
    background:#ffe09c;
    color:#000;
}

.btn-whatsapp { 
    background:#25D366; 
    color:#000; 
}

.btn-whatsapp:hover { 
    background:#4bf187; 
    color:#000; 
}

/* BOOKING FORM SECTION */
.booking-section { 
    padding:50px 20px; 
    background:#F5E6D3; 
    margin-top:50px; 
    border-top:2px solid #060605; 
}

.form-title { 
    text-align:center; 
    font-size:32px; 
    color:#431210; 
    margin-bottom:20px; 
}

.form-container2 { 
    max-width:850px; 
    margin:auto; 
    background:#931A2A; 
    padding:30px; 
    border-radius:15px; 
    border:2px solid rgba(255,215,0,.3); 
}

.form-control2, select { 
    background:#F5E6D3; 
    border:1px solid #444; 
    color:#4f3510; 
}

label { 
    font-weight:500; 
    color:#dacfa5; 
    margin-top:10px; 
}

.submit-btn { 
    background:#d4a33a; 
    color:#000; 
    border:none; 
    padding:10px 20px; 
    border-radius:8px; 
    font-size:18px; 
    font-weight:600; 
    margin-top:15px; 
}

.submit-btn:hover { 
    background:#ffe09c; 
}

/* ===================================================== */
/* RESPONSIVE — MOBILE OPTIMIZATION (SAFE)               */
/* ===================================================== */
@media(max-width: 768px){
    
    /* GRID → 1 COLUMN */
    .event-grid { 
        grid-template-columns:1fr !important; 
    }

    .event-card img { 
        height:240px; 
    }

    .event-body h2 {
        font-size:22px;
        text-align:center;
    }

    .price-range {
        text-align:center;
    }
}

@media(max-width:480px){
    .event-title { font-size:32px; }
    .event-body h2 { font-size:20px; }
}
</style>
<!-- ⭐ PAGE TITLE & SERVICES ⭐ -->
<section id="menupage-1-section">
    <div class="menupage-1-section-img">
        <div class="menupage-1-overlay"></div>
        
        <div class="menupage-1-conten text-center"> <h1 class="menupage-1-hero-txt1 wow fadeInDown" data-wow-duration="1s" data-wow-delay="0.5s">
                Catering events
            </h1>

            <nav aria-label="breadcrumb">
                <ol class="breadcrumb justify-content-center transparent-breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.php">
                            <span class="home-icon">
                                <svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <mask id="mask0_564_5237" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
                                        <rect width="24" height="24" fill="white"></rect>
                                    </mask>
                                    <g mask="url(#mask0_564_5237)">
                                        <path d="M9.15722 20.7714V17.7047C9.1572 16.9246 9.79312 16.2908 10.581 16.2856H13.4671C14.2587 16.2856 14.9005 16.9209 14.9005 17.7047V17.7047V20.7809C14.9003 21.4432 15.4343 21.9845 16.103 22H18.0271C19.9451 22 21.5 20.4607 21.5 18.5618V18.5618V9.83784C21.4898 9.09083 21.1355 8.38935 20.538 7.93303L13.9577 2.6853C12.8049 1.77157 11.1662 1.77157 10.0134 2.6853L3.46203 7.94256C2.86226 8.39702 2.50739 9.09967 2.5 9.84736V18.5618C2.5 20.4607 4.05488 22 5.97291 22H7.89696C8.58235 22 9.13797 21.4499 9.13797 20.7714V20.7714" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </g>
                                </svg>
                            </span>
                            Home
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-white" aria-current="page">Catering-events</li>
                </ol>
            </nav>

        </div>
    </div>
    <div class="menupage1-boder"></div>
</section>
	

	<div class="event-grid">

		<div class="event-card">
			<img src="assets/images/catring/1.jpg">
			<div class="event-body">
				<h2>Wedding Catering</h2>
				<p>Royal buffet, dessert counters, multi-cuisine setups & premium décor serving.</p>
				<div class="price-range">Starts ₹50,000</div>
				<a class="btn-book" href="#book">Book Now</a>
			</div>
		</div>

		<div class="event-card">
			<img src="assets/images/catring/2.jpeg">
			<div class="event-body">
				<h2>Birthday Special</h2>
				<p>Kids menu, theme dishes, chocolate fountains, custom cakes & snacks bar.</p>
				<div class="price-range">Starts ₹9,999</div>
				<a class="btn-book" href="#book">Book Now</a>
			</div>
		</div>

		<div class="event-card">
			<img src="assets/images/catring/4.jpeg">
			<div class="event-body">
				<h2>Corporate Meals</h2>
				<p>Business lunches, premium live buffets for seminars & conferences.</p>
				<div class="price-range">Starts ₹15,000</div>
				<a class="btn-book" href="#book">Book Now</a>
			</div>
		</div>

		<div class="event-card">
			<img src="assets/images/catring/3.jpg">
			<div class="event-body">
				<h2>Engagement Catering</h2>
				<p>Elegant presentation, snacks, live counters & customized menu packages.</p>
				<div class="price-range">Starts ₹25,000</div>
				<a class="btn-book" href="#book">Book Now</a>
			</div>
		</div>

		<div class="event-card">
			<img src="assets/images/catring/5.jpeg">
			<div class="event-body">
				<h2>Baby Shower Food</h2>
				<p>Healthy snacks, sweet counters & traditional arrangements.</p>
				<div class="price-range">Starts ₹12,999</div>
				<a class="btn-book" href="#book">Book Now</a>
			</div>
		</div>

		<div class="event-card">
			<img src="assets/images/catring/6.jpeg">
			<div class="event-body">
				<h2>Festival Catering</h2>
				<p>Traditional feasts for Pongal, Diwali, Eid, Christmas & custom celebrations.</p>
				<div class="price-range">Starts ₹20,000</div>
				<a class="btn-book" href="#book">Book Now</a>
			</div>
		</div>

	</div>
</section>


    
    <style>
        /* --- 1. General Section Styling --- */
        .booking-section {
            background: #F5E6D3; /* Soft grey gradient */
            padding: 60px 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* --- 2. The Card Container --- */
        /* --- The Container with Background Image --- */
.form-container2 {
    max-width: 900px;
    margin: 0 auto;
    
    /* ⭐ ADD IMAGE HERE ⭐ */
    /* This creates a dark 70% opacity overlay on top of your image */
    background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), 
                url('assets/images/catring.jpeg'); /* REPLACE THIS PATH */
    
    background-size: cover;      /* Ensures image fills the whole box */
    background-position: center; /* Centers the image */
    background-repeat: no-repeat;

    border-radius: 20px;
    box-shadow: 0 15px 35px rgba(0,0,0,0.3); /* Slightly darker shadow for better contrast */
    padding: 40px;
    overflow: hidden;
    position: relative;
    color: #fff; /* Sets default text color inside to white */
}

/* --- IMPORTANT: Adjust Text Colors for Readability --- */

/* Change title color to white */
.form-title {
    color: #ffffff !important; 
}

/* Change input labels to white so they show up against the dark background */
.input-group label {
    color: #e0e0e0 !important; /* Light grey looks softer than pure white */
}

/* Optional: Make inputs slightly transparent to show background through */
.form-control2 {
    background: rgba(255, 255, 255, 0.9) !important;
    width: 350px;
     /* 90% opaque white */
}
.form-control3 {
    background: rgba(255, 255, 255, 0.9) !important;
    width: 750px;
    height: 100px;
     /* 90% opaque white */
}
        /* Decorative top bar */
        .form-container2::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0;
            height: 8px;
            background: linear-gradient(90deg, #EAB308, #FF512F); /* Your Theme Colors */
        }

        .form-title {
            text-align: center;
            color: #333;
            font-size: 2.2rem;
            margin-bottom: 30px;
            font-weight: 700;
        }

        /* --- 3. Grid Layout --- */
        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr; /* Two columns */
            gap: 25px;
        }

        /* Span full width for specific items */
        .full-width {
            grid-column: span 2;
        }

        /* --- 4. Input Styling --- */
        .input-group {
            display: flex;
            flex-direction: column;
        }

        .input-group label {
            font-size: 14px;
            font-weight: 600;
            color: #c17676ff;
            margin-bottom: 8px;
        }

        .form-control2 {
            border: 2px solid #eee;
            background: #f9f9f9;
            padding: 12px 15px;
            border-radius: 10px;
            font-size: 15px;
            transition: 0.3s;
            outline: none;
        }

        .form-control2:focus {
            border-color: #EAB308; /* Focus color */
            background: #fff;
            box-shadow: 0 0 0 4px rgba(234, 179, 8, 0.1);
        }

        /* --- 5. Map Styling --- */
        #map {
            height: 250px;
            width: 100%;
            border-radius: 12px;
            margin-top: 10px;
            border: 2px solid #ddd;
            z-index: 1;
        }
        
        .map-help-text {
            font-size: 12px;
            color: #888;
            margin-top: 5px;
            font-style: italic;
        }

        /* --- 6. Buttons --- */
        .btn-container {
            grid-column: span 2;
            display: flex;
            gap: 15px;
            margin-top: 20px;
        }

        .submit-btn {
            flex: 2;
            background: #EAB308;
            color: #000;
            border: none;
            padding: 15px;
            font-size: 18px;
            font-weight: bold;
            border-radius: 10px;
            cursor: pointer;
            transition: 0.3s;
        }

        .submit-btn:hover {
            background: #000;
            color: #fff;
        }

        .btn-whatsapp {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #25D366;
            color: white;
            text-decoration: none;
            font-weight: bold;
            border-radius: 10px;
            transition: 0.3s;
        }

        .btn-whatsapp:hover {
            background: #128C7E;
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .form-grid { grid-template-columns: 1fr; } /* Stack on mobile */
            .full-width { grid-column: span 1; }
            .btn-container { flex-direction: column; }
        }
        /* =========================================
   MOBILE RESPONSIVENESS FOR BOOKING FORM
   ========================================= */

/* General Mobile Tweaks */
@media (max-width: 768px) {
    
    /* 1. Make the main container fit the screen */
    .form-container2 {
        width: 95% !important;
        padding: 20px 15px !important; /* Smaller padding */
        margin: 0 auto;
    }

    /* 2. Force the Grid to 1 Column (Stack inputs) */
    .form-grid {
        display: block !important; /* Disable grid */
        width: 100%;
    }

    /* 3. Add spacing between stacked inputs */
    .input-group {
        width: 100% !important;
        margin-bottom: 15px !important;
    }

    /* 4. Ensure inputs are full width and touch-friendly */
    .form-control2, 
    .form-control3, 
    select.form-control2 {
        width: 100% !important;
        font-size: 16px; /* Prevent zoom on iPhone */
        height: 50px; /* Taller for touch */
    }

    /* 5. Fix the Map Container */
    #map {
        width: 100%;
        height: 250px; /* Fixed height for mobile */
        border-radius: 10px;
    }

    /* 6. Stack the Buttons (Confirm & WhatsApp) */
    .catering-submit-btn {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .submit-btn, 
    .btn-whatsapp {
        width: 100%; /* Full width buttons */
        display: block;
        text-align: center;
        padding: 15px;
    }
}
    </style>
</head>
<body>

<section class="booking-section" id="book">
    <div class="form-container2">
        <h2 class="form-title">✨ Book Catering Services</h2>
        
        <form id="cateringForm" action="process_booking.php" method="POST">
            <div class="form-grid">
                
                <div class="input-group">
                    <label>Your Name</label>
                    <input type="text" name="name" class="form-control2" placeholder="John Doe" required>
                </div>

                <div class="input-group">
                    <label>Mobile Number</label>
                    <input type="tel" name="phone" class="form-control2" placeholder="+91 98765 43210" required>
                </div>

                <div class="input-group">
                    <label>Email Address</label>
                    <input type="email" name="email" class="form-control2" placeholder="john@example.com" required>
                </div>

                <div class="input-group">
                    <label>Event Type</label>
                    <select name="event_type" class="form-control2" required>
                        <option value="" disabled selected>Select Event</option>
                        <option>Wedding</option>
                        <option>Birthday</option>
                        <option>Corporate Event</option>
                        <option>Engagement</option>
                        <option>House Warming</option>
                    </select>
                </div>

                <div class="input-group">
                    <label>Date of Event</label>
                    <input type="date" name="date" class="form-control2" required>
                </div>

                <div class="input-group">
                    <label>No. of Guests</label>
                    <input type="number" name="guests" class="form-control2" placeholder="e.g. 200" required>
                </div>

                <div class="input-group">
                    <label>Food Preference</label>
                    <select name="food_pref" class="form-control2" required>
                        <option>Veg Only</option>
                        <option>Non-Veg Only</option>
                        <option>Mixed (Veg & Non-Veg)</option>
                    </select>
                </div>

                <div class="input-group full-width">
                    <label>Location / Address</label>
                    <textarea name="address" id="addressBox" class="form-control3" rows="2" placeholder="Type address or select on map..." required></textarea>
                    
                    <input type="hidden" name="gps_coordinates" id="gps_coordinates">

                    <div id="map"></div>
                    <p class="map-help-text">📍 Drag the blue pin to pinpoint your exact event location.</p>
                </div>

            </div>

                <div class="btn-container">

<div class="catering-submit-btn">

<?php if (isset($_SESSION['user_id'])): ?>

    <button class="submit-btn" type="submit">
        Confirm Booking
    </button>

<?php else: ?>

    <button class="submit-btn" type="button" onclick="promptLogin()">
        Confirm Booking
    </button>

<?php endif; ?>

    <a class="btn-whatsapp" href="https://wa.me/919999999999" target="_blank">
        📲 WhatsApp Inquiry
    </a>

</div>

<script>
function promptLogin() {
    Swal.fire({
        title: 'Login Required',
        text: "You must be signed in to book catering services!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#78350f', // Matches your Bermiz brown theme
        cancelButtonColor: '#d33',
        confirmButtonText: 'Go to Sign In'
    }).then((result) => {
        if (result.isConfirmed) {
            // Redirect to Login Page
            window.location.href = 'login.php'; 
        }
    });
}
</script>
            </div>
        </form>
    </div>
</section>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
    // 1. Initialize the map
    // 'map' is the ID of the div, [20.5937, 78.9629] are coords for India (center)
    // 5 is the zoom level
    var map = L.map('map').setView([13.0827, 80.2707], 11); // Set to Chennai (Change coords to your city)

    // 2. Add the OpenStreetMap tiles (The visual map)
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);

    // 3. Add a draggable marker
    var marker = L.marker([13.0827, 80.2707], {
        draggable: true
    }).addTo(map);

    // 4. Function to handle marker drag
    marker.on('dragend', function(e) {
        var coord = marker.getLatLng();
        var lat = coord.lat;
        var lng = coord.lng;
        
        // Update hidden input
        document.getElementById("gps_coordinates").value = lat + "," + lng;
        
        // Optional: Update text area to show "Selected on Map"
        var addressBox = document.getElementById("addressBox");
        if(addressBox.value === "") {
            addressBox.value = "Location selected on map (" + lat.toFixed(5) + ", " + lng.toFixed(5) + ")";
        }
    });

    // 5. Try to get user's current location on load
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
            var lat = position.coords.latitude;
            var lng = position.coords.longitude;
            var newLatLng = new L.LatLng(lat, lng);
            marker.setLatLng(newLatLng);
            map.setView(newLatLng, 15); // Zoom in closer
            document.getElementById("gps_coordinates").value = lat + "," + lng;
        });
    }
</script>

<!-- ⭐ FOOTER ⭐ -->
<footer class="restaurant-footer">
    <div class="footer-container">

        <!-- Left Top Logo + Text -->
        <div class="footer-brand">
            <img src="assets/images/Homepage1/footer-logo.png" alt="Restaurant Logo" class="footer-logo">
            <p class="footer-desc">
                A premium dining experience with handcrafted dishes, fresh ingredients, 
                and an elegant ambiance. Your comfort is our priority.
            </p>
        </div>

        <!-- Quick Links -->
        <div class="footer-links">
            <h4>Quick Links</h4>
            <ul>
                <li><a href="reservation-1.php">Reserve a Table</a></li>
                
                <li><a href="#menupage-veg.php">Explore Menu</a></li>
                <li><a href="#weekly.php">Special Offers</a></li>
                <li><a href="#catering-events.php">Catering Service</a></li>
            </ul>
        </div>

        <!-- Contact Section -->
        <div class="footer-contact">
            <h4>Contact Us</h4>
            <p> 123 Food Street, Chennai</p>
            <p> +91 98765 43210</p>
            <p>✉ support@restaurant.com</p>

            <div class="footer-social">
                <a href="#"><i class="fa fa-facebook"></i></a>
                <a href="#"><i class="fa fa-instagram"></i></a>
                <a href="#"><i class="fa fa-twitter"></i></a>
                <a href="#"><i class="fa fa-youtube"></i></a>
            </div>
        </div>

        <!-- Working Hours -->
        <div class="footer-hours">
            <h4>Working Hours</h4>
            <p>Mon – Fri : 09:00 - 22:00</p>
            <p>Saturday : 11:00 - 23:30</p>
            <p>Sunday : 11:00 - 23:00</p>
        </div>

    </div>

    <div class="footer-bottom">
        <p>© 2025 Your Restaurant Name. All Rights Reserved.</p>
        <div class="footer-bottom-links">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms of Service</a>
        </div>
    </div>
</footer>
		<!-- Footer Section End -->
		<!-- Fixed Search Bar Start -->
		<div>
			<div class="fixed-serach-icon ">
				<div class="fixed-search ">
					<a href="javascript:void(0)">
						<svg width="24" height="24" viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<mask id="mask0_504_17203" style="mask-type:alpha" maskunits="userSpaceOnUse" x="0" y="0" width="24" height="24">
								<rect width="24" height="24" fill="white"></rect>
							</mask>
							<g mask="url(#mask0_504_17203)">
								<circle cx="11.7666" cy="11.7666" r="8.98856" stroke="#F5E6D3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></circle>
								<path d="M18.0183 18.4851L21.5423 22" stroke="#F5E6D3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
							</g>
						</svg>
					</a>
				</div>
			</div> 
			<div class="search-popup">
				<span class="search-back-drop"></span>
				<button class="close-search"><span class="fa fa-times"></span></button>
				<div class="search-inner">
					<form method="post" action="index.php">
						<div class="form-group">
							<input type="search" name="search-field" value="" placeholder="Search..." required="">
							<button type="submit"><i class="fa fa-search"></i></button>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- Fixed Search Bar End -->
		<!-- Hero Video Modal Start -->
		<div class="modal fade homepage-video-modal" id="hero-video-modal">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<video class="video-sec" controls="" loop="" muted="" autoplay="">
							<source src="assets/images/Homepage1/video.mp4" type="video/mp4">
							</video>
						</div>
					</div>
				</div>
			</div>
			<!-- Hero Video Modal End -->
			<!--Scroll Top to Bottom Start -->
			<div class="scroll-top" data-scroll="up">		
			</div>
			<!--Scroll Top to Bottom  End -->
		</div>
		<script src="assets/js/jquery-min-3.6.0.js"></script>
		<script src="assets/js/slick.min.js"></script>
		<script src="assets/js/bootstrap.bundle.min.js"></script>
		<script src="assets/js/aos.js"></script>
		<script src="assets/js/jquery-ui.min.js"></script>
		<script src="assets/js/datepicker.js"></script>
		<script src="assets/js/wow.min.js"></script>
		<script src="assets/js/photoswipe.min.js"></script>
		<script src="assets/js/photoswipe-ui-default.min.js"></script>
		<script src="assets/js/gallery-popup.js"></script>
		<script src="assets/js/TweenMax.min.js"></script>
		<script src="assets/js/ScrollMagic.js"></script>
		<script src="assets/js/animation.gsap.min.js"></script>
		<script src="assets/js/scolling.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
		<script src="assets/js/custom.js"></script>

<!-- ===== Script Animation ===== -->
<script>
const events = document.querySelectorAll('.event-card');
function showEvents(){
 events.forEach(card=>{
   if(card.getBoundingClientRect().top < window.innerHeight - 80){ card.classList.add('visible'); }
 });
}
window.addEventListener('scroll', showEvents);
window.addEventListener('load', showEvents);
</script>

</body>
</html>
