<?php
session_start();
header('Content-Type: application/json');

$conn = new mysqli("localhost", "root", "", "bermiz_db");

if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed"]));
}

// --- IDENTITY LOGIC ---
// Check if user is logged in (Assuming you store 'user_id' in session on login)
$is_logged_in = isset($_SESSION['user_id']);
$user_id = $is_logged_in ? $_SESSION['user_id'] : null;
$session_id = session_id();

$action = $_POST['action'] ?? '';

// --- 1. FETCH CART ---
if ($action == 'fetch') {
    if ($is_logged_in) {
        // Fetch items by User ID
        $sql = "SELECT * FROM cart WHERE user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
    } else {
        // Fetch items by Session ID (Guest)
        $sql = "SELECT * FROM cart WHERE session_id = ? AND user_id IS NULL";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $session_id);
    }

    $stmt->execute();
    $result = $stmt->get_result();
    $cartItems = [];
    while ($row = $result->fetch_assoc()) {
        $cartItems[] = $row;
    }
    echo json_encode($cartItems);
    exit;
}

// --- 2. ADD TO CART ---
if ($action == 'add') {
    $name = $_POST['name'];
    $price = $_POST['price'];
    $image = $_POST['image'];

    // Check if item exists
    if ($is_logged_in) {
        $check = $conn->prepare("SELECT id, quantity FROM cart WHERE user_id = ? AND product_name = ?");
        $check->bind_param("is", $user_id, $name);
    } else {
        $check = $conn->prepare("SELECT id, quantity FROM cart WHERE session_id = ? AND user_id IS NULL AND product_name = ?");
        $check->bind_param("ss", $session_id, $name);
    }
    
    $check->execute();
    $result = $check->get_result();

    if ($result->num_rows > 0) {
        // Update Quantity
        $row = $result->fetch_assoc();
        $newQty = $row['quantity'] + 1;
        $update = $conn->prepare("UPDATE cart SET quantity = ? WHERE id = ?");
        $update->bind_param("ii", $newQty, $row['id']);
        $update->execute();
    } else {
        // Insert New Item
        if ($is_logged_in) {
            $insert = $conn->prepare("INSERT INTO cart (user_id, session_id, product_name, product_price, product_image, quantity) VALUES (?, ?, ?, ?, ?, 1)");
            $insert->bind_param("issds", $user_id, $session_id, $name, $price, $image);
        } else {
            $insert = $conn->prepare("INSERT INTO cart (session_id, product_name, product_price, product_image, quantity) VALUES (?, ?, ?, ?, 1)");
            $insert->bind_param("ssds", $session_id, $name, $price, $image);
        }
        $insert->execute();
    }
    echo json_encode(["status" => "success"]);
    exit;
}

// --- 3. UPDATE QUANTITY & REMOVE ---
// (Logic remains mostly same, just referencing ID is enough)
if ($action == 'update_qty') {
    $id = $_POST['id'];
    $qty = $_POST['qty'];

    if ($qty < 1) {
        $stmt = $conn->prepare("DELETE FROM cart WHERE id = ?");
        $stmt->bind_param("i", $id);
    } else {
        $stmt = $conn->prepare("UPDATE cart SET quantity = ? WHERE id = ?");
        $stmt->bind_param("ii", $qty, $id);
    }
    $stmt->execute();
    echo json_encode(["status" => "success"]);
    exit;
}

if ($action == 'remove') {
    $id = $_POST['id'];
    $stmt = $conn->prepare("DELETE FROM cart WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    echo json_encode(["status" => "success"]);
    exit;
}

$conn->close();
?>