-- ================================================
-- WEEKLY SPECIALS TABLE SETUP
-- ================================================
-- Run this SQL to create and populate the weekly_specials table

CREATE TABLE IF NOT EXISTS `weekly_specials` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `title` VARCHAR(255) NOT NULL,
  `description` TEXT NOT NULL,
  `price` VARCHAR(100) NOT NULL,
  `category` VARCHAR(50) NOT NULL,
  `image_path` VARCHAR(255) NOT NULL,
  `badge_type` ENUM('hot', 'new', 'offer', 'none') DEFAULT 'none',
  `created_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Sample Weekly Specials (optional - admin can add their own)
INSERT INTO `weekly_specials` (`title`, `description`, `price`, `category`, `image_path`, `badge_type`) VALUES 
('Sunday Feast', 'Royal Biryani + Chicken 65 + Sweet + Drink', '₹399 Family Offer', 'dinner', 'assets/images/weekly/1.jpeg', 'hot'),
('Veg Delight', 'Paneer Butter Masala + Butter Roti (2)', '₹129 Only', 'lunch', 'assets/images/weekly/4.jpeg', 'new'),
('Grill Day', 'Tandoori Chicken / Paneer Tikka + Mint Dip', 'Add Drink ₹20 Only', 'dinner', 'assets/images/weekly/2.jpeg', 'hot'),
('Pasta & Pizza', 'Creamy Pasta + Slice Pizza + Garlic Bread', 'Extra Cheese Free 🧀', 'lunch', 'assets/images/weekly/5.jpeg', 'none'),
('Budget Meal', 'Small Meal Boxes: Veg, Egg, Chicken', 'Starts ₹79', 'special', 'assets/images/weekly/7.jpg', 'offer'),
('Chinese Flavor', 'Fried Rice + Manchurian + Spring Rolls', 'Free Soup 🍲', 'lunch', 'assets/images/weekly/3.jpeg', 'none'),
('Fast Food Fiesta', 'Crispy Burger + Fries + Drink', '₹49 Fries Combo', 'lunch', 'assets/images/weekly/6.jpeg', 'none');

-- ================================================
-- NOTES:
-- 1. The admin can now manage weekly specials from: /admin/weekly.php
-- 2. Website displays weekly specials from database at: /weekly.php (READ-ONLY for users)
-- 3. Categories available: breakfast, lunch, dinner, dessert, drinks, special
-- 4. Badge types: hot (🔥), new (⭐), offer (💰), none (no badge)
-- 5. Images should be uploaded to assets/images/weekly/
-- ================================================
