<?php
require_once 'check_admin.php';

// Get all registered users
$users_result = $conn->query("SELECT id, name, email, created_at FROM users ORDER BY created_at DESC");
$users = [];
if ($users_result) {
    while ($row = $users_result->fetch_assoc()) {
        $users[] = $row;
    }
}

$total_users = count($users);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registered Users - Admin Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/admin-style.css">
</head>
<body>
    <div class="wrapper">
        
        <?php include 'sidebar.php'; ?>

        <div class="main-content">
            <nav class="top-nav">
                <div class="nav-left">
                    <h2><i class="fas fa-users"></i> Registered Users</h2>
                </div>
                <div class="nav-right">
                    <span class="admin-name">Total Users: <strong><?php echo $total_users; ?></strong></span>
                </div>
            </nav>

            <div class="content">
                
                <!-- Users Statistics -->
                <div class="row mb-4">
                    <div class="col-md-4">
                        <div class="stat-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                            <div class="stat-icon mb-2">
                                <i class="fas fa-users fa-2x opacity-50"></i>
                            </div>
                            <h3><?php echo $total_users; ?></h3>
                            <p class="mb-0 text-white-50 text-uppercase small ls-1">Total Registered Users</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="stat-card" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                            <div class="stat-icon mb-2">
                                <i class="fas fa-user-plus fa-2x opacity-50"></i>
                            </div>
                            <h3><?php 
                                $this_month = $conn->query("SELECT COUNT(*) as count FROM users WHERE MONTH(created_at) = MONTH(NOW()) AND YEAR(created_at) = YEAR(NOW())")->fetch_assoc()['count'];
                                echo $this_month;
                            ?></h3>
                            <p class="mb-0 text-white-50 text-uppercase small ls-1">This Month</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="stat-card" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                            <div class="stat-icon mb-2">
                                <i class="fas fa-calendar-day fa-2x opacity-50"></i>
                            </div>
                            <h3><?php 
                                $today = $conn->query("SELECT COUNT(*) as count FROM users WHERE DATE(created_at) = CURDATE()")->fetch_assoc()['count'];
                                echo $today;
                            ?></h3>
                            <p class="mb-0 text-white-50 text-uppercase small ls-1">Today</p>
                        </div>
                    </div>
                </div>

                <!-- Users Table -->
                <div class="card shadow-sm">
                    <div class="card-header bg-light d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="fas fa-table me-2"></i> User Details
                        </h5>
                        <input type="text" class="form-control form-control-sm" style="width: 250px;" placeholder="Search by name or email..." id="searchInput">
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 50px;">#</th>
                                    <th>User Name</th>
                                    <th>Email Address</th>
                                    <th>Registration Date</th>
                                    <th style="width: 100px;">Actions</th>
                                </tr>
                            </thead>
                            <tbody id="usersTableBody">
                                <?php if (!empty($users)): ?>
                                    <?php $i = 1; foreach ($users as $user): ?>
                                        <tr class="user-row" data-name="<?php echo strtolower($user['name']); ?>" data-email="<?php echo strtolower($user['email']); ?>">
                                            <td><span class="badge bg-primary"><?php echo $i; ?></span></td>
                                            <td>
                                                <i class="fas fa-user-circle me-2"></i>
                                                <strong><?php echo htmlspecialchars($user['name']); ?></strong>
                                            </td>
                                            <td>
                                                <a href="mailto:<?php echo htmlspecialchars($user['email']); ?>">
                                                    <?php echo htmlspecialchars($user['email']); ?>
                                                </a>
                                            </td>
                                            <td>
                                                <small class="text-muted">
                                                    <?php echo date('d M Y, h:i A', strtotime($user['created_at'])); ?>
                                                </small>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-info" title="View Details" onclick="viewUser(<?php echo $user['id']; ?>, '<?php echo htmlspecialchars($user['name']); ?>', '<?php echo htmlspecialchars($user['email']); ?>')">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php $i++; endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="5" class="text-center text-muted py-4">
                                            <i class="fas fa-inbox fa-3x mb-3 opacity-50"></i>
                                            <p>No registered users found</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- User Details Modal -->
    <div class="modal fade" id="userModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h5 class="modal-title">
                        <i class="fas fa-user-circle me-2"></i>
                        <span id="modalUserName"></span>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-12">
                            <label class="form-label text-muted small">Email Address</label>
                            <p class="mb-0">
                                <strong id="modalUserEmail"></strong>
                            </p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-12">
                            <label class="form-label text-muted small">User ID</label>
                            <p class="mb-0">
                                <strong id="modalUserId"></strong>
                            </p>
                        </div>
                    </div>
                    <div class="alert alert-info" role="alert">
                        <i class="fas fa-info-circle me-2"></i>
                        User information displayed. For more actions, contact support.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script>
        // Search functionality
        document.getElementById('searchInput').addEventListener('keyup', function() {
            const searchTerm = this.value.toLowerCase();
            const rows = document.querySelectorAll('.user-row');
            
            rows.forEach(row => {
                const name = row.getAttribute('data-name');
                const email = row.getAttribute('data-email');
                
                if (name.includes(searchTerm) || email.includes(searchTerm)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });

        // View user details
        function viewUser(id, name, email) {
            document.getElementById('modalUserId').textContent = id;
            document.getElementById('modalUserName').textContent = name;
            document.getElementById('modalUserEmail').textContent = email;
            
            const userModal = new bootstrap.Modal(document.getElementById('userModal'));
            userModal.show();
        }
    </script>
</body>
</html>
