<?php
require_once 'check_admin.php';

// Handle form submissions
$success_msg = '';
$error_msg = '';

// Check if hero_slides table exists, if not create it
$check_table = $conn->query("SHOW TABLES LIKE 'hero_slides'");
if ($check_table->num_rows == 0) {
    $create_table_sql = "CREATE TABLE IF NOT EXISTS hero_slides (
        id INT AUTO_INCREMENT PRIMARY KEY,
        title VARCHAR(255) NOT NULL,
        description TEXT NOT NULL,
        button_text VARCHAR(100) NOT NULL,
        button_link VARCHAR(255) NOT NULL,
        background_image VARCHAR(255) NOT NULL,
        layer_image VARCHAR(255),
        is_active TINYINT(1) DEFAULT 1,
        display_order INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $conn->query($create_table_sql);
}

// Create upload directory if it doesn't exist
$upload_dir = '../assets/images/slider/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// Handle Add/Edit Slide
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'];
    $title = $conn->real_escape_string($_POST['title']);
    $description = $conn->real_escape_string($_POST['description']);
    $button_text = $conn->real_escape_string($_POST['button_text']);
    $button_link = $conn->real_escape_string($_POST['button_link']);
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $display_order = (int)$_POST['display_order'];
    
    if ($action === 'add') {
        $background_image = $_POST['background_image'] ?? '';
        $layer_image = $_POST['layer_image'] ?? '';
        
        // Handle background image upload
        if (!empty($_FILES['bg_image']['name'])) {
            $file = $_FILES['bg_image'];
            $filename = time() . '_bg_' . basename($file['name']);
            $filepath = $upload_dir . $filename;
            
            if (move_uploaded_file($file['tmp_name'], $filepath)) {
                $background_image = 'assets/images/slider/' . $filename;
            } else {
                $error_msg = 'Failed to upload background image.';
            }
        }
        
        // Handle layer image upload
        if (!empty($_FILES['layer_image']['name'])) {
            $file = $_FILES['layer_image'];
            $filename = time() . '_layer_' . basename($file['name']);
            $filepath = $upload_dir . $filename;
            
            if (move_uploaded_file($file['tmp_name'], $filepath)) {
                $layer_image = 'assets/images/slider/' . $filename;
            }
        }
        
        if (empty($error_msg)) {
            $insert_sql = "INSERT INTO hero_slides (title, description, button_text, button_link, background_image, layer_image, is_active, display_order) 
                          VALUES ('$title', '$description', '$button_text', '$button_link', '$background_image', '$layer_image', $is_active, $display_order)";
            
            if ($conn->query($insert_sql)) {
                $success_msg = 'Hero slide added successfully!';
            } else {
                $error_msg = 'Error adding slide: ' . $conn->error;
            }
        }
    } elseif ($action === 'edit' && isset($_POST['slide_id'])) {
        $slide_id = (int)$_POST['slide_id'];
        
        // Get current slide data
        $current_slide = $conn->query("SELECT * FROM hero_slides WHERE id = $slide_id")->fetch_assoc();
        
        $background_image = $current_slide['background_image'];
        $layer_image = $current_slide['layer_image'];
        
        // Handle background image upload
        if (!empty($_FILES['bg_image']['name'])) {
            $file = $_FILES['bg_image'];
            $filename = time() . '_bg_' . basename($file['name']);
            $filepath = $upload_dir . $filename;
            
            if (move_uploaded_file($file['tmp_name'], $filepath)) {
                // Delete old image if it exists
                if (!empty($current_slide['background_image']) && file_exists('../' . $current_slide['background_image'])) {
                    unlink('../' . $current_slide['background_image']);
                }
                $background_image = 'assets/images/slider/' . $filename;
            }
        }
        
        // Handle layer image upload
        if (!empty($_FILES['layer_image']['name'])) {
            $file = $_FILES['layer_image'];
            $filename = time() . '_layer_' . basename($file['name']);
            $filepath = $upload_dir . $filename;
            
            if (move_uploaded_file($file['tmp_name'], $filepath)) {
                // Delete old image if it exists
                if (!empty($current_slide['layer_image']) && file_exists('../' . $current_slide['layer_image'])) {
                    unlink('../' . $current_slide['layer_image']);
                }
                $layer_image = 'assets/images/slider/' . $filename;
            }
        }
        
        $update_sql = "UPDATE hero_slides SET 
                      title = '$title',
                      description = '$description',
                      button_text = '$button_text',
                      button_link = '$button_link',
                      background_image = '$background_image',
                      layer_image = '$layer_image',
                      is_active = $is_active,
                      display_order = $display_order
                      WHERE id = $slide_id";
        
        if ($conn->query($update_sql)) {
            $success_msg = 'Hero slide updated successfully!';
        } else {
            $error_msg = 'Error updating slide: ' . $conn->error;
        }
    }
}

// Handle Delete
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $slide_id = (int)$_GET['delete'];
    
    // Get slide data before deleting to remove images
    $slide = $conn->query("SELECT * FROM hero_slides WHERE id = $slide_id")->fetch_assoc();
    
    // Delete images
    if (!empty($slide['background_image']) && file_exists('../' . $slide['background_image'])) {
        unlink('../' . $slide['background_image']);
    }
    if (!empty($slide['layer_image']) && file_exists('../' . $slide['layer_image'])) {
        unlink('../' . $slide['layer_image']);
    }
    
    $delete_sql = "DELETE FROM hero_slides WHERE id = $slide_id";
    if ($conn->query($delete_sql)) {
        $success_msg = 'Hero slide deleted successfully!';
    } else {
        $error_msg = 'Error deleting slide: ' . $conn->error;
    }
}

// Get all slides
$slides = $conn->query("SELECT * FROM hero_slides ORDER BY display_order ASC");
$edit_slide = null;
if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
    $slide_id = (int)$_GET['edit'];
    $edit_slide = $conn->query("SELECT * FROM hero_slides WHERE id = $slide_id")->fetch_assoc();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hero Slider Management - Admin Panel</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/admin-style.css">
    <style>
        .slider-preview {
            width: 100%;
            height: 200px;
            object-fit: cover;
            border-radius: 8px;
            margin-top: 10px;
        }
        .slide-card {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            transition: all 0.3s ease;
        }
        .slide-card:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            background: #fff;
        }
        .slide-image {
            height: 120px;
            object-fit: cover;
            border-radius: 5px;
        }
        .badge-active {
            background-color: #28a745;
        }
        .badge-inactive {
            background-color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <?php include 'sidebar.php'; ?>
        
        <div class="main-content">
            <nav class="top-nav">
                <div class="nav-left">
                    <h2><i class="fas fa-images"></i> Hero Slider Management</h2>
                </div>
            </nav>
            
            <div class="content p-4">
                <!-- Alert Messages -->
                <?php if (!empty($success_msg)): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i> <?php echo $success_msg; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($error_msg)): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle"></i> <?php echo $error_msg; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <div class="row">
                    <!-- Form Section -->
                    <div class="col-lg-5 mb-4">
                        <div class="card shadow-sm">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0">
                                    <i class="fas fa-plus"></i>
                                    <?php echo $edit_slide ? 'Edit Slide' : 'Add New Slide'; ?>
                                </h5>
                            </div>
                            <div class="card-body">
                                <form method="POST" enctype="multipart/form-data">
                                    <input type="hidden" name="action" value="<?php echo $edit_slide ? 'edit' : 'add'; ?>">
                                    <?php if ($edit_slide): ?>
                                        <input type="hidden" name="slide_id" value="<?php echo $edit_slide['id']; ?>">
                                    <?php endif; ?>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Slide Title *</label>
                                        <input type="text" class="form-control" name="title" required
                                               value="<?php echo $edit_slide['title'] ?? ''; ?>">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Description *</label>
                                        <textarea class="form-control" name="description" rows="3" required><?php echo $edit_slide['description'] ?? ''; ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Button Text *</label>
                                        <input type="text" class="form-control" name="button_text" required
                                               value="<?php echo $edit_slide['button_text'] ?? ''; ?>"
                                               placeholder="e.g., Discover Menu">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Button Link *</label>
                                        <input type="text" class="form-control" name="button_link" required
                                               value="<?php echo $edit_slide['button_link'] ?? ''; ?>"
                                               placeholder="e.g., menupage-veg.php">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Background Image
                                            <?php if (!$edit_slide): ?>
                                                <span class="text-danger">*</span>
                                            <?php endif; ?>
                                        </label>
                                        <input type="file" class="form-control" name="bg_image" accept="image/*"
                                               <?php echo !$edit_slide ? 'required' : ''; ?>>
                                        <?php if ($edit_slide && !empty($edit_slide['background_image'])): ?>
                                            <small class="text-muted">Current: <?php echo basename($edit_slide['background_image']); ?></small>
                                            <img src="<?php echo '../' . $edit_slide['background_image']; ?>" class="slider-preview" alt="Current BG">
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Layer Image (Decorative)</label>
                                        <input type="file" class="form-control" name="layer_image" accept="image/*">
                                        <?php if ($edit_slide && !empty($edit_slide['layer_image'])): ?>
                                            <small class="text-muted">Current: <?php echo basename($edit_slide['layer_image']); ?></small>
                                            <img src="<?php echo '../' . $edit_slide['layer_image']; ?>" class="slider-preview" alt="Current Layer">
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Display Order</label>
                                        <input type="number" class="form-control" name="display_order" value="<?php echo $edit_slide['display_order'] ?? 0; ?>">
                                        <small class="text-muted">Lower numbers appear first</small>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="is_active" id="is_active"
                                                   <?php echo ($edit_slide && $edit_slide['is_active']) || !$edit_slide ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="is_active">
                                                Active on Homepage
                                            </label>
                                        </div>
                                    </div>
                                    
                                    <div class="d-grid gap-2">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i>
                                            <?php echo $edit_slide ? 'Update Slide' : 'Add Slide'; ?>
                                        </button>
                                        <?php if ($edit_slide): ?>
                                            <a href="slider.php" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> Cancel
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Slides List Section -->
                    <div class="col-lg-7">
                        <div class="card shadow-sm">
                            <div class="card-header bg-secondary text-white">
                                <h5 class="mb-0"><i class="fas fa-list"></i> Active Slides</h5>
                            </div>
                            <div class="card-body">
                                <?php if ($slides->num_rows > 0): ?>
                                    <?php while ($slide = $slides->fetch_assoc()): ?>
                                        <div class="slide-card">
                                            <div class="row align-items-start">
                                                <div class="col-md-4">
                                                    <?php if (!empty($slide['background_image']) && file_exists('../' . $slide['background_image'])): ?>
                                                        <img src="<?php echo '../' . $slide['background_image']; ?>" class="slide-image" alt="<?php echo htmlspecialchars($slide['title']); ?>">
                                                    <?php else: ?>
                                                        <div class="slide-image bg-light d-flex align-items-center justify-content-center">
                                                            <i class="fas fa-image text-muted fa-2x"></i>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="col-md-8">
                                                    <h6 class="mb-2">
                                                        <?php echo htmlspecialchars($slide['title']); ?>
                                                        <span class="badge <?php echo $slide['is_active'] ? 'badge-active' : 'badge-inactive'; ?> ms-2">
                                                            <?php echo $slide['is_active'] ? 'Active' : 'Inactive'; ?>
                                                        </span>
                                                    </h6>
                                                    <p class="mb-2 text-muted small"><?php echo substr(htmlspecialchars($slide['description']), 0, 80); ?>...</p>
                                                    <p class="mb-2"><small><strong>Button:</strong> <?php echo htmlspecialchars($slide['button_text']); ?></small></p>
                                                    <p class="mb-3"><small><strong>Order:</strong> <?php echo $slide['display_order']; ?></small></p>
                                                    
                                                    <div class="btn-group btn-group-sm" role="group">
                                                        <a href="slider.php?edit=<?php echo $slide['id']; ?>" class="btn btn-info" title="Edit">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </a>
                                                        <a href="slider.php?delete=<?php echo $slide['id']; ?>" class="btn btn-danger" 
                                                           onclick="return confirm('Are you sure you want to delete this slide?');" title="Delete">
                                                            <i class="fas fa-trash"></i> Delete
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <p class="text-center text-muted py-4">
                                        <i class="fas fa-inbox fa-2x mb-3"></i><br>
                                        No slides yet. Create your first slide!
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
</body>
</html>
