<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Quick Access</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 20px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
        }
        .header {
            color: white;
            margin-bottom: 40px;
            text-align: center;
        }
        .header h1 {
            font-size: 40px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .header p {
            font-size: 18px;
            opacity: 0.9;
        }
        .card-group {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }
        .access-card {
            background: white;
            border-radius: 10px;
            padding: 25px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            text-decoration: none;
            color: #333;
            display: flex;
            flex-direction: column;
        }
        .access-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            color: #333;
            text-decoration: none;
        }
        .access-card i {
            font-size: 40px;
            color: #667eea;
            margin-bottom: 15px;
        }
        .access-card h3 {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 10px;
        }
        .access-card p {
            font-size: 14px;
            color: #666;
            margin: 0;
            flex-grow: 1;
        }
        .btn-section {
            display: flex;
            gap: 10px;
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px solid #e0e0e0;
        }
        .btn-small {
            padding: 6px 12px;
            font-size: 12px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            flex: 1;
        }
        .btn-login {
            background: #667eea;
            color: white;
        }
        .btn-login:hover {
            background: #764ba2;
        }
        .docs-section {
            background: white;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        }
        .docs-section h2 {
            color: #333;
            font-weight: 600;
            margin-bottom: 20px;
            border-bottom: 3px solid #667eea;
            padding-bottom: 10px;
        }
        .docs-list {
            list-style: none;
            padding: 0;
        }
        .docs-list li {
            padding: 10px;
            border-bottom: 1px solid #f0f0f0;
            display: flex;
            align-items: center;
        }
        .docs-list li:last-child {
            border-bottom: none;
        }
        .docs-list i {
            margin-right: 12px;
            color: #667eea;
            min-width: 20px;
        }
        .docs-list a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
        }
        .docs-list a:hover {
            text-decoration: underline;
        }
        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        .feature-item {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #667eea;
        }
        .feature-item strong {
            color: #333;
        }
        .feature-item p {
            font-size: 12px;
            color: #666;
            margin: 5px 0 0 0;
        }
        .footer {
            text-align: center;
            color: white;
            margin-top: 40px;
            opacity: 0.8;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>🚀 Admin Dashboard</h1>
            <p>Restaurant Management System - Quick Access</p>
        </div>

        <!-- Main Access Cards -->
        <div class="card-group">
            <!-- Login -->
            <a href="admin_login.php" class="access-card">
                <i class="fas fa-sign-in-alt"></i>
                <h3>Login</h3>
                <p>Admin authentication and login portal</p>
                <div class="btn-section">
                    <button class="btn-small btn-login" onclick="location.href='admin_login.php'; return false;">Enter Panel</button>
                </div>
            </a>

            <!-- Dashboard -->
            <a href="index.php" class="access-card">
                <i class="fas fa-chart-line"></i>
                <h3>Dashboard</h3>
                <p>View overview statistics and quick access</p>
                <div class="btn-section">
                    <button class="btn-small btn-login" onclick="location.href='index.php'; return false;">Go to Dashboard</button>
                </div>
            </a>

            <!-- Menu Management -->
            <a href="menu.php" class="access-card">
                <i class="fas fa-utensils"></i>
                <h3>Menu</h3>
                <p>Add, edit, and manage menu items by category</p>
                <div class="btn-section">
                    <button class="btn-small btn-login" onclick="location.href='menu.php'; return false;">Manage Menu</button>
                </div>
            </a>

            <!-- Reservations -->
            <a href="reservations.php" class="access-card">
                <i class="fas fa-calendar-alt"></i>
                <h3>Reservations</h3>
                <p>Handle and approve table reservations</p>
                <div class="btn-section">
                    <button class="btn-small btn-login" onclick="location.href='reservations.php'; return false;">View Reservations</button>
                </div>
            </a>

            <!-- Contact Messages -->
            <a href="contact.php" class="access-card">
                <i class="fas fa-envelope"></i>
                <h3>Messages</h3>
                <p>View and manage contact form submissions</p>
                <div class="btn-section">
                    <button class="btn-small btn-login" onclick="location.href='contact.php'; return false;">View Messages</button>
                </div>
            </a>

            <!-- Orders -->
            <a href="orders.php" class="access-card">
                <i class="fas fa-shopping-cart"></i>
                <h3>Orders</h3>
                <p>Track online delivery orders and cart items</p>
                <div class="btn-section">
                    <button class="btn-small btn-login" onclick="location.href='orders.php'; return false;">Manage Orders</button>
                </div>
            </a>
        </div>

        <!-- Documentation Section -->
        <div class="docs-section">
            <h2><i class="fas fa-book"></i> Documentation & Setup</h2>
            <div class="features-grid">
                <div class="feature-item">
                    <strong>📖 README.md</strong>
                    <p>Complete feature documentation</p>
                </div>
                <div class="feature-item">
                    <strong>⚙️ SETUP_GUIDE.txt</strong>
                    <p>Installation and setup instructions</p>
                </div>
                <div class="feature-item">
                    <strong>📁 FILE_STRUCTURE.md</strong>
                    <p>Detailed file and table descriptions</p>
                </div>
                <div class="feature-item">
                    <strong>🗄️ database_setup.sql</strong>
                    <p>SQL schema for all tables</p>
                </div>
                <div class="feature-item">
                    <strong>⚙️ config.php</strong>
                    <p>Configuration customization</p>
                </div>
                <div class="feature-item">
                    <strong>🎨 admin-style.css</strong>
                    <p>Complete dashboard styling</p>
                </div>
            </div>
        </div>

        <!-- Features Section -->
        <div class="docs-section">
            <h2><i class="fas fa-star"></i> Key Features</h2>
            <div class="row">
                <div class="col-md-6">
                    <ul class="docs-list">
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span><strong>Category-wise Menu:</strong> Organize items by category</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span><strong>Reservation Handling:</strong> Approve/reject bookings</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span><strong>Contact Management:</strong> Track customer messages</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span><strong>Order Tracking:</strong> Manage online delivery</span>
                        </li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <ul class="docs-list">
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span><strong>Complete CRUD:</strong> Create, read, update, delete</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span><strong>Responsive Design:</strong> Works on all devices</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span><strong>Admin Authentication:</strong> Secure login system</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span><strong>Statistics:</strong> Dashboard with key metrics</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Quick Start Section -->
        <div class="docs-section">
            <h2><i class="fas fa-rocket"></i> Quick Start</h2>
            <ol class="docs-list" style="list-style-type: decimal; padding-left: 20px;">
                <li><strong>Run database_setup.sql</strong> - Create database tables in phpMyAdmin</li>
                <li><strong>Set admin password</strong> - Use bcrypt hashing (see SETUP_GUIDE.txt)</li>
                <li><strong>Login to admin panel</strong> - Use admin@restaurant.com credentials</li>
                <li><strong>Add menu items</strong> - Go to Menu Management</li>
                <li><strong>Manage reservations</strong> - Go to Reservations</li>
                <li><strong>Track orders</strong> - Go to Orders</li>
            </ol>
        </div>

        <!-- System Information -->
        <div class="docs-section">
            <h2><i class="fas fa-info-circle"></i> System Information</h2>
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Database:</strong> bermiz_db</p>
                    <p><strong>Host:</strong> localhost</p>
                    <p><strong>Tables Created:</strong> 7</p>
                </div>
                <div class="col-md-6">
                    <p><strong>Version:</strong> 1.0</p>
                    <p><strong>Framework:</strong> PHP 7.4+</p>
                    <p><strong>Status:</strong> Production Ready ✅</p>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p>Restaurant Admin Dashboard | Version 1.0 | Created December 2025</p>
            <p style="font-size: 12px; margin-top: 10px;">
                Login URL: <code style="background: rgba(0,0,0,0.2); padding: 5px 10px; border-radius: 5px;">
                    http://localhost/Restaurant/admin/admin_login.php
                </code>
            </p>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
</body>
</html>
