-- Hero Slider Database Setup
-- This table stores all hero slider slides for dynamic management

CREATE TABLE IF NOT EXISTS hero_slides (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT NOT NULL,
    button_text VARCHAR(100) NOT NULL,
    button_link VARCHAR(255) NOT NULL,
    background_image VARCHAR(255) NOT NULL,
    layer_image VARCHAR(255),
    is_active TINYINT(1) DEFAULT 1,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default hero slides (festival theme)
INSERT INTO hero_slides (title, description, button_text, button_link, background_image, layer_image, is_active, display_order) VALUES
('Perfectly Light In Every Bite', 'We create magical flavors with love, passion, and the finest ingredients.', 'Discover Menu', 'menupage-veg.php', 'assets/images/bg/1.jpeg', 'assets/images/layer/1.png', 1, 1),
('Taste That Feels Like Home', 'Crafted with tradition, served with passion — your comfort food awaits.', 'Explore Specials', 'menupage-nonveg.php', 'assets/images/bg/2.png', 'assets/images/layer/2.png', 1, 2),
('Where Every Meal Tells a Story', 'A blend of authentic flavors & modern cooking — made fresh every day.', 'Order Now', 'menupage-nonveg.php', 'assets/images/bg/3.jpeg', 'assets/images/layer/3.png', 1, 3);
