-- ================================================
-- RESTAURANT ADMIN DASHBOARD DATABASE SCHEMA
-- ================================================
-- Run this SQL script to create all necessary tables
-- ================================================

-- 1. ADMINS TABLE (for admin authentication)
CREATE TABLE IF NOT EXISTS `admins` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `email` VARCHAR(100) NOT NULL UNIQUE,
  `password` VARCHAR(255) NOT NULL,
  `name` VARCHAR(100),
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 2. MENU ITEMS TABLE
CREATE TABLE IF NOT EXISTS `menu_items` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(150) NOT NULL,
  `category` VARCHAR(100) NOT NULL,
  `description` TEXT,
  `price` DECIMAL(10, 2) NOT NULL,
  `availability` TINYINT(1) DEFAULT 1,
  `image_url` VARCHAR(255),
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 3. RESERVATIONS TABLE
CREATE TABLE IF NOT EXISTS `reservations` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(100) NOT NULL,
  `email` VARCHAR(100),
  `phone` VARCHAR(20) NOT NULL,
  `reservation_date` DATE NOT NULL,
  `reservation_time` TIME NOT NULL,
  `number_of_guests` INT NOT NULL,
  `special_requests` TEXT,
  `status` ENUM('pending', 'approved', 'rejected', 'completed') DEFAULT 'pending',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 4. CONTACT MESSAGES TABLE
CREATE TABLE IF NOT EXISTS `contact_messages` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT,
  `name` VARCHAR(100) NOT NULL,
  `email` VARCHAR(100) NOT NULL,
  `phone` VARCHAR(20),
  `message` TEXT NOT NULL,
  `is_read` TINYINT(1) DEFAULT 0,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 5. ORDERS TABLE (for online delivery)
CREATE TABLE IF NOT EXISTS `orders` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `customer_name` VARCHAR(100) NOT NULL,
  `customer_email` VARCHAR(100),
  `customer_phone` VARCHAR(20) NOT NULL,
  `delivery_address` TEXT NOT NULL,
  `delivery_city` VARCHAR(50),
  `delivery_zip` VARCHAR(20),
  `items` JSON,
  `subtotal` DECIMAL(10, 2),
  `delivery_fee` DECIMAL(10, 2) DEFAULT 0,
  `total_amount` DECIMAL(10, 2) NOT NULL,
  `special_instructions` TEXT,
  `status` ENUM('pending', 'processing', 'completed', 'cancelled') DEFAULT 'pending',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 6. CATERING BOOKINGS TABLE (Optional)
CREATE TABLE IF NOT EXISTS `catering_bookings` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(100) NOT NULL,
  `phone` VARCHAR(20) NOT NULL,
  `event_type` VARCHAR(100),
  `event_date` DATE NOT NULL,
  `guests` INT,
  `food_preference` VARCHAR(50),
  `address` TEXT,
  `gps_coordinates` VARCHAR(100),
  `status` ENUM('pending', 'approved', 'completed') DEFAULT 'pending',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 7. USERS TABLE (Customer users)
CREATE TABLE IF NOT EXISTS `users` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `name` VARCHAR(100) NOT NULL,
  `email` VARCHAR(100) NOT NULL UNIQUE,
  `phone` VARCHAR(20),
  `password` VARCHAR(255) NOT NULL,
  `address` TEXT,
  `city` VARCHAR(50),
  `zip` VARCHAR(20),
  `avatar_url` VARCHAR(255),
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ================================================
-- INSERT SAMPLE DATA
-- ================================================

-- Sample Admin (Password: admin123 - hashed with password_hash('admin123', PASSWORD_BCRYPT))
INSERT INTO `admins` (`email`, `password`, `name`) VALUES 
('admin@restaurant.com', '$2y$10$S5I5Y8qJ9R3K9q8K8q8K8e5Z3r2H0N7M3P4Z0S8K3X5L2Q9R6W1U', 'Admin User');

-- Sample Menu Items
INSERT INTO `menu_items` (`name`, `category`, `description`, `price`, `availability`) VALUES 
('Chicken Biryani', 'Main Course', 'Fragrant rice cooked with tender chicken and aromatic spices', 250.00, 1),
('Paneer Tikka', 'Appetizers', 'Cottage cheese marinated and grilled to perfection', 180.00, 1),
('Butter Chicken', 'Main Course', 'Tender chicken in creamy tomato sauce with butter', 320.00, 1),
('Samosa', 'Appetizers', 'Crispy pastry filled with spiced potatoes', 60.00, 1),
('Gulab Jamun', 'Desserts', 'Soft milk solid dumplings in sweet sugar syrup', 100.00, 1),
('Mango Lassi', 'Beverages', 'Refreshing yogurt based mango drink', 80.00, 1),
('Naan', 'Sides', 'Soft Indian bread baked in clay oven', 40.00, 1),
('Tandoori Chicken', 'Main Course', 'Chicken marinated and cooked in tandoor', 280.00, 1);

-- Sample Reservations
INSERT INTO `reservations` (`name`, `email`, `phone`, `reservation_date`, `reservation_time`, `number_of_guests`, `status`) VALUES 
('John Doe', 'john@example.com', '1234567890', '2025-12-25', '19:00', 4, 'pending'),
('Jane Smith', 'jane@example.com', '0987654321', '2025-12-26', '20:00', 6, 'approved');

-- ================================================
-- NOTE: After running this script:
-- 1. Update the admin password with a secure one using: 
--    UPDATE admins SET password = PASSWORD_HASH('your_password', PASSWORD_BCRYPT) WHERE id = 1;
-- 2. Customize menu items according to your restaurant
-- 3. Adjust table structures as needed for your specific requirements
-- ================================================
