<?php
/**
 * ADMIN DASHBOARD CONFIGURATION FILE
 * Customize these settings for your restaurant
 */

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'bermiz_db');

// Restaurant Information
define('RESTAURANT_NAME', 'Bermiz Restaurant');
define('RESTAURANT_EMAIL', 'admin@restaurant.com');
define('RESTAURANT_PHONE', '+1-234-567-8900');
define('RESTAURANT_ADDRESS', 'Your Restaurant Address');

// Admin Settings
define('ADMIN_PANEL_TITLE', 'Restaurant Admin Dashboard');
define('SESSION_TIMEOUT', 3600); // 1 hour in seconds

// Menu Categories
$MENU_CATEGORIES = array(
    'Appetizers',
    'Main Course',
    'Desserts',
    'Beverages',
    'Sides',
    'Specials',
    'Veg Items',
    'Non-Veg Items'
);

// Reservation Settings
$RESERVATION_SETTINGS = array(
    'min_guests' => 1,
    'max_guests' => 100,
    'advance_booking_days' => 90,
    'min_booking_time' => '11:00',
    'max_booking_time' => '23:00',
    'time_interval' => 30 // minutes
);

// Delivery Settings
$DELIVERY_SETTINGS = array(
    'min_order_amount' => 150,
    'delivery_fee' => 50,
    'delivery_time_minutes' => 30,
    'cities' => array('City 1', 'City 2', 'City 3')
);

// Order Status Colors
$ORDER_STATUS_COLORS = array(
    'pending' => 'warning',
    'processing' => 'info',
    'completed' => 'success',
    'cancelled' => 'danger'
);

// Reservation Status Colors
$RESERVATION_STATUS_COLORS = array(
    'pending' => 'warning',
    'approved' => 'success',
    'rejected' => 'danger',
    'completed' => 'info'
);

// UI Settings
$UI_SETTINGS = array(
    'theme_color_primary' => '#667eea',
    'theme_color_secondary' => '#764ba2',
    'items_per_page' => 20,
    'date_format' => 'Y-m-d',
    'time_format' => 'H:i',
    'currency' => '₹'
);

// Email Settings (for notifications)
$EMAIL_SETTINGS = array(
    'smtp_host' => 'smtp.gmail.com',
    'smtp_port' => 587,
    'smtp_user' => 'your-email@gmail.com',
    'smtp_pass' => 'your-app-password',
    'from_email' => 'noreply@restaurant.com',
    'from_name' => 'Bermiz Restaurant'
);

// Security Settings
$SECURITY_SETTINGS = array(
    'password_min_length' => 8,
    'max_login_attempts' => 5,
    'lockout_time' => 900, // 15 minutes
    'enable_2fa' => false // Two-factor authentication (future)
);

// Notification Settings
$NOTIFICATION_SETTINGS = array(
    'notify_on_reservation' => true,
    'notify_on_order' => true,
    'notify_on_contact' => true,
    'send_to_admin' => true,
    'send_to_customer' => true
);

// Return all settings as associative array
return array(
    'database' => array(
        'host' => DB_HOST,
        'user' => DB_USER,
        'password' => DB_PASS,
        'name' => DB_NAME
    ),
    'restaurant' => array(
        'name' => RESTAURANT_NAME,
        'email' => RESTAURANT_EMAIL,
        'phone' => RESTAURANT_PHONE,
        'address' => RESTAURANT_ADDRESS
    ),
    'admin' => array(
        'title' => ADMIN_PANEL_TITLE,
        'session_timeout' => SESSION_TIMEOUT
    ),
    'categories' => $MENU_CATEGORIES,
    'reservations' => $RESERVATION_SETTINGS,
    'delivery' => $DELIVERY_SETTINGS,
    'colors' => array(
        'order_status' => $ORDER_STATUS_COLORS,
        'reservation_status' => $RESERVATION_STATUS_COLORS
    ),
    'ui' => $UI_SETTINGS,
    'email' => $EMAIL_SETTINGS,
    'security' => $SECURITY_SETTINGS,
    'notifications' => $NOTIFICATION_SETTINGS
);
?>
