<?php
/* ===============================
   1. SETUP & PHPMAILER
================================ */
require_once 'check_admin.php'; // Ensure admin is logged in

// Adjust paths if needed
require_once __DIR__ . '/../PHPMailer/src/PHPMailer.php'; 
require_once __DIR__ . '/../PHPMailer/src/SMTP.php';
require_once __DIR__ . '/../PHPMailer/src/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$message = "";
$error = "";

/* ===============================
   2. EMAIL FUNCTION
================================ */
function sendStatusEmail($toEmail, $toName, $status, $eventDate) {
    if (empty($toEmail)) return false; 

    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'pradeepnatarajan400@gmail.com'; 
        $mail->Password   = 'jhaz xdav sibf gufm'; 
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        $mail->setFrom('pradeepnatarajan400@gmail.com', 'Bermiz Catering');
        $mail->addAddress($toEmail, $toName);

        $mail->isHTML(true);
        $mail->Subject = "Catering Booking Update - Bermiz";

        if ($status == 'approved') {
            $mail->Body = "
                <h2>Booking Confirmed!</h2>
                <p>Dear $toName,</p>
                <p>Your catering booking for <b>$eventDate</b> has been <b>APPROVED</b>.</p>
                <p>We will contact you shortly to discuss the menu.</p>";
        } else {
            $mail->Body = "
                <h2>Booking Status Update</h2>
                <p>Dear $toName,</p>
                <p>We regret to inform you that we cannot fulfill your booking request for <b>$eventDate</b>.</p>";
        }

        $mail->send();
        return true;
    } catch (Exception $e) {
        return false;
    }
}

/* ===============================
   3. HANDLE ACTIONS (CRUD)
================================ */
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // --- APPROVE / REJECT ---
    if (isset($_POST['action']) && ($_POST['action'] == 'approve' || $_POST['action'] == 'reject')) {
        $id = intval($_POST['booking_id']);
        $new_status = ($_POST['action'] == 'approve') ? 'approved' : 'rejected';
        
        // Update DB
        $conn->query("UPDATE catering_bookings SET status='$new_status' WHERE id=$id");
        
        // Fetch details to send email
        $res = $conn->query("SELECT * FROM catering_bookings WHERE id=$id")->fetch_assoc();
        if ($res && !empty($res['email'])) {
            sendStatusEmail($res['email'], $res['name'], $new_status, $res['event_date']);
        }

        $message = "Booking marked as " . ucfirst($new_status);
    }

    // --- DELETE ---
    elseif (isset($_POST['action']) && $_POST['action'] == 'delete') {
        $id = intval($_POST['booking_id']);
        $conn->query("DELETE FROM catering_bookings WHERE id=$id");
        $message = "Booking deleted successfully.";
    }

    // --- ADD / UPDATE (Manual) ---
    elseif (isset($_POST['action']) && ($_POST['action'] == 'add' || $_POST['action'] == 'update')) {
        $name = $_POST['name'];
        $phone = $_POST['phone'];
        $email = $_POST['email']; 
        $event_type = $_POST['event_type'];
        $date = $_POST['date'];
        $guests = $_POST['guests'];
        $food = $_POST['food_pref'];
        $address = $_POST['address'];
        
        if ($_POST['action'] == 'add') {
            $stmt = $conn->prepare("INSERT INTO catering_bookings (name, phone, email, event_type, event_date, guests, food_preference, address, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'pending')");
            $stmt->bind_param("sssssisss", $name, $phone, $email, $event_type, $date, $guests, $food, $address);
            if($stmt->execute()) $message = "New catering booking added.";
            else $error = "Error adding booking.";
        } else {
            $id = $_POST['booking_id'];
            $status = $_POST['status'];
            $stmt = $conn->prepare("UPDATE catering_bookings SET name=?, phone=?, email=?, event_type=?, event_date=?, guests=?, food_preference=?, address=?, status=? WHERE id=?");
            $stmt->bind_param("sssssisssi", $name, $phone, $email, $event_type, $date, $guests, $food, $address, $status, $id);
            if($stmt->execute()) $message = "Booking updated.";
            else $error = "Error updating booking.";
        }
    }
}

// --- FETCH DATA ---
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'all';
$sql = "SELECT * FROM catering_bookings";
if ($filter != 'all') $sql .= " WHERE status = '$filter'";
$sql .= " ORDER BY event_date DESC";
$result = $conn->query($sql);
$bookings = [];
while($row = $result->fetch_assoc()) $bookings[] = $row;

// --- STATISTICS ---
$stats = [
    'total' => $conn->query("SELECT COUNT(*) as count FROM catering_bookings")->fetch_assoc()['count'],
    'pending' => $conn->query("SELECT COUNT(*) as count FROM catering_bookings WHERE status='pending'")->fetch_assoc()['count'],
    'approved' => $conn->query("SELECT COUNT(*) as count FROM catering_bookings WHERE status='approved'")->fetch_assoc()['count'],
    'rejected' => $conn->query("SELECT COUNT(*) as count FROM catering_bookings WHERE status='rejected'")->fetch_assoc()['count'],
];

// --- EDIT MODE ---
$edit_data = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $edit_data = $conn->query("SELECT * FROM catering_bookings WHERE id=$id")->fetch_assoc();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Catering Management</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/admin-style.css">
</head>
<body>

<div class="wrapper">
    <?php include 'sidebar.php'; ?>

    <div class="main-content">
        <nav class="top-nav">
            <div class="nav-left">
                <h2><i class="fas fa-utensils"></i> Catering Bookings</h2>
            </div>
            <div class="nav-right"><span>Welcome, Admin</span></div>
        </nav>

        <div class="content">
            <?php if ($message): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <?php echo $message; ?> <button class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if ($error): ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <?php echo $error; ?> <button class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="stat-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                        <div class="stat-icon mb-2"><i class="fas fa-clipboard-list fa-2x opacity-50"></i></div>
                        <h6>Total Bookings</h6>
                        <p class="count mb-0 fw-bold fs-3"><?php echo $stats['total']; ?></p>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="stat-card" style="background: linear-gradient(135deg, #f0932b 0%, #ffbe76 100%); color: white;">
                        <div class="stat-icon mb-2"><i class="fas fa-clock fa-2x opacity-50"></i></div>
                        <h6>Pending</h6>
                        <p class="count mb-0 fw-bold fs-3"><?php echo $stats['pending']; ?></p>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="stat-card" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); color: white;">
                        <div class="stat-icon mb-2"><i class="fas fa-check-circle fa-2x opacity-50"></i></div>
                        <h6>Approved</h6>
                        <p class="count mb-0 fw-bold fs-3"><?php echo $stats['approved']; ?></p>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="stat-card" style="background: linear-gradient(135deg, #ff5858 0%, #f09819 100%); color: white;">
                        <div class="stat-icon mb-2"><i class="fas fa-times-circle fa-2x opacity-50"></i></div>
                        <h6>Rejected</h6>
                        <p class="count mb-0 fw-bold fs-3"><?php echo $stats['rejected']; ?></p>
                    </div>
                </div>
            </div>

            <div class="admin-form-section mb-4">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="mb-0 text-muted"><?php echo $edit_data ? 'Edit Booking' : 'Add New Booking'; ?></h5>
                    <?php if($edit_data): ?>
                        <a href="catering_admin.php" class="btn btn-outline-secondary btn-sm">Cancel Edit</a>
                    <?php endif; ?>
                </div>
                
                <form method="POST">
                    <input type="hidden" name="action" value="<?php echo $edit_data ? 'update' : 'add'; ?>">
                    <?php if($edit_data): ?><input type="hidden" name="booking_id" value="<?php echo $edit_data['id']; ?>"><?php endif; ?>
                    
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" required value="<?php echo $edit_data['name'] ?? ''; ?>">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Phone</label>
                            <input type="text" name="phone" class="form-control" required value="<?php echo $edit_data['phone'] ?? ''; ?>">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Email (Optional)</label>
                            <input type="email" name="email" class="form-control" value="<?php echo $edit_data['email'] ?? ''; ?>">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Event Type</label>
                            <select name="event_type" class="form-select">
                                <option value="Wedding" <?php echo ($edit_data['event_type'] ?? '') == 'Wedding' ? 'selected' : ''; ?>>Wedding</option>
                                <option value="Birthday" <?php echo ($edit_data['event_type'] ?? '') == 'Birthday' ? 'selected' : ''; ?>>Birthday</option>
                                <option value="Corporate" <?php echo ($edit_data['event_type'] ?? '') == 'Corporate' ? 'selected' : ''; ?>>Corporate</option>
                                <option value="Other" <?php echo ($edit_data['event_type'] ?? '') == 'Other' ? 'selected' : ''; ?>>Other</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Date</label>
                            <input type="date" name="date" class="form-control" required value="<?php echo $edit_data['event_date'] ?? ''; ?>">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Guests</label>
                            <input type="number" name="guests" class="form-control" required value="<?php echo $edit_data['guests'] ?? ''; ?>">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Food</label>
                            <select name="food_pref" class="form-select">
                                <option value="Veg" <?php echo ($edit_data['food_preference'] ?? '') == 'Veg' ? 'selected' : ''; ?>>Veg</option>
                                <option value="Non-Veg" <?php echo ($edit_data['food_preference'] ?? '') == 'Non-Veg' ? 'selected' : ''; ?>>Non-Veg</option>
                                <option value="Mixed" <?php echo ($edit_data['food_preference'] ?? '') == 'Mixed' ? 'selected' : ''; ?>>Mixed</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Address</label>
                            <input type="text" name="address" class="form-control" required value="<?php echo $edit_data['address'] ?? ''; ?>">
                        </div>
                        <?php if($edit_data): ?>
                        <div class="col-md-3">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select">
                                <option value="pending" <?php echo $edit_data['status']=='pending'?'selected':''; ?>>Pending</option>
                                <option value="approved" <?php echo $edit_data['status']=='approved'?'selected':''; ?>>Approved</option>
                                <option value="rejected" <?php echo $edit_data['status']=='rejected'?'selected':''; ?>>Rejected</option>
                            </select>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="mt-3">
                        <button type="submit" class="btn btn-primary-custom">Save Booking</button>
                    </div>
                </form>
            </div>

            <div class="mb-3">
                <a href="?filter=all" class="btn btn-outline-secondary btn-sm <?php echo $filter=='all'?'active':''; ?>">All</a>
                <a href="?filter=pending" class="btn btn-outline-warning btn-sm <?php echo $filter=='pending'?'active':''; ?>">Pending</a>
                <a href="?filter=approved" class="btn btn-outline-success btn-sm <?php echo $filter=='approved'?'active':''; ?>">Approved</a>
            </div>

            <div class="table-responsive">
                <table class="table table-modern align-middle table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Event</th>
                            <th>Date</th>
                            <th>Guests</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($bookings as $b): ?>
                        <tr>
                            <td>#<?php echo $b['id']; ?></td>
                            <td>
                                <strong><?php echo htmlspecialchars($b['name']); ?></strong><br>
                                <small class="text-muted"><?php echo htmlspecialchars($b['phone']); ?></small>
                            </td>
                            <td><?php echo $b['event_type']; ?></td>
                            <td><?php echo date('M d, Y', strtotime($b['event_date'])); ?></td>
                            <td><span class="badge bg-info"><?php echo $b['guests']; ?></span></td>
                            <td>
                                <?php 
                                    $cls = 'bg-secondary';
                                    if($b['status']=='pending') $cls='bg-warning text-dark';
                                    if($b['status']=='approved') $cls='bg-success';
                                    if($b['status']=='rejected') $cls='bg-danger';
                                ?>
                                <span class="badge <?php echo $cls; ?>"><?php echo ucfirst($b['status']); ?></span>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <?php if($b['status']=='pending'): ?>
                                    <form method="POST" style="display:inline;">
                                        <input type="hidden" name="action" value="approve">
                                        <input type="hidden" name="booking_id" value="<?php echo $b['id']; ?>">
                                        <button class="btn btn-success btn-sm" title="Approve"><i class="fas fa-check"></i></button>
                                    </form>
                                    <form method="POST" style="display:inline;">
                                        <input type="hidden" name="action" value="reject">
                                        <input type="hidden" name="booking_id" value="<?php echo $b['id']; ?>">
                                        <button class="btn btn-warning btn-sm" title="Reject"><i class="fas fa-times"></i></button>
                                    </form>
                                    <?php endif; ?>

                                    <a href="?edit=<?php echo $b['id']; ?>" class="btn btn-info btn-sm text-white" title="Edit"><i class="fas fa-edit"></i></a>
                                    
                                    <button class="btn btn-primary btn-sm" onclick='showDetails(<?php echo json_encode($b, JSON_HEX_APOS|JSON_HEX_QUOT); ?>)' data-bs-toggle="modal" data-bs-target="#detailModal" title="View"><i class="fas fa-eye"></i></button>

                                    <form method="POST" style="display:inline;" onsubmit="return confirm('Delete?');">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="booking_id" value="<?php echo $b['id']; ?>">
                                        <button class="btn btn-danger btn-sm" title="Delete"><i class="fas fa-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="detailModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header" style="background: #931A2A; color: white;">
                <h5 class="modal-title">Booking Details</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="modalBody"></div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
<script>
function showDetails(data) {
    let emailDisplay = data.email ? `<p><strong>Email:</strong> ${data.email}</p>` : '';
    let html = `
        <p><strong>Name:</strong> ${data.name}</p>
        <p><strong>Phone:</strong> ${data.phone}</p>
        ${emailDisplay}
        <hr>
        <p><strong>Event:</strong> ${data.event_type}</p>
        <p><strong>Date:</strong> ${data.event_date}</p>
        <p><strong>Guests:</strong> ${data.guests}</p>
        <p><strong>Food:</strong> ${data.food_preference}</p>
        <hr>
        <p><strong>Address:</strong><br>${data.address}</p>
        <p><strong>GPS:</strong> ${data.gps_coordinates ? `<a href="${data.gps_coordinates}" target="_blank">View on Map</a>` : 'N/A'}</p>
    `;
    document.getElementById('modalBody').innerHTML = html;
}
</script>
</body>
</html>