# Restaurant Admin Dashboard - Architecture Overview

## 🏗️ System Architecture

```
┌─────────────────────────────────────────────────────────────────┐
│                      RESTAURANT WEBSITE                         │
│                                                                 │
│  Homepage  → Menu  → Reservations  → Contact  → Online Order   │
└────────────────────────┬────────────────────────────────────────┘
                         │ Data Submission
                         ↓
        ┌────────────────────────────────┐
        │     DATABASE (bermiz_db)        │
        ├────────────────────────────────┤
        │ • menu_items                   │
        │ • reservations                 │
        │ • contact_messages             │
        │ • orders                       │
        │ • admins                       │
        │ • users                        │
        └────────────────────────────────┘
                    ↑ │ Data Flow
                    │ ↓
        ┌─────────────────────────────────┐
        │   ADMIN DASHBOARD SYSTEM        │
        ├─────────────────────────────────┤
        │                                 │
        │  Admin Login Portal             │
        │  (admin_login.php)              │
        │           ↓                     │
        │  Session Authentication         │
        │  (check_admin.php)              │
        │           ↓                     │
        │  ┌───────────────────────┐      │
        │  │   Main Dashboard      │      │
        │  │   (index.php)         │      │
        │  └───────────────────────┘      │
        │           ↓                     │
        │  ┌─────────┬────────────┐       │
        │  │         │            │       │
        │  ↓         ↓            ↓       │
        │┌─────────────────────────────┐  │
        ││ Module 1: Menu Management   ││  │
        ││ (menu.php)                  ││  │
        ││ - Add items                 ││  │
        ││ - Edit items                ││  │
        ││ - Delete items              ││  │
        ││ - Category filtering        ││  │
        │└─────────────────────────────┘  │
        │                                 │
        │┌─────────────────────────────┐  │
        ││ Module 2: Reservations      ││  │
        ││ (reservations.php)          ││  │
        ││ - View bookings             ││  │
        ││ - Approve/Reject            ││  │
        ││ - Delete reservations       ││  │
        ││ - Status tracking           ││  │
        │└─────────────────────────────┘  │
        │                                 │
        │┌─────────────────────────────┐  │
        ││ Module 3: Contact Messages  ││  │
        ││ (contact.php)               ││  │
        ││ - View messages             ││  │
        ││ - Mark as read              ││  │
        ││ - Delete messages           ││  │
        ││ - Filter options            ││  │
        │└─────────────────────────────┘  │
        │                                 │
        │┌─────────────────────────────┐  │
        ││ Module 4: Orders            ││  │
        ││ (orders.php)                ││  │
        ││ - Track orders              ││  │
        ││ - Update status             ││  │
        ││ - View items & details      ││  │
        ││ - Revenue tracking          ││  │
        │└─────────────────────────────┘  │
        │                                 │
        └─────────────────────────────────┘
```

---

## 📊 Data Flow Diagram

```
WEBSITE OPERATIONS → DATABASE → ADMIN DASHBOARD → ACTIONS → DATABASE UPDATE
     ↓                  ↓               ↓             ↓           ↓
  Customer           Data            Admin        Operations  Information
  Actions          Storage          Access       (CRUD)       Persisted
     │                │                │             │           │
     ├─ Menu Browse  ─→ menu_items    ─→ Menu Mgmt ─→ Add/Edit → ✓
     ├─ Book Table   ─→ reservations  ─→ Reservations → Approve → ✓
     ├─ Contact Us   ─→ contact_msgs  ─→ Messages ──→ Delete ──→ ✓
     └─ Order Food   ─→ orders        ─→ Orders ─────→ Update ──→ ✓
```

---

## 🔐 Authentication Flow

```
┌────────────┐
│ Browser    │
│            │
│ Login Page │
└─────┬──────┘
      │ Enter credentials
      ↓
┌────────────────────────────┐
│ admin_login.php            │
│ • Form submission          │
│ • Validate email/password  │
│ • Bcrypt verification      │
└────────┬───────────────────┘
         │ Success
         ↓
┌────────────────────────────┐
│ Create Session             │
│ $_SESSION['admin_id']      │
│ $_SESSION['admin_email']   │
└────────┬───────────────────┘
         │ Redirect
         ↓
┌────────────────────────────┐
│ index.php (Dashboard)      │
│ check_admin.php loaded     │
│ Verify session exists      │
└────────┬───────────────────┘
         │ Session valid?
         ├─ YES ─→ Display Dashboard
         └─ NO ──→ Redirect to Login
```

---

## 🗄️ Database Schema Relationships

```
┌─────────────────┐
│     ADMINS      │
├─────────────────┤
│ id (PK)         │
│ email           │
│ password        │
│ name            │
└─────────────────┘
         │
         │ (Admin manages)
         ↓
┌──────────────────────────┐
│     MENU_ITEMS           │
├──────────────────────────┤
│ id (PK)                  │
│ name                     │
│ category                 │
│ description              │
│ price                    │
│ availability             │
└──────────────────────────┘

┌──────────────────────────┐
│    RESERVATIONS          │
├──────────────────────────┤
│ id (PK)                  │
│ name                     │
│ phone                    │
│ date                     │
│ time                     │
│ guests                   │
│ status                   │
└──────────────────────────┘

┌──────────────────────────┐
│   CONTACT_MESSAGES       │
├──────────────────────────┤
│ id (PK)                  │
│ name                     │
│ email                    │
│ phone                    │
│ message                  │
│ is_read                  │
└──────────────────────────┘

┌──────────────────────────┐
│      ORDERS              │
├──────────────────────────┤
│ id (PK)                  │
│ customer_name            │
│ customer_phone           │
│ delivery_address         │
│ items (JSON)             │
│ total_amount             │
│ status                   │
└──────────────────────────┘
```

---

## 🔄 CRUD Operations Flow

```
CREATE (Add)
├─ User fills form
├─ Submit button clicked
├─ POST request sent
├─ Validate input
├─ INSERT INTO database
└─ Display success message

READ (View)
├─ Page loads
├─ Query database
├─ Fetch records
├─ Apply filters
├─ Display in table
└─ Show statistics

UPDATE (Edit)
├─ User selects item
├─ Opens edit form
├─ Modifies data
├─ Submit changes
├─ UPDATE database
└─ Refresh display

DELETE (Remove)
├─ User requests deletion
├─ Show confirmation
├─ User confirms
├─ DELETE from database
└─ Remove from table
```

---

## 🎯 Module Interactions

```
DASHBOARD (index.php)
    ↓
    ├─→ MENU (menu.php)
    │   ├─ Add → menu_items INSERT
    │   ├─ Edit → menu_items UPDATE
    │   ├─ Delete → menu_items DELETE
    │   └─ View → menu_items SELECT
    │
    ├─→ RESERVATIONS (reservations.php)
    │   ├─ Approve → UPDATE status='approved'
    │   ├─ Reject → UPDATE status='rejected'
    │   ├─ Delete → DELETE reservation
    │   └─ View → SELECT reservations
    │
    ├─→ CONTACT (contact.php)
    │   ├─ Mark Read → UPDATE is_read=1
    │   ├─ Delete → DELETE message
    │   └─ View → SELECT messages
    │
    └─→ ORDERS (orders.php)
        ├─ Update Status → UPDATE status
        ├─ Delete → DELETE order
        └─ View → SELECT orders
```

---

## 🖥️ UI Layer Structure

```
┌─────────────────────────────────────────────────┐
│            ADMIN DASHBOARD UI                   │
├─────────────────────────────────────────────────┤
│                                                 │
│  ┌─────────────────────────────────────────┐   │
│  │  TOP NAVIGATION BAR                     │   │
│  │  • Admin name                           │   │
│  │  • Logout button                        │   │
│  └─────────────────────────────────────────┘   │
│         │                               │       │
│         ↓                               ↓       │
│  ┌──────────────┐             ┌──────────────┐ │
│  │   SIDEBAR    │             │   CONTENT    │ │
│  │              │             │   AREA       │ │
│  │ • Dashboard  │             │              │ │
│  │ • Menu       │             │ • Table      │ │
│  │ • Reserv.   │             │ • Forms      │ │
│  │ • Contact   │             │ • Modals     │ │
│  │ • Orders    │             │ • Stats      │ │
│  │ • Logout    │             │ • Buttons    │ │
│  │              │             │              │ │
│  └──────────────┘             └──────────────┘ │
│                                                 │
└─────────────────────────────────────────────────┘
```

---

## 📱 Responsive Breakpoints

```
DESKTOP (1024px+)
├─ Sidebar visible (fixed)
├─ Full width content
├─ All columns visible
└─ Normal font sizes

TABLET (768px - 1023px)
├─ Sidebar visible but narrower
├─ Optimized layout
├─ Some columns hidden
└─ Adjusted spacing

MOBILE (Below 768px)
├─ Sidebar collapsed
├─ Stack layout
├─ Minimal columns
└─ Touch-friendly buttons
```

---

## 🔐 Security Layers

```
Layer 1: Authentication
├─ Email/password validation
├─ Bcrypt password hashing
└─ Session creation

Layer 2: Authorization
├─ Session check via check_admin.php
├─ Redirect unauthorized users
└─ Protected pages only

Layer 3: Data Protection
├─ Prepared statements (prevent SQL injection)
├─ Input validation
├─ HTML escaping (prevent XSS)
└─ Secure headers

Layer 4: Session Management
├─ Session timeout
├─ Secure cookies
├─ Logout functionality
└─ Session destruction
```

---

## 🌐 Integration Points

```
WEBSITE FORMS
├─ Reservation Form → Inserts into reservations table
├─ Contact Form → Inserts into contact_messages table
├─ Order Checkout → Inserts into orders table
└─ Menu Display → Reads from menu_items table

ADMIN DASHBOARD
├─ Displays data from all tables
├─ Updates data in all tables
├─ Processes user actions
└─ Validates all operations

REAL-TIME SYNC
├─ Website displays current menu
├─ Website shows order status
├─ Customers see reservation status
└─ All changes reflected instantly
```

---

## 📈 Statistics Flow

```
Dashboard loads
    ↓
Query each table
    ├─ COUNT(*) FROM menu_items
    ├─ COUNT(*) FROM reservations WHERE status='pending'
    ├─ COUNT(*) FROM contact_messages
    └─ COUNT(*) FROM orders WHERE status='pending'
    ↓
Fetch totals
    ├─ Total menus
    ├─ Pending reservations
    ├─ Total messages
    └─ Pending orders
    ↓
Display statistics
    ├─ Show card numbers
    ├─ Color code by status
    ├─ Display trending
    └─ Update on refresh
```

---

## 🔄 Complete User Journey

```
1. ADMIN LOGIN
   ├─ Navigate to admin_login.php
   ├─ Enter credentials
   └─ Session created

2. VIEW DASHBOARD
   ├─ See statistics
   ├─ View quick links
   └─ Review system status

3. MANAGE MENU
   ├─ View all items
   ├─ Add new items
   ├─ Edit items
   └─ Delete items

4. HANDLE RESERVATIONS
   ├─ See pending reservations
   ├─ Approve/reject
   └─ Track status

5. PROCESS CONTACT
   ├─ View messages
   ├─ Mark as read
   └─ Follow up

6. TRACK ORDERS
   ├─ See new orders
   ├─ Update status
   └─ Track delivery

7. LOGOUT
   ├─ Session destroyed
   ├─ Redirect to login
   └─ End session
```

---

## 📊 Performance Considerations

```
Optimization
├─ Indexes on frequently queried columns
├─ Prepared statements (faster execution)
├─ CSS minification ready
├─ JavaScript loaded at bottom
├─ Bootstrap CDN for caching
├─ Responsive images
└─ Lazy loading ready

Scalability
├─ Database normalized
├─ Connection pooling ready
├─ Modular code structure
├─ Easy to add new modules
├─ Can handle thousands of records
└─ Performance monitoring ready
```

---

## 🎨 Design System

```
Colors
├─ Primary: #667eea (Purple)
├─ Secondary: #764ba2 (Dark Purple)
├─ Success: #4caf50 (Green)
├─ Danger: #f44336 (Red)
├─ Warning: #ff9800 (Orange)
└─ Info: #2196f3 (Blue)

Typography
├─ Font: Segoe UI, Tahoma, Geneva
├─ Headers: 600 weight, 24-28px
├─ Body: 400 weight, 14px
└─ Small: 400 weight, 12px

Spacing
├─ Padding: 15-30px
├─ Margin: 10-40px
├─ Border Radius: 5-10px
└─ Box Shadow: Subtle to prominent

Icons
├─ Font Awesome 6.0
├─ 20-40px sizes
└─ Color matched to status
```

---

**Architecture Version:** 1.0
**Last Updated:** December 18, 2025
**Status:** Production Ready ✅

