# System Architecture & Data Flow Diagrams

## 🏗️ Complete System Architecture

```
┌─────────────────────────────────────────────────────────────────┐
│                        RESTAURANT E-COMMERCE SYSTEM             │
└─────────────────────────────────────────────────────────────────┘

                            ┌──────────────────┐
                            │   CUSTOMERS      │
                            │   (Browsers)     │
                            └────────┬─────────┘
                                     │
                ┌────────────────────┼────────────────────┐
                │                    │                    │
         ┌──────▼────────┐  ┌────────▼────────┐  ┌───────▼────────┐
         │   BROWSE      │  │   SHOPPING      │  │    CHECKOUT    │
         │   MENU        │  │    CART         │  │      FORM      │
         │               │  │                 │  │                │
         │online-delivery│  │ cart-view.php   │  │checkout-page.php
         │   .php        │  │                 │  │                │
         └──────┬────────┘  └────────┬────────┘  └───────┬────────┘
                │                    │                    │
                └────────────────────┼────────────────────┘
                                     │
                                     ▼
                        ┌─────────────────────────┐
                        │   CART ACTIONS API      │
                        │  (Backend Handler)      │
                        │   cart-actions.php      │
                        │                         │
                        │ • Add to cart           │
                        │ • Update quantity       │
                        │ • Remove items          │
                        │ • Fetch cart            │
                        └────────────┬────────────┘
                                     │
                  ┌──────────────────┴──────────────────┐
                  │                                     │
         ┌────────▼────────┐              ┌─────────────▼──────┐
         │  SESSION DATA   │              │  DATABASE STORAGE  │
         │                 │              │                    │
         │ $_SESSION[      │              │  cart table        │
         │  'cart'         │              │  • product_name    │
         │ ]               │              │  • product_price   │
         │                 │              │  • quantity        │
         │ • user_id       │              │  • user_id         │
         │ • cart items    │              │  • session_id      │
         │ • timestamps    │              │                    │
         └─────────────────┘              └────────────────────┘
                  │
                  │ (Real-time updates)
                  │
                  └──────────────────┬──────────────────┐
                                     │                  │
                        ┌────────────▼──────────┐       │
                        │   LOCALSTORAGE        │       │
                        │   (Bridge Layer)      │       │
                        │                       │       │
                        │ Cart Data (JSON)      │       │
                        │ Temporary Storage     │       │
                        └────────────┬──────────┘       │
                                     │                  │
                                     ▼                  │
                        ┌─────────────────────┐       │
                        │  ORDER HANDLER API  │       │
                        │                     │       │
                        │ order-handler.php   │       │
                        │                     │       │
                        │ • create_order      │       │
                        │ • fetch_orders      │       │
                        │ • update_status     │       │
                        └────────────┬────────┘       │
                                     │                │
                  ┌──────────────────┴───────────────┬┴──────────┐
                  │                                  │           │
         ┌────────▼────────┐          ┌──────────────▼──┐   (Persist)
         │  ORDERS TABLE   │          │ ORDER_ITEMS     │       │
         │                 │          │ TABLE           │       │
         │ • order_id      │          │                 │       │
         │ • user_id       │          │ • order_id      │       │
         │ • user_name     │          │ • product_name  │       │
         │ • total_amount  │          │ • quantity      │       │
         │ • order_status  │          │ • item_total    │       │
         │ • created_at    │          │                 │       │
         └────────┬────────┘          └──────────────────┘       │
                  │                                               │
                  │ (Admin Queries)                               │
                  │                                               │
         ┌────────▼────────┐                                      │
         │   ADMIN PANEL   │                                      │
         │                 │                                      │
         │ admin/          │◄─────────────────────────────────────┘
         │ orders.php      │  (Clear cart after order)
         │                 │
         │ • View orders   │
         │ • Search filter │
         │ • Update status │
         │ • View details  │
         └─────────────────┘
```

---

## 🔄 Data Flow Sequence Diagrams

### 1️⃣ Add to Cart Flow

```
Customer                  Frontend                Backend              Database
   │                         │                       │                    │
   │─ Click "Add to Cart" ──►│                       │                    │
   │                         │                       │                    │
   │                         │─ Validate ────────────┤                    │
   │                         │                       │                    │
   │                         │                       │─ Check Duplicate ──►│
   │                         │                       │                    │
   │                         │                       │◄─ Return Result ───│
   │                         │                       │                    │
   │                         │                       │─ INSERT/UPDATE ───►│
   │                         │                       │                    │
   │                         │                       │◄─ Success ─────────│
   │                         │                       │                    │
   │                         │◄─ Return CartCount ───│                    │
   │                         │                       │                    │
   │◄─ Update Cart Icon ─────│                       │                    │
   │                         │                       │                    │
   │─ Show Success Alert ───►│                       │                    │
   │                         │                       │                    │

Response JSON:
{
  "status": "success",
  "cartCount": 3
}
```

### 2️⃣ Checkout Flow

```
Customer              Checkout Page              Backend              Database
   │                      │                         │                    │
   │─ Fill Form ──────────►│                         │                    │
   │                       │                         │                    │
   │─ Click "Place Order" ►│                         │                    │
   │                       │                         │                    │
   │                       │─ Validate All Fields    │                    │
   │                       │                         │                    │
   │                       │─ Load Cart from LS ────┤                    │
   │                       │                         │                    │
   │                       │─ Calculate Totals      │                    │
   │                       │                         │                    │
   │                       │─ Send Order Data ──────►│                    │
   │                       │                         │                    │
   │                       │                         │─ Validate Data ──┐│
   │                       │                         │                  ││
   │                       │                         │─ INSERT Order ──►│
   │                       │                         │                  ││
   │                       │                         │─ INSERT Items ──►│
   │                       │                         │                  ││
   │                       │                         │─ DELETE Cart ───►│
   │                       │                         │                  ││
   │                       │◄─ Return order_id ─────┤◄─ Success ───────┘│
   │                       │                         │                    │
   │◄─ Clear LocalStorage ─│                         │                    │
   │                       │                         │                    │
   │◄─ Redirect to Home ───│                         │                    │
   │                       │                         │                    │

Request Body:
action=create_order&order_data={
  "user_name": "John",
  "user_phone": "9876543210",
  "delivery_address": "123 Main St",
  "payment_method": "UPI",
  "order_items": [...],
  "subtotal": 500,
  "total_amount": 555
}

Response:
{
  "status": "success",
  "order_id": "ORD20241224234512345"
}
```

### 3️⃣ Admin Order Management Flow

```
Admin                  Admin Panel              Backend              Database
  │                        │                       │                    │
  │─ Login ────────────────►│                       │                    │
  │                         │                       │                    │
  │─ Navigate to Orders ───►│                       │                    │
  │                         │                       │                    │
  │                         │─ Query All Orders ───►│                    │
  │                         │                       │─ SELECT * ────────►│
  │                         │                       │◄─ Return Orders ──│
  │                         │◄─ Return Results ─────│                    │
  │                         │                       │                    │
  │◄─ Display Table ────────│                       │                    │
  │                         │                       │                    │
  │─ Search/Filter ────────►│                       │                    │
  │                         │─ Filter Results       │                    │
  │◄─ Update Display ───────│                       │                    │
  │                         │                       │                    │
  │─ Click "View Details" ►│                       │                    │
  │                         │─ Fetch Order ────────►│                    │
  │                         │                       │─ SELECT with Items►│
  │                         │                       │◄─ Return Data ────│
  │                         │◄─ Return Details ─────│                    │
  │◄─ Show Modal Dialog ────│                       │                    │
  │                         │                       │                    │
  │─ Click "Update Status" ►│                       │                    │
  │                         │─ Select New Status    │                    │
  │─ Confirm Update ───────►│                       │                    │
  │                         │─ Send Update ────────►│                    │
  │                         │                       │─ UPDATE order ────►│
  │                         │                       │                    │
  │                         │◄─ Success Response ───│◄─ Confirm Update ─│
  │◄─ Show Success Alert ───│                       │                    │
  │                         │─ Refresh List ──────┐ │                    │
  │                         │                     ▼                      │
  │◄─ Updated Display ──────│                       │                    │
  │                         │                       │                    │

Response:
{
  "status": "success",
  "message": "Order status updated"
}
```

---

## 📊 Database Relationship Diagram

```
┌──────────────────────┐
│       USERS          │
├──────────────────────┤
│ id (PK)              │◄──────┐
│ name                 │       │
│ email                │       │
│ password             │       │
│ phone                │       │
│ created_at           │       │
└──────────────────────┘       │
         ▲                      │
         │                      │
         │                      │
    1    │                   N  │
    ┌────┴─────┐         ┌──────┴──────┐
    │    │     │         │     │       │
┌───┴────▼──┐┌─┴────────┐└───┬─┘┌────┬┘┌──────┐
│   CART    ││  ORDERS  │    │  │    │ │      │
├───────────┤├──────────┤    │  │    │ │      │
│id         ││id        │    │  │    │ │      │
│user_id(FK)││order_id  │    │  │    │ │      │
│product_..││user_id(FK)├────┼──┼────┘ │      │
│quantity  ││user_name ││    │  │      │      │
│product_..││total_amt ││    │  │      │      │
└───────────┘│status    │    │  │      │      │
             │created_at││    │  │      │      │
             └──┬───┬───┘    │  │      │      │
                │   │        │  │      │      │
           1    │   └────────┼──┼──────┘  ORDER_ITEMS
                │            │  │       ├──────────┤
              N │            │ N│       │id        │
        ┌───────┴───────┐    │  │       │order_id..│
        │   ORDER_ITEMS │    │  │       │product...│
        ├───────────────┤    │  │       │quantity  │
        │id             │◄───┴──┤       │item_total│
        │order_id(FK)───┼────────┘       └──────────┘
        │product_name   │
        │product_price  │
        │quantity       │
        │item_total     │
        └───────────────┘

Legend:
PK = Primary Key
FK = Foreign Key
1:N = One to Many Relationship
```

---

## 🔐 Authentication & Authorization Flow

```
┌─────────────────────────────────────────────────────┐
│            ACCESS CONTROL FLOWCHART                 │
└─────────────────────────────────────────────────────┘

                    User Request
                         │
                         ▼
                 ┌──────────────────┐
                 │ Session Exists?  │
                 └────┬─────────┬───┘
                      │         │
                    No│         │Yes
                      │         │
              ┌───────▼┐   ┌────▼──────────┐
              │Redirect│   │ Check User ID │
              │to Login│   └────┬──────┬───┘
              └────────┘        │      │
                           Valid│      │Invalid
                                │      │
                        ┌───────▼┐  ┌─▼────────┐
                        │Allow   │  │Deny      │
                        │Access  │  │Access    │
                        └────────┘  └──────────┘

┌─────────────────────────────────────────────────────┐
│         ADMIN FUNCTIONS ACCESS                      │
└─────────────────────────────────────────────────────┘

              Admin Request
                    │
                    ▼
           ┌────────────────────┐
           │Admin Session Exists?│
           └────┬─────────┬──────┘
                │         │
              No│         │Yes
                │         │
        ┌───────▼┐   ┌────▼──────────┐
        │Redirect│   │Check Admin ID │
        │to Admin│   └────┬──────┬───┘
        │ Login  │        │      │
        └────────┘    Valid│      │Invalid
                           │      │
                   ┌───────▼┐  ┌─▼────────┐
                   │Execute │  │Deny      │
                   │Command │  │Access    │
                   └────────┘  └──────────┘

Protected Operations:
├─ create_order
├─ fetch_user_orders
├─ fetch_order_details
└─ update_order_status (Admin only)
```

---

## 📱 Page Structure Diagram

```
┌─────────────────────────────────────────────────────────┐
│             ONLINE DELIVERY PAGE                        │
├─────────────────────────────────────────────────────────┤
│  Header: Logo, Cart Icon (with count), User Menu        │
├─────────────────────────────────────────────────────────┤
│  Main Content:                                          │
│  ├─ Menu Categories (Grid)                            │
│  │  ├─ Biryanis (3-4 items)                          │
│  │  ├─ Curries (3-4 items)                           │
│  │  ├─ Breads (3-4 items)                            │
│  │  └─ Desserts (3-4 items)                          │
│  │                                                     │
│  └─ Each Item Card:                                    │
│     ├─ Image                                           │
│     ├─ Name                                            │
│     ├─ Price                                           │
│     ├─ Rating (optional)                              │
│     └─ "Add to Cart" Button ──────┐                   │
│                                    │                   │
│                                    ▼                   │
│                            ┌──────────────────┐       │
│                            │ Show Success     │       │
│                            │ Alert            │       │
│                            │ Update Cart Count│       │
│                            └──────────────────┘       │
├─────────────────────────────────────────────────────────┤
│  Footer: Links, Contact, Social                        │
└─────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────┐
│                CART VIEW PAGE                           │
├─────────────────────────────────────────────────────────┤
│  Header: Logo, Cart Icon, User Menu                    │
├─────────────────────────────────────────────────────────┤
│  Main Content (2-Column Layout):                       │
│  ┌─────────────────────────┬──────────────────────┐   │
│  │ Cart Items (Left)       │ Order Summary (Right)│   │
│  │                         │                      │   │
│  │ Table:                  │ ├─ Subtotal          │   │
│  │ ├─ Image                │ ├─ Delivery Charge   │   │
│  │ ├─ Name                 │ ├─ Taxes             │   │
│  │ ├─ Price                │ ├─ Discount          │   │
│  │ ├─ Quantity (+/- btn)   │ └─ Total             │   │
│  │ ├─ Total                │                      │   │
│  │ └─ Remove (trash icon)  │ [ Proceed Button ]  │   │
│  │                         │                      │   │
│  │ (Apply CRUD operations) │                      │   │
│  └─────────────────────────┴──────────────────────┘   │
├─────────────────────────────────────────────────────────┤
│  Footer                                                 │
└─────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────┐
│               CHECKOUT PAGE                             │
├─────────────────────────────────────────────────────────┤
│  Header: Logo, Minimal UI                              │
├─────────────────────────────────────────────────────────┤
│  Main Content (2-Column Layout):                       │
│  ┌─────────────────────────┬──────────────────────┐   │
│  │ Checkout Form (Left)    │ Order Summary (Right)│   │
│  │                         │ (Sticky Sidebar)     │   │
│  │ ├─ Customer Details     │                      │   │
│  │ │  ├─ Full Name         │ Order Items:         │   │
│  │ │  ├─ Phone             │ ├─ Item 1 (₹xxx)    │   │
│  │ │  └─ Email             │ ├─ Item 2 (₹xxx)    │   │
│  │ │                       │ └─ Item 3 (₹xxx)    │   │
│  │ ├─ Delivery Address     │                      │   │
│  │ │  ├─ Street            │ ├─ Subtotal         │   │
│  │ │  ├─ City              │ ├─ Delivery         │   │
│  │ │  ├─ State             │ ├─ Taxes            │   │
│  │ │  └─ Postal Code       │ ├─ Discount         │   │
│  │ │                       │ └─ Total            │   │
│  │ ├─ Special Instructions │                      │   │
│  │ │                       │ [Place Order Button] │   │
│  │ ├─ Payment Method       │                      │   │
│  │ │  ├─ Radio: UPI        │                      │   │
│  │ │  ├─ Radio: Card       │                      │   │
│  │ │  └─ Radio: COD        │                      │   │
│  │ │                       │                      │   │
│  │ └─ Terms & Conditions   │                      │   │
│  │    Checkbox             │                      │   │
│  │                         │                      │   │
│  │ [Place Order Button]    │                      │   │
│  └─────────────────────────┴──────────────────────┘   │
├─────────────────────────────────────────────────────────┤
│  Footer                                                 │
└─────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────┐
│            ADMIN ORDERS PAGE                            │
├─────────────────────────────────────────────────────────┤
│  Header: Admin Panel Logo, Logout                       │
├─────────────────────────────────────────────────────────┤
│  Main Content:                                          │
│  ├─ Search Box: [Search by Order ID/Name/Phone]       │
│  ├─ Filter Buttons:                                    │
│  │  ├─ All Orders (default)                           │
│  │  ├─ Pending                                         │
│  │  ├─ Confirmed                                       │
│  │  ├─ Preparing                                       │
│  │  ├─ Out for Delivery                               │
│  │  ├─ Delivered                                       │
│  │  └─ Cancelled                                       │
│  │                                                     │
│  └─ Orders Table:                                      │
│     ├─ Order ID          (sortable)                    │
│     ├─ Customer          (searchable)                  │
│     ├─ Phone             (searchable)                  │
│     ├─ Total             (sortable)                    │
│     ├─ Status            (badge, filterable)          │
│     │  ├─ 🟡 Pending                                   │
│     │  ├─ 🔵 Confirmed                                │
│     │  ├─ 🟣 Preparing                                │
│     │  ├─ 🟢 Out for Delivery                         │
│     │  ├─ ✅ Delivered                                │
│     │  └─ ❌ Cancelled                                │
│     ├─ Date              (sortable)                    │
│     └─ Actions           (buttons)                     │
│        ├─ View (modal)   ──────┐                      │
│        └─ Update (modal) ──────┤                      │
│                                 ▼                      │
│                    ┌──────────────────────┐           │
│                    │  Modal Dialogs:      │           │
│                    │  ├─ Order Details    │           │
│                    │  └─ Update Status    │           │
│                    └──────────────────────┘           │
├─────────────────────────────────────────────────────────┤
│  Footer                                                 │
└─────────────────────────────────────────────────────────┘
```

---

## 🌐 Payment Methods Selection

```
Payment Method Selection Form
┌─────────────────────────────────────────┐
│ Choose Payment Method:                  │
├─────────────────────────────────────────┤
│                                         │
│  ⭕ UPI (Recommended)                   │
│     ├─ Google Pay                       │
│     ├─ PhonePe                          │
│     └─ Paytm                            │
│                                         │
│  ⭕ Credit/Debit Card                   │
│     ├─ Visa                             │
│     ├─ Mastercard                       │
│     └─ RuPay                            │
│                                         │
│  ⭕ Net Banking                         │
│     ├─ HDFC Bank                        │
│     ├─ ICICI Bank                       │
│     ├─ Axis Bank                        │
│     ├─ SBI                              │
│     └─ Others                           │
│                                         │
│  ⭕ Digital Wallet                      │
│     ├─ Paytm Wallet                     │
│     ├─ Amazon Pay                       │
│     └─ MobiKwik                         │
│                                         │
│  ⭕ Cash on Delivery (COD)              │
│     Pay when order arrives              │
│                                         │
└─────────────────────────────────────────┘
```

---

## 📈 Order Status Progression

```
Order Lifecycle Timeline:

Placed            Confirmed         Preparing        Out for Delivery    Delivered
  │                  │                  │                   │              │
  ▼                  ▼                  ▼                   ▼              ▼
[🟡Pending]────────[🔵Confirmed]────[🟣Preparing]──[🟢Out for Delivery]──[✅Delivered]
  │
  └─ (Optional) ──────────────────────────────────────────────────────────────────►[❌Cancelled]

Each status update:
1. Admin clicks "Update"
2. Select new status from dropdown
3. Confirm the change
4. System updates database
5. Admin sees updated status immediately
```

---

## 🔗 API Endpoints Structure

```
┌─────────────────────────────────────────┐
│        ORDER HANDLER API ROUTES         │
│       (POST /order-handler.php)         │
└─────────────────────────────────────────┘

├── Authentication
│   └─ Requires Session (user_id or admin_id)
│
├── CUSTOMER ENDPOINTS
│   │
│   ├─ action=create_order
│   │  ├─ Method: POST
│   │  ├─ Auth: Customer (user_id required)
│   │  ├─ Input: order_data JSON
│   │  └─ Response: {order_id}
│   │
│   ├─ action=fetch_user_orders
│   │  ├─ Method: POST
│   │  ├─ Auth: Customer (user_id required)
│   │  ├─ Input: None
│   │  └─ Response: {orders[]}
│   │
│   └─ action=fetch_order_details
│      ├─ Method: POST
│      ├─ Auth: Customer (user_id required)
│      ├─ Input: order_id
│      └─ Response: {order, items[]}
│
├── ADMIN ENDPOINTS
│   │
│   └─ action=update_order_status
│      ├─ Method: POST
│      ├─ Auth: Admin (admin_id required)
│      ├─ Input: order_id, status
│      └─ Response: {success/error}
│
└── Response Format: JSON
   {
     "status": "success" | "error",
     "message": "Description",
     "data": {...} (optional)
   }
```

---

**Diagram Version**: 2.0  
**Last Updated**: December 24, 2025  
**Status**: Complete ✅
