# Analytics Dashboard - Visual Reference

## 📐 Page Layout (After Enhancement)

```
┌─────────────────────────────────────────────────────────────────┐
│ Mektron - Data Analytics Dashboard            [☰ Menu]         │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  CONTROLS SECTION                                              │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │ [Select Field ▼] [Select Machine ▼]                    │   │
│  │ [Compare F1 ▼] [Compare F2 ▼] [Compare] [Load All]    │   │
│  │ [Date-Wise Report] [Refresh]                           │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
│  STATS CARDS (3 columns)                                       │
│  ┌──────────────┐ ┌──────────────┐ ┌──────────────┐           │
│  │ Total Records│ │ Employees    │ │ Data Points  │           │
│  │    5,234     │ │     45       │ │    120      │           │
│  └──────────────┘ └──────────────┘ └──────────────┘           │
│                                                                 │
│  CHARTS SECTION (2 columns)                                    │
│  ┌───────────────────────────┐ ┌──────────────────┐           │
│  │ 30-Day Production Trend   │ │ Field Distribution│          │
│  │ (Bar Chart)               │ │ (Pie Chart)      │           │
│  │ [Chart Area]              │ │ [Chart Area]     │           │
│  │                           │ │                  │           │
│  └───────────────────────────┘ └──────────────────┘           │
│                                                                 │
│  DETAILS SECTION                                               │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │ Top Employees Table                                     │   │
│  │ Employee ID │ Name        │ Records                     │   │
│  │ EMP001      │ John Smith  │ 245                         │   │
│  │ EMP002      │ Jane Doe    │ 198                         │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
│  ✨ NEW SECTIONS BELOW ✨                                       │
│                                                                 │
│  📅 DATE-WISE STATISTICS REPORT (New Section)                 │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │ [Start Date ▼] [End Date ▼] [Filter Report]           │   │
│  │                                                         │   │
│  │ 📊 Daily Activity Heatmap                              │   │
│  │ [Dual-axis chart: Records vs Employees]               │   │
│  │                                                         │   │
│  │ Date Table (6 columns):                                │   │
│  │ Date │ Day │ Total │ Emps │ Avg │ Peak Hour          │   │
│  │ ...  │ ... │  ...  │ ...  │ ... │ ...                │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
│  📊 ENHANCED FIELD COMPARISON (New Section)                    │
│  ┌──────────────────────┬──────────────────────┐              │
│  │ 🟦 Field 1           │ 🟪 Field 2           │              │
│  │ M/C No               │ Status               │              │
│  │ ━━━━━━━━━━━━━━━━    │ ━━━━━━━━━━━━━━━━    │              │
│  │ 45 Unique Values     │ 3 Unique Values     │              │
│  │ • 2,340 total        │ • 156 total         │              │
│  │ • 156 max freq       │ • 45 max freq       │              │
│  └──────────────────────┴──────────────────────┘              │
│                                                                 │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │ [Bar] [Radar] [Pie]  ← Chart Type Buttons              │   │
│  │                                                         │   │
│  │ Comparative Distribution Chart:                        │   │
│  │ ┌───────────────────────────────────────────────────┐  │   │
│  │ │  ┏━━━━━┓          ┏━━━━━┓                        │  │   │
│  │ │  ┃ A  ┃   ┏━━━┓   ┃ X  ┃                        │  │   │
│  │ │  ┗━━━━━┛   ┃250┃   ┗━━━━━┛                        │  │   │
│  │ │         ┃━━┃                                    │  │   │
│  │ │            ┗━━━┛                                    │  │   │
│  │ └───────────────────────────────────────────────────┘  │   │
│  │                                                         │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │ Statistical Comparison Table                           │   │
│  │ Metric    │ F1  │ F2 │ Diff │ % Chg │ Winner          │   │
│  │ Unique    │ 45  │  3 │ +42  │+1400% │ 🟦 Field 1     │   │
│  │ Records   │2340 │156 │+2184 │+1400% │ 🟦 Field 1     │   │
│  │ Max Freq  │156  │ 45 │ +111 │ +246% │ 🟦 Field 1     │   │
│  │ Avg Freq  │52.0 │52.0│  0   │  0%   │ ⚖️ Equal        │   │
│  │ Diversity │1.9% │1.9%│  0   │  0%   │ ⚖️ Equal        │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

---

## 🎨 Color Scheme

### Primary Colors
```
Teal (Active/Primary):      #1abc9c  ░░░░░
Blue (Field 1/Data):        #667eea  ░░░░░
Pink (Field 2/Compare):     #f093fb  ░░░░░
Dark Teal (Sidebar):        #013B3B  ░░░░░
Light Gray (Background):    #f4f6f9  ░░░░░
```

### Accent Colors
```
Green (Success/Increase):   #43e97b  ░░░░░
Red (Decrease/Alert):       #f5576c  ░░░░░
Orange (Warning):           #fa709a  ░░░░░
Cyan (Data):                #00f2fe  ░░░░░
```

### Status Colors
```
🟦 Blue Box - Field 1 Winner
🟪 Pink Box - Field 2 Winner
⚖️ Balance - Equal
✓ Green - Good
✗ Red - Alert
```

---

## 📊 Chart Type Comparisons

### 1. Bar Chart (Default)
```
    Legend: ░ Field 1  ░ Field 2
    
    Frequency
    400 │     
    350 │         ┌─────┐
    300 │         │     │     ┌─────┐
    250 │         │     │     │     │
    200 │     ┌───┤     │ ┌───┤     │
    150 │     │   │     │ │   │     │
    100 │ ┌───┤   │ ┌───┤ ┤   │ ┌───┤
     50 │ │   │   │ │   │ │   │ │   │
      0 └─┴───┴───┴─┴───┴─┴───┴─┴───┴─
        A   B   C   X   Y   Z   Q   R
        
        Field 1: A=156, B=134, C=98...
        Field 2: X=45, Y=38, Z=32...
```

### 2. Radar Chart
```
         ╱─────────────╲
        ╱               ╲
       ╱   ▢▢▢▢▢▢▢▢▢▢▢  ╲    ──── Field 1 (Blue)
      │   Field 1 Area   │   ──── Field 2 (Pink)
      │   ▪▪▪▪▪▪▪▪▪     │
      │                   │
      │      Field 2      │
       ╲   ▪▪▪▪▪▪▪▪▪     ╱
        ╲   ▢▢▢▢▢▢▢▢▢▢▢  ╱
         ╲─────────────╱
         
    6 points: A, B, C, D, E, F
    Inner/Outer shows dominance
```

### 3. Pie Chart
```
         ╱─────────────╲
        ╱  ░░░░░░░░░░░  ╲
       │ Field 1: 60%   │
       │   Blue Slice   │
       │                 │
       │   ▓▓▓▓▓▓▓▓▓    │
        ╲  Field 2: 40% ╱
         ╲  Pink Slice ╱
          ╲───────────╱
          
    Shows: Parts of whole
    Good for: Understanding proportions
```

---

## 📋 Data Flow Visualization

### Date-Wise Report Flow
```
                    ┌─────────────────┐
                    │ Analytics Page  │
                    │  Loads (30 days)│
                    └────────┬────────┘
                             │
                    ┌────────▼────────┐
                    │ Date Pickers:   │
                    │ Start: -30 days │
                    │ End: Today      │
                    └────────┬────────┘
                             │
                    ┌────────▼────────────────┐
                    │ User clicks:            │
                    │ "Load Date-Wise Report" │
                    └────────┬────────────────┘
                             │
                    ┌────────▼──────────────────────────────┐
                    │ API Request:                          │
                    │ /api.php?action=                      │
                    │ get_date_wise_statistics&             │
                    │ start_date=2026-01-01&                │
                    │ end_date=2026-01-30                   │
                    └────────┬──────────────────────────────┘
                             │
                    ┌────────▼──────────────────────────────┐
                    │ Database Query:                       │
                    │ SELECT log_date, COUNT(*),           │
                    │ COUNT(DISTINCT emp_id),              │
                    │ MAX(HOUR(log_time))                  │
                    │ FROM production_logs                 │
                    │ WHERE log_date >= ? AND <= ?         │
                    │ GROUP BY log_date                    │
                    └────────┬──────────────────────────────┘
                             │
                    ┌────────▼───────────────────────┐
                    │ API Response:                  │
                    │ {                             │
                    │   "data": [                   │
                    │     {                         │
                    │       "log_date": "2026-01-30",
                    │       "total_records": 312,   │
                    │       "employee_count": 12,   │
                    │       "peak_hour": 14         │
                    │     }                         │
                    │   ]                           │
                    │ }                             │
                    └────────┬───────────────────────┘
                             │
            ┌────────────────┼────────────────┐
            │                │                │
    ┌───────▼────────┐  ┌────▼─────────┐  ┌─▼────────────┐
    │ Build Table    │  │ Build Heatmap│  │ Display Both │
    │ with 6 columns │  │ Dual Axis    │  │  Show Section│
    │                │  │ Chart        │  │              │
    └────────────────┘  └──────────────┘  └─┬────────────┘
                                             │
                        ┌────────────────────▼──┐
                        │ User Analyzes Data:    │
                        │ • Identify busy days   │
                        │ • Check staffing       │
                        │ • Plan schedules       │
                        │ • Optimize resources   │
                        └───────────────────────┘
```

### Field Comparison Flow
```
┌──────────────────────────┐
│ Analytics Dashboard      │
│                          │
│ [Select Field 1 ▼]      │
│ [Select Field 2 ▼]      │
│ [Compare Fields]        │
└──────────┬───────────────┘
           │
    ┌──────▼──────────────────────────┐
    │ Parallel API Calls:             │
    │ ┌────────────────┐              │
    │ │ Field 1 Stats  │ → Query DB  │
    │ └────────────────┘              │
    │ ┌────────────────┐              │
    │ │ Field 2 Stats  │ → Query DB  │
    │ └────────────────┘              │
    └──────┬──────────────────────────┘
           │
    ┌──────▼─────────────────────────────┐
    │ Receive Both Responses:            │
    │ Field1: {data: [...], total: 2340} │
    │ Field2: {data: [...], total: 156}  │
    └──────┬─────────────────────────────┘
           │
    ┌──────▼──────────────────────────┐
    │ Store in Global Object:         │
    │ window.comparisonChartData = {  │
    │   data1, data2, label1, label2  │
    │ }                               │
    └──────┬──────────────────────────┘
           │
    ┌──────▼────────────────────────────┐
    │ Render Initial Chart (Bar):       │
    │ buildEnhancedBarComparison()      │
    └──────┬────────────────────────────┘
           │
    ┌──────▼────────────────────────────┐
    │ Build Statistics Table:           │
    │ buildEnhancedComparisonStats()    │
    └──────┬────────────────────────────┘
           │
    ┌──────▼────────────────────────────┐
    │ Display Results:                  │
    │ • Insight Cards (top)            │
    │ • Chart (middle)                 │
    │ • Statistics Table (bottom)      │
    └──────┬────────────────────────────┘
           │
    ┌──────▼──────────────────────────────┐
    │ User Can Switch Charts:            │
    │ [Bar] [Radar] [Pie]               │
    │                                    │
    │ Each click:                        │
    │ • Update button states            │
    │ • Destroy old chart               │
    │ • Create new chart                │
    │ • Display instantly               │
    └────────────────────────────────────┘
```

---

## 🎯 User Interface Elements

### Button States
```
Active Button (Teal):
┌─────────────────┐
│ [Bar ▼]         │  ← Teal background, white text
└─────────────────┘     Indicates current selection

Inactive Button (Gray):
┌─────────────────┐
│ [Radar ▼]       │  ← Light gray background, dark text
└─────────────────┘     Can be clicked to switch
```

### Input Fields
```
Date Input (Calendar):
┌──────────────────────┐
│ Start Date: 2026-01-01│ ← Click to open calendar
└──────────────────────┘

Dropdown Select:
┌─────────────────────────┐
│ Field 1: [M/C No ▼]    │ ← Click to show options
│ • M/C No               │
│ • Status               │
│ • Operator             │
└─────────────────────────┘
```

### Insight Cards
```
┌──────────────────────────────────────┐
│ 🟦 Field 1 Insights                  │
│ ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━  │
│ Unique Values                        │
│ 45                                   │
│                                      │
│ • 2,340 total records               │
│ • 156 max frequency                 │
└──────────────────────────────────────┘

┌──────────────────────────────────────┐
│ 🟪 Field 2 Insights                  │
│ ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━  │
│ Unique Values                        │
│ 3                                    │
│                                      │
│ • 156 total records                 │
│ • 45 max frequency                  │
└──────────────────────────────────────┘
```

### Statistics Table Rows
```
Metric: Unique Values
┌─────────────────────────────────────────────┐
│ Unique Values │ 45 │ 3 │ +42 │ +1400% │ 🟦 │
│               │    │   │     │        │    │
│ Value display │ F1 │ F2│ Diff│ Percent│Winn│
└─────────────────────────────────────────────┘

Color Coding:
Difference = Green if Field1 > Field2
           = Red if Field2 > Field1
```

---

## 📱 Responsive Layout

### Desktop (1024px+)
```
┌─────────────────────────────────────┐
│         Controls (Full Width)        │
├─────────────────────────────────────┤
│  Card 1   │  Card 2   │  Card 3    │
├─────────────────────────────────────┤
│      Chart 1      │      Chart 2    │
├─────────────────────────────────────┤
│         Details Table (Full Width)   │
└─────────────────────────────────────┘
```

### Tablet (768px - 1024px)
```
┌────────────────────────┐
│  Controls (Full Width) │
├────────────────────────┤
│ Card1 │ Card2 │ Card3 │
├────────────────────────┤
│      Chart 1           │
│      Chart 2           │
├────────────────────────┤
│  Details Table         │
└────────────────────────┘
```

### Mobile (<768px)
```
┌──────────────┐
│  Controls    │
├──────────────┤
│ Card1        │
│ Card2        │
│ Card3        │
├──────────────┤
│ Chart 1      │
├──────────────┤
│ Chart 2      │
├──────────────┤
│  Table       │
│  (scroll)    │
└──────────────┘
```

---

## 🔄 State Transitions

### Date Filter State
```
Initial: [Dates Set] → Ready
         ↓
User Action: Click "Filter Report"
         ↓
Loading: [Spinner] → Fetching...
         ↓
Rendering: [Building Charts] → Preparing...
         ↓
Complete: [Display Results] → Show tables & charts
         ↓
User Action: Change dates
         ↓
(Return to "Ready" state)
```

### Comparison Chart State
```
Initial: Chart Type = Bar (Default)
         ↓
User clicks: [Radar]
         ↓
Action: switchComparisonVisualization('radar')
         ↓
Button Update: Bar=inactive, Radar=active
         ↓
Chart Destroy: Destroy bar chart
         ↓
Chart Create: Create radar chart
         ↓
Complete: Display radar chart
         ↓
(Ready for next chart type switch)
```

---

## 📊 Summary

**Total Sections:** 7
- Dashboard stats (always visible)
- Production chart (always visible)
- Field distribution (always visible)
- Top employees (always visible)
- **NEW** Date-wise report (on demand)
- Machine data (on demand)
- **NEW** Enhanced comparison (on demand)

**Total Chart Types:** 5
- Bar (production trend)
- Pie (field distribution)
- Bar (date heatmap - dual axis)
- Bar/Radar/Pie (comparison - switchable)

**Total Visualizations:** 7+ interactive charts

**Total Tables:** 5
- Top employees
- Field distribution
- Machine statistics
- Employee-machine mapping
- **NEW** Date-wise statistics
- **NEW** Comparison statistics

