# Dynamic Tool Stroke Update - Testing Guide

## ✅ System Overview

The tool stroke management system has been fully automated to:
1. **Automatically track tool strokes** when production entries are made
2. **Update in real-time** on the maintenance dashboard (every 3 seconds)
3. **Reduce remaining strokes** dynamically based on quantities produced
4. **Show visual feedback** when data changes

## 🔧 How It Works

### 1. Production Entry + Tool Stroke Update
When an employee enters production data in **Daily Production Entry**:
- Selects a **Tool** from the dropdown
- Enters **Produced Qty** amount
- Submits the form

The system:
- Saves the production entry
- **Automatically increases** the tool's stroke counter by the produced quantity
- Triggers the maintenance page to refresh

### 2. Real-Time Data Refresh
The **Maintenance Dashboard** under "**Tool Management & Production Summary**":
- Refreshes **every 3 seconds** (even with the page open)
- Shows updated values for:
  - **Strokes Used** (increases as production happens)
  - **Remaining** (decreases as strokes are used)
  - **Usage %** (increases with each production entry)
  - **Status** (changes from GOOD → CRITICAL → EXPIRED)

### 3. Visual Feedback
When tool data changes:
- Affected cells highlight in **yellow** for 1 second
- Status badges **animate** to draw attention
- Numbers are **formatted with commas** for readability

## 🧪 Testing Steps

### Test 1: Quick Stroke Update
1. Open **Maintenance Dashboard** (Tools > Maintenance or sidebar)
2. In another tab, open **Daily Production Entry**
3. Fill the form:
   - **Date**: Today
   - **Employee**: Select any employee
   - **Tool**: Select "g3" (or any tool)
   - **Plan Qty**: 100
   - **Produced Qty**: 50
   - **Accepted Qty**: 45
4. Click **"Save Entry to Log"**
5. Watch the **Maintenance tab** - you should see:
   - **g3 Strokes Used** increases by 50
   - **g3 Remaining** decreases by 50
   - **g3 Usage %** updates
   - Fields highlight in yellow

### Test 2: Continuous Production
1. Enter multiple production entries with same tool
2. Watch the maintenance dashboard update after each entry
3. Verify cumulative increases (e.g., if you add 50, then 30, tool usage should be 80)

### Test 3: Status Changes
1. Keep adding production until **Remaining < 1,000**
2. Status should change to **CRITICAL** (yellow)
3. Keep adding until **Remaining ≤ 0**
4. Status should change to **EXPIRED** (red)

### Test 4: Manual Refresh
1. Click **"Refresh Now"** button on maintenance page
2. Data should update immediately

### Test 5: Auto-Refresh Verification
1. Keep maintenance page open without clicking anything
2. In another tab, add 3-4 production entries
3. Watch maintenance page update automatically
4. Should see updates without manual action

## 🐛 Troubleshooting

### Fields Not Updating?
**Check the browser console** (F12 → Console tab):
```
✅ Tool ID captured: 123
✓ Produced Qty captured: 50
=== FORM DATA BEING SENT ===
```

If you see these messages, the form is working correctly.

### Maintenance Page Not Showing Updates?
1. Hard refresh the page (Ctrl+F5)
2. Check that auto-refresh is running (console shows "Auto-refresh started")
3. Verify you're on the **VIEW: all** or **VIEW: tool** section

### Tool Data Not Found?
The system uses the **field_options** table to store tool data.
Check the database:
```sql
SELECT id, label, current_usage, life_limit FROM field_options WHERE field_id = X;
```

Where X is the Tool field ID from custom_fields table.

## 📊 Database Schema

Tool data is stored in **field_options** table:
- `id` - Tool ID
- `label` - Tool name (g3, r4, T1, etc.)
- `current_usage` - Current stroke count (increases with production)
- `life_limit` - Maximum strokes before replacement
- `field_id` - Links to Tool field in custom_fields table

## 🚀 Production Deployment Checklist

- [x] Tool stroke auto-update on production entry
- [x] Real-time dashboard refresh (3-second interval)
- [x] Visual feedback on value changes
- [x] localStorage trigger for immediate updates
- [x] Better error logging in api.php
- [x] Field name variation handling
- [x] Mobile-responsive layout
- [x] Visibility change detection (pause when tab hidden)

## 📝 System Logs

Check the PHP error log to debug:
```
tail -f /var/log/php-errors.log
```

Look for messages like:
```
✅ TOOL STROKE UPDATE START: Tool ID = 123, Qty to Add = 50
✅ Tool found: g3
✅ Tool stroke updated SUCCESSFULLY
```

## 🔄 Auto-Refresh Behavior

| Status | Behavior |
|--------|----------|
| **Page Visible** | Refreshes every 3 seconds |
| **Tab Hidden** | Stops refreshing (saves resources) |
| **Production Entry Saved** | Immediate refresh via localStorage |
| **Manual Refresh Button** | Instant update |

## ✨ Key Features

✅ **Real-Time Updates** - No page reload needed  
✅ **Automatic Stroke Reduction** - Happens when production is entered  
✅ **Visual Feedback** - Highlight changes for clarity  
✅ **Resource Efficient** - Pauses when tab is hidden  
✅ **Responsive Design** - Works on mobile devices  
✅ **Error Handling** - Detailed logging for debugging  

---

**Last Updated**: February 12, 2026  
**Version**: 1.0 - Production Ready
