# 🎨 Analytics System - Complete Architecture Diagram

## 📊 System Architecture Overview

```
╔════════════════════════════════════════════════════════════════════════╗
║                    MEKTRON ERP - ANALYTICS ECOSYSTEM                   ║
╚════════════════════════════════════════════════════════════════════════╝

┌─────────────────────────────────────────────────────────────────────────┐
│                           USER INTERFACE LAYER                          │
├─────────────────────────────────────────────────────────────────────────┤
│                                                                         │
│  ┌──────────────────┐  ┌──────────────────┐  ┌──────────────────┐     │
│  │  analytics.php   │  │analytics_adv.php │  │ view_log.php     │     │
│  │                  │  │                  │  │ (analytics btn)  │     │
│  │ • Basic Stats    │  │ • Hierarchical   │  │ • Quick Stats    │     │
│  │ • Field Distrib  │  │ • Personalized   │  │ • Field Analysis │     │
│  │ • Machines       │  │ • Dependent Flds │  │ • Toggle button  │     │
│  │ • Employees      │  │ • Multi-field    │  │                  │     │
│  │ • 30-day trends  │  │ • Employee Track │  │                  │     │
│  └──────────────────┘  └──────────────────┘  └──────────────────┘     │
│                                                                         │
└─────────────────────────────────────────────────────────────────────────┘
              ▲                    ▲                    ▲
              │                    │                    │
              │ HTTP Requests      │ HTTP Requests      │ HTTP Requests
              │                    │                    │
┌─────────────────────────────────────────────────────────────────────────┐
│                            API LAYER (api.php)                          │
├─────────────────────────────────────────────────────────────────────────┤
│                                                                         │
│  BASIC ENDPOINTS               ADVANCED ENDPOINTS (NEW)                │
│  ├─ get_field_statistics       ├─ get_all_fields                      │
│  ├─ get_analytics_fields       ├─ get_dependent_fields                │
│  ├─ get_employee_machine_...   ├─ get_machine_specific_stats          │
│  ├─ get_machine_tool_list      └─ get_machine_summary                 │
│  └─ get_analytics_dashboard                                            │
│                                                                         │
│  All endpoints:                                                         │
│  • Require login (session check)                                       │
│  • Use parameterized queries                                           │
│  • Return JSON responses                                               │
│  • Include error handling                                              │
│                                                                         │
└─────────────────────────────────────────────────────────────────────────┘
              ▲                    ▲
              │ SQL Queries        │ SQL Queries
              │                    │
┌─────────────────────────────────────────────────────────────────────────┐
│                        DATABASE LAYER (MySQL)                           │
├─────────────────────────────────────────────────────────────────────────┤
│                                                                         │
│  production_logs (Main Data)                                            │
│  ├─ id, log_date, emp_id, operator_name                               │
│  ├─ f_machine_no [custom field]                                        │
│  ├─ f_plan_qty [custom field]                                          │
│  ├─ f_produced_qty [custom field]                                      │
│  ├─ f_accepted_qty [custom field]                                      │
│  ├─ f_nc_qty [custom field]                                            │
│  ├─ f_production_type [custom field]                                   │
│  ├─ f_quality_status [custom field]                                    │
│  └─ ... (other custom fields)                                          │
│                                                                         │
│  custom_fields (Metadata)                                               │
│  ├─ id, field_name, field_label, field_type                           │
│  ├─ parent_field_id ⭐ [enables hierarchy]                             │
│  ├─ display_order, is_active                                          │
│  └─ ... other metadata                                                 │
│                                                                         │
│  employees (Reference Data)                                             │
│  ├─ emp_unique_id, name, designation, status                          │
│  └─ ... other fields                                                   │
│                                                                         │
└─────────────────────────────────────────────────────────────────────────┘
```

---

## 🔄 Data Flow - Advanced Analytics

```
USER OPENS analytics_advanced.php
│
├─→ Page Load Event
│   ├─ API: get_all_fields
│   │  └─ Populates "Select Machine Field" dropdown
│   │     Shows all parent fields (Machine No, Equipment, etc.)
│   │
│   └─ Display: Step 1 dropdown ready
│
├─→ USER SELECTS MACHINE FIELD (e.g., "Machine No")
│   ├─ onChange Event triggered
│   ├─ API: get_dependent_fields (parent_field_id=5)
│   │  └─ Returns: Production Type, Quality Status, etc.
│   ├─ API: get_machine_summary (machine_field=f_machine_no)
│   │  └─ Returns: All machines with operations, employees, days
│   │
│   └─ Display: Machine dropdown + Field selector cards appear
│
├─→ USER SELECTS MACHINE (e.g., "CNC-01")
│   ├─ onChange Event triggered
│   ├─ API: get_machine_summary (machine_field=f_machine_no)
│   │  └─ Returns: Detailed stats for CNC-01
│   │     • total_operations: 245
│   │     • employee_count: 12
│   │     • working_days: 42
│   ├─ API: get_machine_specific_stats
│   │  Parameters:
│   │  • machine_field=f_machine_no
│   │  • machine_value=CNC-01
│   │  • dependent_field=emp_id
│   │  └─ Returns: Employees working on CNC-01
│   │
│   └─ Display: Stat cards + Employee table appears
│
├─→ USER CHECKS DEPENDENT FIELDS (e.g., Production Type)
│   ├─ Click Event on field card
│   ├─ Toggle checkbox state
│   ├─ Card styling changes
│   ├─ API: get_machine_specific_stats
│   │  Parameters:
│   │  • machine_field=f_machine_no
│   │  • machine_value=CNC-01
│   │  • dependent_field=f_production_type
│   │  └─ Returns:
│   │     data: [{value: "Type1", count: 45}, ...]
│   │     total_records: 245
│   │     employee_count: 12
│   ├─ Build Chart (Bar chart of distribution)
│   ├─ Build Table (Counts + percentages)
│   │
│   └─ Display: Field analysis card appears
│
└─→ USER CHECKS MORE FIELDS
    └─ Same process repeats for each field
        Chart 2, Chart 3, etc. appear below Chart 1
```

---

## 🎯 Analytics Hierarchy Structure

```
┌─────────────────────────────────────────────────────────────────┐
│              FIELD HIERARCHY IN DATABASE                       │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│ LEVEL 1 - Parent Fields (parent_field_id = NULL)               │
│ ┌─────────────────────────────────────────────────────┐         │
│ │ • Machine No (f_machine_no)          [ID: 5]        │         │
│ │ • Employee ID (f_employee_id)        [ID: 8]        │         │
│ │ • Production Type (f_prod_type)      [ID: 12]       │         │
│ └─────────────────────────────────────────────────────┘         │
│                          │                                      │
│                          ├─ These are PRIMARY selectors        │
│                          └─ Used in Step 1 & 2                 │
│                                                                 │
│ LEVEL 2 - Dependent Fields (parent_field_id = 5 or 8 or 12)   │
│ ┌─────────────────────────────────────────────────────┐         │
│ │ Children of Machine No (parent_id=5):              │         │
│ │ • Quality Status (f_quality)         [parent: 5]   │         │
│ │ • Production Stage (f_stage)         [parent: 5]   │         │
│ │ • Operator Shift (f_shift)           [parent: 5]   │         │
│ │                                                     │         │
│ │ Children of Employee ID (parent_id=8):             │         │
│ │ • Shift Assignment (f_emp_shift)     [parent: 8]   │         │
│ │ • Department (f_department)          [parent: 8]   │         │
│ │                                                     │         │
│ │ Children of Production Type (parent_id=12):        │         │
│ │ • Variant (f_variant)                [parent: 12]  │         │
│ │ • Color (f_color)                    [parent: 12]  │         │
│ └─────────────────────────────────────────────────────┘         │
│                          │                                      │
│                          ├─ Auto-populated based on parent      │
│                          └─ User selects to analyze             │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

---

## 📊 Quantity Fields Structure

```
┌──────────────────────────────────────────────────────────┐
│        QUANTITY ANALYSIS FIELD HIERARCHY                 │
├──────────────────────────────────────────────────────────┤
│                                                          │
│ PARENT: Machine No (f_machine_no)                        │
│ ┌────────────────────────────────────────────────────┐   │
│ │ Purpose: Primary selector                         │   │
│ │ Data Type: Dropdown/Select                        │   │
│ │ Values: CNC-01, Lathe-02, Drill-03, etc.         │   │
│ │ Parent ID: NULL (it's a parent)                  │   │
│ └────────────────────────────────────────────────────┘   │
│                                                          │
│ DEPENDENT QUANTITY FIELDS (all have parent_id=machine) │
│                                                          │
│ 1️⃣ PLAN QTY (f_plan_qty)                                │
│    ├─ Data Type: Number                                │
│    ├─ Meaning: What was planned                        │
│    ├─ Example: 50 units                                │
│    └─ Chart: Bar chart of quantity distribution        │
│                                                          │
│ 2️⃣ PRODUCED QTY (f_produced_qty)                        │
│    ├─ Data Type: Number                                │
│    ├─ Meaning: What was actually made                  │
│    ├─ Example: 48 units                                │
│    └─ Chart: Compare vs Plan Qty                       │
│                                                          │
│ 3️⃣ ACCEPTED QTY (f_accepted_qty)                        │
│    ├─ Data Type: Number                                │
│    ├─ Meaning: What passed quality check               │
│    ├─ Example: 47 units                                │
│    └─ Chart: Quality acceptance rate                   │
│                                                          │
│ 4️⃣ NC QTY (f_nc_qty)                                    │
│    ├─ Data Type: Number                                │
│    ├─ Meaning: Non-conforming (defects)                │
│    ├─ Example: 1 unit                                  │
│    └─ Chart: Defect rate analysis                      │
│                                                          │
└──────────────────────────────────────────────────────────┘

Relationships:
    Produced Qty = Plan Qty - variances
    Accepted Qty = Produced Qty - quality issues
    NC Qty = Produced Qty - Accepted Qty
    Quality % = (Accepted / Produced) × 100
    Defect % = (NC / Produced) × 100
```

---

## 🔗 Advanced Analytics - Complete Flow Diagram

```
┌─────────────────────────────────────────────────────────────┐
│  USER INTERFACE: analytics_advanced.php                    │
└─────────────────────────────────────────────────────────────┘
                         │
                         ▼
        ┌────────────────────────────────────┐
        │ PAGE INITIALIZATION                 │
        │ loadMachineFields()                │
        │ Fetch: get_all_fields              │
        └────────────────────────────────────┘
                         │
                         ▼
        ┌────────────────────────────────────┐
        │ DISPLAY: Machine Field Dropdown    │
        │ (All parent fields shown)          │
        └────────────────────────────────────┘
                         │
              ┌──────────┴──────────┐
              │                     │
              ▼                     ▼
    ┌──────────────────┐  ┌──────────────────┐
    │ User Selects     │  │ BACKEND: API     │
    │ Machine Field    │  │ get_all_fields   │
    │                  │  │ (parent only)    │
    └──────────────────┘  └──────────────────┘
              │
              ▼
    ┌──────────────────────────────┐
    │ ON CHANGE: loadMachines()    │
    │ • Fetch: get_dependent_...   │
    │ • Fetch: get_machine_...     │
    └──────────────────────────────┘
              │
        ┌─────┴─────┐
        ▼           ▼
    DISPLAY:    DISPLAY:
    • Machine   • Dependent
      dropdown    field cards
              │
              ▼
    ┌──────────────────────────────┐
    │ User Selects Machine (CNC-01)│
    └──────────────────────────────┘
              │
              ▼
    ┌──────────────────────────────┐
    │ ON CHANGE:                   │
    │ loadMachineStats()           │
    │ • get_machine_summary        │
    │ • Populate stat cards        │
    │ • Load employees             │
    └──────────────────────────────┘
              │
        ┌─────┴─────┐
        ▼           ▼
    DISPLAY:    DISPLAY:
    • Stat      • Employee
      cards       table
              │
              ▼
    ┌──────────────────────────────┐
    │ User Selects Field to Analyze│
    │ (e.g., Production Type)      │
    └──────────────────────────────┘
              │
              ▼
    ┌──────────────────────────────┐
    │ ON CLICK:                    │
    │ toggleFieldSelection()       │
    │ toggleFieldSelection()       │
    │ loadFieldAnalysis()          │
    │ • get_machine_specific_stats │
    └──────────────────────────────┘
              │
              ▼
    ┌──────────────────────────────┐
    │ BUILD: Chart + Table         │
    │ • buildFieldAnalysisCard()   │
    │ • buildFieldChart()          │
    └──────────────────────────────┘
              │
              ▼
    ┌──────────────────────────────┐
    │ DISPLAY:                     │
    │ • Bar Chart (distribution)   │
    │ • Data Table (counts, %)     │
    │ • Progress bars              │
    └──────────────────────────────┘
```

---

## 🎨 Component Relationships

```
┌────────────────────────────────────────────────────┐
│         ADVANCED ANALYTICS COMPONENTS              │
├────────────────────────────────────────────────────┤
│                                                    │
│ ┌──────────────────────────────────────────────┐   │
│ │ HIERARCHY SECTION                            │   │
│ │ ├─ Machine Field Selector                   │   │
│ │ ├─ Machine Value Selector                   │   │
│ │ ├─ Quick Stats Display                      │   │
│ │ └─ Dependent Field Cards                    │   │
│ └──────────────────────────────────────────────┘   │
│                                                    │
│ ┌──────────────────────────────────────────────┐   │
│ │ STATISTICS SECTION                           │   │
│ │ ├─ Stat Cards (4 metrics)                   │   │
│ │ │  ├─ Total Operations                      │   │
│ │ │  ├─ Employees                             │   │
│ │ │  ├─ Working Days                          │   │
│ │ │  └─ Average/Day                           │   │
│ │ └─ Machine Name Display                     │   │
│ └──────────────────────────────────────────────┘   │
│                                                    │
│ ┌──────────────────────────────────────────────┐   │
│ │ ANALYSIS SECTION (per field selected)        │   │
│ │ ├─ Chart Container                          │   │
│ │ │  ├─ Bar Chart (top 10 values)            │   │
│ │ │  └─ Chart.js instance                     │   │
│ │ ├─ Table Container                          │   │
│ │ │  ├─ Value | Count | %                     │   │
│ │ │  ├─ Progress bars                         │   │
│ │ │  └─ Formatted percentages                 │   │
│ │ └─ (Multiple copies if fields selected)    │   │
│ └──────────────────────────────────────────────┘   │
│                                                    │
│ ┌──────────────────────────────────────────────┐   │
│ │ EMPLOYEES SECTION                            │   │
│ │ ├─ Table Header                             │   │
│ │ ├─ Employee List                            │   │
│ │ │  ├─ ID | Name | Operations | %            │   │
│ │ │  └─ Badges for emphasis                   │   │
│ │ └─ Sorted by operation count                │   │
│ └──────────────────────────────────────────────┘   │
│                                                    │
└────────────────────────────────────────────────────┘
```

---

## 💾 Data Persistence Flow

```
USER DATA ENTRY
    │
    ▼ (entry.php)
┌───────────────────────────────────────┐
│ production_logs table                 │
│ ├─ log_date: 2026-01-23              │
│ ├─ emp_id: EMP001                    │
│ ├─ operator_name: John Doe           │
│ ├─ f_machine_no: CNC-01              │
│ ├─ f_plan_qty: 50                    │
│ ├─ f_produced_qty: 48                │
│ ├─ f_accepted_qty: 47                │
│ ├─ f_nc_qty: 1                       │
│ ├─ f_production_type: Standard       │
│ └─ f_quality_status: Accepted        │
└───────────────────────────────────────┘
    │
    ├─→ ANALYTICS QUERIES
    │   └─ SELECT ... FROM production_logs
    │      WHERE f_machine_no='CNC-01'
    │      GROUP BY f_production_type
    │
    └─→ RESULTS DISPLAYED
        └─ Charts, tables, statistics
```

---

## 🚀 Request/Response Cycle

```
┌─────────────────────────────────────────────────────────┐
│  analytics_advanced.php (Frontend)                      │
│  • User selects machine field                           │
│  • JavaScript executes: loadMachines()                  │
└─────────────────────────────────────────────────────────┘
                         │
                         │ HTTP GET Request
                         │ /api.php?action=get_dependent_fields
                         │         &parent_field_id=5
                         │
                         ▼
┌─────────────────────────────────────────────────────────┐
│  api.php (Backend)                                      │
│  • Validate session                                     │
│  • Prepare SQL:                                         │
│    SELECT * FROM custom_fields                         │
│    WHERE parent_field_id = 5                           │
│    AND is_active = 1                                    │
│  • Execute query                                        │
│  • Fetch results: [                                     │
│      {id: 6, field_name: f_quality, ...},             │
│      {id: 7, field_name: f_stage, ...}                │
│    ]                                                    │
│  • Echo JSON response                                   │
└─────────────────────────────────────────────────────────┘
                         │
                         │ JSON Response
                         │ {success: true, dependent_fields: [...]}
                         │
                         ▼
┌─────────────────────────────────────────────────────────┐
│  analytics_advanced.php (Frontend)                      │
│  • Parse JSON response                                  │
│  • JavaScript: buildDependentFieldSelectors()          │
│  • Create field selector cards                         │
│  • Append to DOM                                        │
│  • User sees field options                             │
└─────────────────────────────────────────────────────────┘
```

---

## 📈 Complete System Topology

```
                            USERS
                        ┌───┴───┬──────┐
                        │       │      │
                        ▼       ▼      ▼
                    ┌────────────────────────┐
                    │   MEKTRON ERP SYSTEM   │
                    └─┬──────┬───────────┬─┬─┘
                      │      │           │ │
            ┌─────────┼──────┼───────────┼─┼─────────┐
            │         │      │           │ │         │
            ▼         ▼      ▼           ▼ ▼         ▼
        [Entry]  [Reports]  [Admin]  [Search] [Analytics] ← New!
            │         │      │           │ │         │
            │         │      │           │ │         │
            │         │      │           │ │  ┌──────┴───┬─────────┐
            │         │      │           │ │  │          │         │
            ▼         ▼      ▼           ▼ ▼  ▼          ▼         ▼
        ┌─────────────────────────────────────────────────────────────┐
        │              SHARED API LAYER (api.php)                    │
        │                                                             │
        │  • Session management   • Field management                 │
        │  • Employee management  • Log entry management             │
        │  • Basic analytics      • Advanced analytics (NEW)         │
        │                                                             │
        └────┬─────────────────────────────────────────────────┬────┘
             │                                                 │
             ▼                                                 ▼
        ┌──────────────────────────────────┐  ┌──────────────────────┐
        │    MySQL Database                │  │  Session Storage     │
        │  ┌──────────────────────────────┐│  │  $_SESSION superglow │
        │  │ Tables:                      ││  └──────────────────────┘
        │  │ • users                      ││
        │  │ • employees                  ││
        │  │ • production_logs (main data)││
        │  │ • custom_fields (metadata)   ││
        │  │ • field_options              ││
        │  │ • system_settings            ││
        │  └──────────────────────────────┘│
        └──────────────────────────────────┘
```

---

**This architecture provides a scalable, maintainable, enterprise-grade analytics system!** 🎉
