# 📊 Quantity & Field Analysis - Setup & Usage Guide

## 🎯 Overview

The system now supports analyzing **quantity-based fields** (Plan Qty, Produced Qty, Accepted Qty, NC Qty) with personalized statistics for each machine.

---

## 📋 Setting Up Quantity Fields

### In Admin → Manage Fields:

#### 1. **Create Parent Field: "Machine No"** (if not exists)
```
Label: Machine No
Type: Select
Parent: (leave empty)
Active: ✓ Yes
```

#### 2. **Create Quantity Fields as Dependent**

**Plan Qty**
```
Label: Plan Qty
Type: Number
Parent: Machine No ← Select this
Active: ✓ Yes
```

**Produced Qty**
```
Label: Produced Qty
Type: Number
Parent: Machine No ← Select this
Active: ✓ Yes
```

**Accepted Qty**
```
Label: Accepted Qty
Type: Number
Parent: Machine No ← Select this
Active: ✓ Yes
```

**NC Qty**
```
Label: NC Qty
Type: Number
Parent: Machine No ← Select this
Active: ✓ Yes
```

---

## 🚀 How to Use

### Step 1: Access Advanced Analytics
```
Sidebar → ANALYTICS → Advanced Analytics
OR
View Reports → Click [Advanced] button
```

### Step 2: Select Machine Field
1. Click "Select Machine Field" dropdown
2. Choose "Machine No"
3. System loads dependent quantity fields

### Step 3: Choose Machine
1. Click "Select Specific Machine"
2. Choose machine (e.g., "CNC-01")
3. View machine statistics

### Step 4: Analyze Quantities
1. Check boxes for quantity fields:
   - ☑ Plan Qty
   - ☑ Produced Qty
   - ☑ Accepted Qty
   - ☑ NC Qty

2. System shows 4 separate charts/tables

### Step 5: Review Results

For each quantity field, you'll see:

#### Machine: CNC-01
```
Total Operations: 245
Employees: 12
Working Days: 42
Avg/Day: 5.8
```

#### Plan Qty Analysis
```
Chart: Bar chart showing frequency of each quantity value
- 10 units: 45 times (18.4%)
- 20 units: 78 times (31.8%)
- 30 units: 52 times (21.2%)
- 40 units: 35 times (14.3%)
- 50 units: 35 times (14.3%)

Total: 245 records for CNC-01
```

#### Produced Qty Analysis
```
Chart: Shows what was actually produced
- 10 units: 42 times
- 19 units: 45 times (slightly less)
- 29 units: 48 times (slightly less)
- 38 units: 38 times
- 48 units: 32 times (less than planned)
```

#### Accepted Qty Analysis
```
Chart: Shows what passed quality
- 9 units: 18 times (from 10 planned)
- 18 units: 38 times (from 19 produced)
- 28 units: 42 times (from 29 produced)
...
Shows quality acceptance rate
```

#### NC Qty Analysis
```
Chart: Non-conforming quantity
- 0 units: 78 times (no issues)
- 1 unit: 42 times (1 defective)
- 2 units: 18 times (2 defective)
- 3 units: 7 times (3 defective)

Shows defect distribution per batch
```

---

## 📊 Analysis Example: CNC-01 Machine

```
┌─────────────────────────────────────────────────────────┐
│ Machine: CNC-01                                         │
├─────────────────────────────────────────────────────────┤
│ Statistics: 245 operations | 12 employees | 42 days   │
│ Average: 5.8 operations/day                            │
└─────────────────────────────────────────────────────────┘

PLAN QTY Distribution
┌─────────────────────────────────────────┐
│ 50 units ████ 35 ops (14.3%)            │
│ 40 units ███ 35 ops (14.3%)             │
│ 30 units ██████ 52 ops (21.2%)          │
│ 20 units ████████ 78 ops (31.8%)        │
│ 10 units █████ 45 ops (18.4%)           │
└─────────────────────────────────────────┘

PRODUCED QTY Distribution
┌─────────────────────────────────────────┐
│ 48 units ███ 32 ops (13.1%)             │
│ 38 units ████ 38 ops (15.5%)            │
│ 29 units ██████ 48 ops (19.6%)          │
│ 19 units ███████ 45 ops (18.4%)         │
│ 10 units ████ 42 ops (17.1%)            │
│ Other    ██ 40 ops (16.3%)              │
└─────────────────────────────────────────┘

ACCEPTED QTY Distribution  [Quality Check]
┌─────────────────────────────────────────┐
│ 48 units ██ 30 ops (12.2%)   [95%]     │
│ 38 units ███ 36 ops (14.7%)  [94.7%]   │
│ 29 units ███ 46 ops (18.8%)  [95.8%]   │
│ 19 units ████ 42 ops (17.1%) [93.3%]   │
│ 10 units ███ 38 ops (15.5%)  [90.5%]   │
│ Other    ██ 35 ops (14.3%)   [87.5%]   │
└─────────────────────────────────────────┘

NC QTY Distribution  [Defects]
┌─────────────────────────────────────────┐
│ 0 defects   ███████ 78 ops (31.8%)     │
│ 1 defect    ██████ 68 ops (27.8%)      │
│ 2 defects   ████ 42 ops (17.1%)        │
│ 3 defects   ███ 28 ops (11.4%)         │
│ 4+ defects  ██ 29 ops (11.8%)          │
└─────────────────────────────────────────┘

Employees on CNC-01
┌──────────────┬────────┬──────────┐
│ Employee     │ Ops    │ Avg Qty  │
├──────────────┼────────┼──────────┤
│ John Doe     │ 42     │ 24.8     │
│ Sarah Smith  │ 38     │ 23.1     │
│ Mike Johnson │ 32     │ 25.3     │
│ ... 9 more   │ ...    │ ...      │
└──────────────┴────────┴──────────┘
```

---

## 🎯 Key Insights You Can Get

### 1. **Production Efficiency**
- Compare Plan Qty vs Produced Qty
- Identify if targets are being met
- Track trends per machine

### 2. **Quality Performance**
- Compare Produced Qty vs Accepted Qty
- Calculate acceptance rate (Accepted/Produced)
- Identify quality issues per machine

### 3. **Waste Analysis**
- Analyze NC Qty distribution
- Calculate defect rate
- Track which machines have highest issues

### 4. **Consistency**
- See if quantities are consistent
- Identify outliers
- Track stability per machine

### 5. **Employee Performance**
- Who produces more/less?
- Who has better quality?
- Who has more waste?

---

## 📈 Advanced Calculations

### Acceptance Rate (for specific machine)
```
Acceptance Rate = (Total Accepted) / (Total Produced) × 100
```

### Defect Rate
```
Defect Rate = (Total NC Qty) / (Total Produced) × 100
```

### Production vs Plan
```
Production %age = (Total Produced) / (Total Planned) × 100
```

### Employee Efficiency (per machine)
```
Efficiency = (Employee's Accepted Qty) / (Employee's Produced Qty) × 100
```

---

## 💾 Database Storage

These quantities are stored in `production_logs` table:

```sql
production_logs
├── id
├── log_date
├── emp_id
├── operator_name
├── f_machine_no          ← Machine identifier
├── f_plan_qty            ← Planned quantity
├── f_produced_qty        ← Produced quantity
├── f_accepted_qty        ← Accepted quantity
├── f_nc_qty              ← Non-conforming quantity
└── ... other fields
```

---

## 🔄 Data Workflow

### Data Entry (entry.php):
```
User enters:
├─ Machine: "CNC-01"
├─ Plan Qty: 50
├─ Produced Qty: 48
├─ Accepted Qty: 47
└─ NC Qty: 1

Saved to production_logs
```

### Advanced Analytics:
```
User selects:
├─ Machine Field: "Machine No"
├─ Machine: "CNC-01"
└─ Quantity Fields: All 4 checked

System queries production_logs:
SELECT f_plan_qty, COUNT(*) FROM production_logs
WHERE f_machine_no = 'CNC-01' AND f_plan_qty IS NOT NULL
GROUP BY f_plan_qty

Returns distribution of plan quantities for CNC-01
```

---

## 📊 Sample Analysis Report

### Machine Performance Report: CNC-01

**Period**: All data

**Machine Statistics**:
- Total Operations: 245
- Working Days: 42
- Average Daily: 5.8 ops/day
- Employees: 12

**Plan Quantity Analysis**:
- Most Common Plan: 20 units (31.8% of jobs)
- Range: 10-50 units
- Average: 24.9 units

**Production Analysis**:
- Total Planned: 6,100 units
- Total Produced: 5,745 units
- Production Efficiency: **94.2%** ⚠️ (6% under plan)

**Quality Analysis**:
- Total Produced: 5,745 units
- Total Accepted: 5,478 units
- Acceptance Rate: **95.4%** ✓ (Good)

**Waste Analysis**:
- Total NC Qty: 267 units
- Defect Rate: **4.6%** ⚠️
- Most Common Issue: 1-2 defects per batch

**Recommendations**:
1. Investigate why production is 6% below plan
2. Target 1% defect rate (currently 4.6%)
3. Focus on batches of 40-50 units (lower efficiency)
4. John Doe is top performer (96% acceptance rate)

---

## 🎨 Visual Representations

### Progress Bars in Tables
```
┌──────────┬────────┬──────────────────────────────────┐
│ Qty      │ Count  │ Percentage Visualization         │
├──────────┼────────┼──────────────────────────────────┤
│ 20 units │  78    │ ████████████████████░░░░░ 31.8% │
│ 30 units │  52    │ ██████████░░░░░░░░░░░░░░░ 21.2% │
│ 40 units │  35    │ ███████░░░░░░░░░░░░░░░░░░ 14.3% │
└──────────┴────────┴──────────────────────────────────┘
```

### Trend Analysis (if you select multiple machines)
```
CNC-01: Acceptance Rate 95.4%  ████████████████░░░░ 
Lathe-02: Acceptance Rate 92.1% █████████████░░░░░░░░
Drill-03: Acceptance Rate 97.8% ████████████████████
```

---

## ✅ Checklist for Setup

- [ ] Created parent field "Machine No"
- [ ] Created "Plan Qty" as dependent field
- [ ] Created "Produced Qty" as dependent field
- [ ] Created "Accepted Qty" as dependent field
- [ ] Created "NC Qty" as dependent field
- [ ] All fields set to parent: "Machine No"
- [ ] All fields marked as Active
- [ ] Fields have entries in production_logs
- [ ] Opened analytics_advanced.php
- [ ] Selected Machine No as the machine field
- [ ] Selected a specific machine
- [ ] Checked quantity fields
- [ ] Viewed charts and tables

---

## 🚀 Tips & Tricks

### Tip 1: Quick Comparison
- Select all 4 quantity fields
- Get instant 4-chart view of that machine
- Compare and analyze together

### Tip 2: Identify Best Performers
- View employees table
- See who has best "Accepted Qty"
- Calculate their efficiency manually

### Tip 3: Quality Trends
- Accepted Qty should be close to Produced Qty
- Large gap = quality issues
- Track if gap is improving/worsening

### Tip 4: Waste Tracking
- NC Qty shows defects/waste
- Higher NC = more waste
- Target: Reduce by 50%

---

## 📞 Support

### Chart Not Showing?
- Verify machine has data
- Check all 4 quantities are populated
- Refresh page

### Incomplete Data?
- Ensure quantities are entered when logging
- Check fields are not null
- Verify employee filled all quantity fields

### Weird Numbers?
- Check data entry (manually verify production_logs)
- Look for 0 or null values
- Recalculate by hand to verify

---

**Ready to analyze your production quantities!** 📊✨

For more details on Advanced Analytics setup and usage, see: **ADVANCED_ANALYTICS_GUIDE.md**
