# Notification System - Deployment Checklist

## 📋 Pre-Deployment Phase

### Database Preparation
- [ ] Backup existing database
- [ ] Verify MySQL/MariaDB is running
- [ ] Confirm admin access to database
- [ ] Note database name and credentials

### File Verification
- [ ] NOTIFICATION_SYSTEM_SETUP.sql exists
- [ ] notification_ui.html exists
- [ ] notifications.php exists
- [ ] notifications.js exists
- [ ] index.php is editable
- [ ] Current backups of modified files

---

## 🔧 Installation Phase

### Step 1: Database Setup
```bash
[ ] Run SQL setup script
[ ] Verify notification_settings table created
[ ] Confirm 2 default rows inserted
[ ] Test database connection
```

**Command**:
```bash
mysql -u username -p database_name < NOTIFICATION_SYSTEM_SETUP.sql
```

**Verification**:
```bash
mysql -u username -p database_name
SELECT * FROM notification_settings;
# Should show 2 rows with thresholds
```

### Step 2: File Deployment
```bash
[ ] Copy notification_ui.html to project root
[ ] Copy notifications.php to project root
[ ] Copy notifications.js to project root
[ ] Verify all files are accessible (chmod 644)
[ ] Check file ownership matches web server user
```

**Commands**:
```bash
cp notification_ui.html /path/to/erp.manufacture/
cp notifications.php /path/to/erp.manufacture/
cp notifications.js /path/to/erp.manufacture/
chmod 644 notification_ui.html notifications.php notifications.js
```

### Step 3: Backup and Update Admin Dashboard
```bash
[ ] Create backup of index.php (e.g., index.php.backup)
[ ] Update page-header section (add bell button)
[ ] Update style section (add notification CSS)
[ ] Add notification_ui.html inclusion (before </body>)
```

**Changes to index.php**:
- Add bell button after `<h1>` tag (line ~512)
- Add CSS for .notification-btn and .notification-badge (line ~507)
- Include notification_ui.html before `</body>` tag (last section)

### Step 4: Verify Dependencies
```bash
[ ] FontAwesome CSS is loaded (via CDN or locally)
[ ] Session.php exists and sets $_SESSION['admin']
[ ] maintenance.php exists (for "Go to Maintenance" link)
[ ] entry_log.php exists (for context)
```

---

## 🧪 Testing Phase

### Test 1: Admin Access
```bash
[ ] Login as admin user
[ ] Navigate to admin dashboard (index.php)
[ ] Verify bell icon 🔔 appears in top-right corner
[ ] Verify bell icon does NOT appear when logged out
```

### Test 2: Sidebar Functionality
```bash
[ ] Click bell icon
[ ] Sidebar slides in from right
[ ] Dark overlay appears
[ ] Click X button - sidebar closes
[ ] Click overlay - sidebar closes
[ ] Open sidebar again - works smoothly
```

### Test 3: Notification Loading
```bash
[ ] Sidebar opens
[ ] Network tab shows GET request to notifications.php
[ ] Response code is 200
[ ] Response is valid JSON
[ ] Notifications list displays (or "No notifications" message)
```

### Test 4: Badge Display
```bash
[ ] If notifications exist: badge shows count
[ ] If no notifications: badge is empty/removed
[ ] If critical alerts: badge shows "X CRITICAL"
[ ] Badge pulses if notifications present
```

### Test 5: Settings Modal
```bash
[ ] Click "Settings" button in sidebar
[ ] Settings modal appears centered on screen
[ ] Modal shows current threshold values
[ ] Input fields are editable
[ ] Click "Save Settings" - shows success message
[ ] Check notification_settings table - values updated
```

### Test 6: Notification Rendering
If notifications exist in database:
```bash
[ ] Notification item displays all components
[ ] Icon appears (machine or tool)
[ ] Severity badge displays correct color
[ ] Message is readable
[ ] Item name is shown
[ ] Timestamp is displayed
[ ] "Go to Maintenance" button is clickable
```

### Test 7: Actions
```bash
[ ] Click "Go to Maintenance" button
[ ] Redirects to maintenance.php
[ ] maintenance.php loads successfully
[ ] No JavaScript errors in console
```

### Test 8: Auto-Refresh
```bash
[ ] Keep sidebar open
[ ] Monitor Network tab in DevTools
[ ] Wait 30+ seconds
[ ] New GET request to notifications.php appears
[ ] Check response - fresh data
[ ] Wait another 30 seconds - request appears again
```

### Test 9: Browser Console
```bash
[ ] Open DevTools (F12)
[ ] Go to Console tab
[ ] No error messages
[ ] No login/authorization errors
[ ] NotificationManager logs initialization (if logging enabled)
```

### Test 10: Non-Admin Access
```bash
[ ] Logout as admin
[ ] Login as regular user (non-admin)
[ ] Navigate to dashboard
[ ] Bell icon should NOT appear
[ ] Try accessing notifications.php directly
[ ] Should return 403 Forbidden
```

---

## 🔍 Debugging Checklist

If any test fails, debug using:

### Database Connection Issue
```bash
[ ] Check MySQL is running
[ ] Verify credentials in notifications.php
[ ] Test connection: mysql -u user -p database
[ ] Check notification_settings table exists
[ ] Verify table has data
```

### Frontend Issues
```bash
[ ] Open DevTools Console (F12 → Console)
[ ] Check for JavaScript errors
[ ] Check Network tab for failed requests
[ ] Clear browser cache (Ctrl+Shift+Del)
[ ] Try different browser
[ ] Check notification_ui.html is included in HTML source
```

### Bell Icon Missing
```bash
[ ] Verify user is logged in as admin
[ ] Check $_SESSION['admin'] is set correctly
[ ] Verify index.php has bell button code
[ ] Check page-header div has the button
[ ] Verify admin check condition: <?php if (isset($_SESSION['admin']) && $_SESSION['admin'] == true) { ?>
```

### Sidebar Won't Open
```bash
[ ] Check notification_ui.html is included
[ ] Verify CSS is loaded (check for .notification-sidebar class)
[ ] Check JavaScript error in console
[ ] Verify notifications.js is loaded
[ ] Check NotificationManager is instantiated
```

### Settings Won't Save
```bash
[ ] Verify form sends POST request
[ ] Check data parameters in Network tab
[ ] Verify admin authentication passing
[ ] Check database write permissions
[ ] Look for MySQL errors in error log
[ ] Verify input values are numbers (not text)
```

### Notifications Don't Load
```bash
[ ] Check notifications.php?action=get_notifications response
[ ] Verify response is valid JSON
[ ] Check database query in notifications.php
[ ] Verify machines and field_options tables have data
[ ] Test query directly: SELECT ... FROM machines WHERE ...
```

---

## 📊 Final Verification

### Database
```sql
[ ] SELECT COUNT(*) FROM notification_settings; → Should be 2
[ ] SELECT * FROM notification_settings; → Shows thresholds
[ ] SELECT COUNT(*) FROM machines; → Has machine data
[ ] SELECT COUNT(*) FROM field_options; → Has tool data
```

### Files
```bash
[ ] ls -la notification_ui.html → File exists, size ~600 lines
[ ] ls -la notifications.php → File exists, size ~200 lines
[ ] ls -la notifications.js → File exists, size ~300 lines
[ ] grep "notification-btn" index.php → Found in index.php
[ ] grep "notification_ui.html" index.php → Included at end
```

### Frontend
```javascript
// In browser console:
[ ] window.notificationManager → Should be an object
[ ] window.notificationManager.notifications → Should be array
[ ] toggleNotificationSidebar() → Should be a function
[ ] document.getElementById('notificationSidebar') → Should exist
```

### Performance
```
[ ] Page load time < 3 seconds
[ ] Sidebar open animation < 500ms
[ ] API response time < 1 second
[ ] No memory leaks (DevTools → Memory)
[ ] CPU usage normal during refresh
```

---

## 🚀 Production Deployment

### Final Checks
```bash
[ ] All tests passed
[ ] No errors in logs
[ ] Database backed up
[ ] Documentation updated
[ ] Team informed about new feature
```

### Rollback Plan
If issues occur:
```bash
[ ] Restore backup of index.php → index.php.backup
[ ] Stop using notifications (keep UI in place, just doesn't load)
[ ] Or remove inclusion: <!-- include notification_ui.html -->
[ ] Database changes are non-destructive (can leave table)
```

### Post-Deployment
```bash
[ ] Monitor error logs for 24 hours
[ ] Check notification.php API logs
[ ] Watch database performance
[ ] Gather user feedback
[ ] Document any issues found
```

---

## 📋 Handoff Checklist

Before handing off to operations team:

### Documentation
- [ ] NOTIFICATION_ADMIN_GUIDE.md provided (for admins)
- [ ] NOTIFICATION_QUICK_REFERENCE.md provided (for quick lookup)
- [ ] NOTIFICATION_SETUP_VERIFICATION.md provided (for support)
- [ ] NOTIFICATION_SYSTEM_COMPLETE_GUIDE.md provided (technical overview)
- [ ] This checklist provided (for deployment verification)

### Training
- [ ] Admins trained on using notifications
- [ ] Support team trained on troubleshooting
- [ ] Developers have code documentation comments
- [ ] Operations team has setup/backup procedures

### Access & Credentials
- [ ] Database credentials securely stored
- [ ] File ownership set correctly
- [ ] Permissions verified (readable by web server)
- [ ] Backup location documented

### Support Resources
- [ ] Contact information for developer support
- [ ] Link to documentation repository
- [ ] Escalation procedure for major issues
- [ ] Regular maintenance schedule defined

---

## ✅ Sign-Off

### Technical Review
```
Reviewer: ______________________  Date: __________
[ ] Code quality acceptable
[ ] Security requirements met
[ ] Performance acceptable
[ ] Documentation adequate
```

### QA Sign-Off
```
QA Lead: ______________________  Date: __________
[ ] All tests passed
[ ] Edge cases handled
[ ] Error handling adequate
[ ] User experience acceptable
```

### Deployment Approval
```
Project Manager: ______________________  Date: __________
[ ] Requirements met
[ ] Stakeholder approval received
[ ] Deployment schedule confirmed
[ ] Support team ready
```

---

## 🎯 Quick Status Indicator

| Status | Icon | Meaning |
|--------|------|---------|
| ✅ Complete | ✓ | Step done and verified |
| ⏳ In Progress | ⤓ | Currently working on |
| ❌ Failed | ✗ | Issue found, needs fixing |
| ⏯️ Pending | ◔ | Waiting to start |

---

## 📞 Support Contacts

**Technical Issues**:
- Developer: [Contact Name]
- Email: [Email]
- Phone: [Phone]

**Database Issues**:
- DBA: [Contact Name]
- Email: [Email]
- Phone: [Phone]

**User Support**:
- Help Desk: [Contact]
- Email: [Email]
- Ticket System: [Link]

---

## 📈 Success Metrics

After deployment, monitor:

- [ ] System uptime: > 99.9%
- [ ] API response time: < 500ms (average)
- [ ] Notification accuracy: > 95%
- [ ] User adoption: [Target]%
- [ ] Support tickets: < [Number] per week

---

**Print this checklist and check off each box as you proceed.**
**Keep this in your project documentation for future reference.**

