# Notification System - Complete Admin Guide

## System Overview

The notification system provides real-time alerts to admin users about:
1. **Machine Maintenance** - When machines are approaching their maintenance due dates
2. **Tool Stroke Alerts** - When tools are running low on available strokes

All notifications are **admin-only** and accessible from the top-right corner of the dashboard.

---

## Quick Start

### Accessing Notifications

1. Log in to your admin account
2. Go to the **Analytics Dashboard**
3. Look for the **bell icon** (🔔) in the top-right corner
4. **Click the bell** to open the notification sidebar

### Understanding the Bell Icon

- **Badge with Number** - Shows total number of active notifications
- **Red Badge** - Indicates critical alerts require immediate attention
- **Pulsing Animation** - Badge pulses when new notifications arrive
- **Gray Bell** - No active notifications (hover shows tooltip)

---

## Notification Sidebar

When you click the bell icon, a sidebar slides in from the right side showing:

### Notification Item Structure

Each notification shows:
```
[ICON] Title
            [SEVERITY BADGE]
Message about the alert
Item Name • Timestamp
[Go to Maintenance] Button
```

### Notification Types

#### Machine Alerts
- **Icon**: ⚙️ (cogs)
- **Example**: "Machine M-001 Maintenance Due"
- **Message**: "Machine will require maintenance in X days"
- **Color**: Blue accent

#### Tool Alerts
- **Icon**: 🔧 (tools)
- **Example**: "Tool G3 Stroke Limit Warning"
- **Message**: "Tool has X strokes remaining"
- **Color**: Red accent

### Severity Levels

#### 🔴 CRITICAL (Red)
- Machine maintenance due in **less than 5 days**
- Tool has **less than 100 strokes remaining**
- **Action**: Address immediately

#### 🟠 WARNING (Orange)
- Machine maintenance due in **5-15 days** (configurable)
- Tool has **100-1000 strokes remaining** (configurable)
- **Action**: Plan maintenance within the timeframe

#### 🔵 INFO (Blue)
- General maintenance reminders
- Tool usage trending toward limits
- **Action**: Monitor and plan accordingly

---

## Sidebar Controls

### Footer Buttons

#### Settings Button (⚙️)
Opens the notification settings modal where you can configure:
- **Machine Maintenance Alert Threshold** (days before due date)
- **Tool Stroke Alert Threshold** (remaining strokes)

#### Clear All Button
Removes all notifications from the display (does not delete from database):
- Requires confirmation
- Notifications regenerate if condition still exists
- Useful for clearing old alerts

### Notification Actions

Each notification has a **"Go to Maintenance"** button:
- Automatically opens the **Maintenance Dashboard**
- Shows specific tool/machine details
- Ready for action (adjustment or maintenance scheduling)

---

## Settings Configuration

### Opening Settings

1. Click the **bell icon** to open notifications
2. Click **⚙️ Settings** button at the bottom
3. The settings modal appears (centered on screen)

### Available Settings

#### Machine Maintenance Alert (Days)
- **Default**: 15 days
- **Range**: 1-365 days
- **What it means**: Alert when next maintenance is due in X days
- **Example**: Set to 30 to get alerts one month before maintenance

#### Tool Stroke Alert (Remaining Strokes)
- **Default**: 1000 strokes
- **Range**: 1-100,000 strokes
- **What it means**: Alert when tool has less than X strokes left
- **Example**: Set to 500 for tools that need frequent changes

### Saving Settings

1. Adjust the values using the number inputs
2. Click **Save Settings** button
3. Confirmation message appears
4. Settings are saved to database immediately

### Notes on Settings

- Changes apply **immediately**
- Only affects **future notifications**
- Existing notifications refresh within 30 seconds
- Settings are **per-admin** (stored centrally for all admins)
- Settings persist across sessions

---

## Auto-Refresh & Real-Time Updates

### Auto-Refresh Behavior

- Notifications automatically refresh every **30 seconds**
- New notifications appear automatically in the sidebar
- Badge count updates in real-time
- No manual refresh needed

### Triggering Immediate Updates

Notifications also update immediately when:
- Product is entered in **Entry Log** (triggers tool stroke reduction)
- Tool stroke is manually updated in **Maintenance Dashboard**
- Machine records are updated
- Settings are changed

---

## Notification Generation Logic

### Machine Maintenance Alerts

A notification is generated when:
```
Machine Next Due Date - Current Date ≤ Machine Days Threshold
```

**Example**:
- Machine maintenance last done: January 1
- Life limit: 90 days
- Next due: March 31
- Current date: March 20
- Threshold: 15 days
- Days remaining: 11 days
- **Result**: 🔔 NOTIFICATION (11 ≤ 15)

### Tool Stroke Alerts

A notification is generated when:
```
(Tool Max Strokes - Current Usage) ≤ Tool Strokes Threshold
```

**Example**:
- Tool: G3
- Max strokes: 3000
- Current usage: 2200
- Remaining: 800
- Threshold: 1000
- **Result**: 🔔 NOTIFICATION (800 ≤ 1000)

---

## Admin Dashboard Integration

### Notification Button Visibility

- **✅ Visible** for admin users
- **❌ Hidden** for regular employees
- Appears in **top-right corner** of dashboard page header

### When Notifications Don't Show

1. **Not logged in as admin** - Button won't visible
2. **Database connection issue** - Check database status
3. **Missing notification_settings table** - Run setup SQL
4. **Browser console errors** - Check for JavaScript errors

---

## Best Practices

### Recommended Alert Thresholds

#### For Production Environments
- **Machine Alerts**: 20-30 days (allows planning time)
- **Tool Alerts**: 500-1500 strokes (depends on tool type)

#### For High-Volume Production
- **Machine Alerts**: 10-15 days (more frequent maintenance)
- **Tool Alerts**: 200-500 strokes (tools need frequent changes)

#### For Critical Equipment
- **Machine Alerts**: 30-45 days (maximum planning time)
- **Tool Alerts**: 2000-5000 strokes (conservative usage)

### Maintenance Workflow

1. **Get Notification** 📬 Bell icon shows alert
2. **Review Details** 👀 Click bell to see specifics
3. **Go to Maintenance** 🔧 Click action button
4. **Schedule/Perform** 📅 Update maintenance records
5. **Clear Alert** ✅ Notification auto-clears when condition resolved

### Monitoring Best Practices

- **Check notifications daily** at start of shift
- **Adjust thresholds** based on actual maintenance patterns
- **Monitor critical alerts** immediately
- **Use maintenance page** to verify machine/tool status
- **Log entries promptly** to keep stroke counts accurate

---

## Troubleshooting

### Bell Icon Doesn't Appear

**Cause**: Not logged in as admin
**Solution**: Verify admin status in session_check.php

**Cause**: Database error
**Solution**: Run NOTIFICATION_SYSTEM_SETUP.sql to create tables

### Notifications Not Updating

**Cause**: Browser cache issue
**Solution**: Clear browser cache and refresh page (Ctrl+F5)

**Cause**: Auto-refresh disabled
**Solution**: Check browser console for JavaScript errors

### Settings Won't Save

**Cause**: Database write permissions
**Solution**: Verify PHP user has write access to notification_settings table

**Cause**: Invalid input values
**Solution**: Use numbers only (no text) within valid range

### Sidebar Won't Close

**Cause**: CSS loading issue
**Solution**: Verify notification_ui.html is included properly

**Cause**: JavaScript error
**Solution**: Check browser console (F12) for errors

### Too Many Notifications

**Cause**: Thresholds set too low
**Solution**: Increase threshold values in settings

**Cause**: Outdated machine/tool records
**Solution**: Update maintenance_date in machines table via maintenance.php

---

## Technical Information

### Database Tables Used

1. **notification_settings**
   - Stores threshold configurations
   - Fields: id, setting_key, setting_value, description, last_updated

2. **custom_fields** (referenced)
   - Tool definitions with max strokes
   - Field: life_limit (max strokes for tools)

3. **field_options** (referenced)
   - Current tool usage tracking
   - Field: current_usage (strokes used)

4. **machines** (referenced)
   - Machine maintenance tracking
   - Field: next_due_date (calculated from last_service + life_limit)

### API Endpoints

All endpoints require **admin authentication** via session.

#### GET /notifications.php?action=get_notifications
Returns array of active notifications:
- Machine maintenance alerts
- Tool stroke alerts
- Sorted by severity (critical first)

#### GET /notifications.php?action=get_notification_settings
Returns current threshold configuration:
- machine_days_threshold
- tool_strokes_threshold

#### POST /notifications.php (action=update_notification_settings)
Updates notification settings:
- Parameters: machine_days_threshold, tool_strokes_threshold
- Returns success/error response

### JavaScript Classes

**NotificationManager** - Main class handling:
- Loading notifications from API
- Rendering notification list
- Managing sidebar open/close
- Handling settings modal
- Auto-refresh logic

---

## Performance Impact

- **CPU**: Minimal impact (simple queries and rendering)
- **Database**: Small queries every 30 seconds
- **Network**: ~2KB response per refresh
- **Memory**: ~50KB for sidebar and JavaScript

**Safe for**: All production environments
**Optimization**: Can adjust refresh interval in notification_ui.html

---

## Security Considerations

### Access Control
- Admin-only feature (checked in PHP)
- API endpoints require session authentication
- Settings modifications require admin role

### Data Privacy
- Notifications contained to admin view
- No sensitive data logged externally
- Alerts based on configurable thresholds

### SQL Injection Prevention
- All queries use prepared statements
- Input validation on threshold values
- Parameterized queries in notifications.php

---

## Support & Documentation

### File References
- **Frontend**: notification_ui.html
- **Backend**: notifications.php
- **Database Setup**: NOTIFICATION_SYSTEM_SETUP.sql
- **Integration**: NOTIFICATION_UI_INTEGRATION.md
- **This Guide**: NOTIFICATION_ADMIN_GUIDE.md

### Quick Links
1. **Maintenance Dashboard**: maintenance.php
2. **Entry Log**: entry_log.php
3. **Analytics Dashboard**: index.php (with notifications)
4. **API Documentation**: production_stroke_handler.php

---

## Changelog

### Version 1.0 (Current)
- ✅ Machine maintenance alerts
- ✅ Tool stroke alerts
- ✅ Configurable thresholds
- ✅ Real-time notifications
- ✅ Settings panel
- ✅ Admin-only access
- ✅ 30-second auto-refresh
- ✅ Severity classification

### Future Enhancements
- 🔄 Email notifications for critical alerts
- 🔄 Desktop notifications API
- 🔄 Sound alerts
- 🔄 Notification history/archive
- 🔄 Custom alert messages
- 🔄 Multiple alert thresholds per tool type
