# 🎯 G3 Tool 3000 Units Test - Visual Guide

## Quick Test Scenario

**Goal**: Produce 3000 units with g3 tool and watch the maintenance dashboard dynamically reduce strokes

---

## Step 1️⃣: Prepare - Open Both Pages

### Tab 1: Maintenance Dashboard
1. Go to: **Maintenance** (Left sidebar → Maintenance)
2. Look for **Tool Management & Production Summary** table
3. Find **g3** tool row
4. **Remember these numbers**:
   - Current Strokes Used: `___________`
   - Current Remaining: `___________`
   - Current Status: `___________`

### Tab 2: Production Entry
1. Go to: **Daily Production Entry** (Left sidebar → Daily Entry)
2. Keep window **next to Maintenance tab** (arrange windows side-by-side)

---

## Step 2️⃣: Fill the Production Entry Form

```
┌─ Daily Production Entry ──────────────────────────────┐
│                                                        │
│ Date:              [auto-filled today]                │
│ Employee ID:       [Select any - e.g., EMP001]       │
│ Operator Name:     [Auto-populates]                   │
│                                                        │
│ Tool:              [SELECT: g3] ← IMPORTANT          │
│ M/C No:            [Select any]                       │
│ Operation:         [Select any]                       │
│ Category:          [Select any]                       │
│ Part Name:         [Select any]                       │
│                                                        │
│ Start Time:        [Select start]                     │
│ End Time:          [Select end]                       │
│ Duration:          [Auto-calculated]                  │
│                                                        │
│ Plan Qty:          3000                               │
│ Produced Qty:      3000 ← IMPORTANT (REDUCES strokes) │
│ Accepted Qty:      2900                               │
│                                                        │
│ [Save Entry to Log] ← CLICK THIS                      │
│                                                        │
└────────────────────────────────────────────────────────┘
```

---

## Step 3️⃣: Click Save & Watch!

When you click **"Save Entry to Log"**:

### What Happens Instantly:
1. ✅ Green success message appears: "Entry Saved Successfully! Tool strokes updated automatically."
2. ✅ Form clears
3. ✅ localStorage event triggers

### What Happens Next (Within 1 second):
4. 🔔 Maintenance dashboard detects change
5. 📊 Calls API to fetch latest tool data
6. 🔄 Updates g3 row with new values

### What You Should See:
- 🟡 **Yellow highlight** appears on g3 row cells
- 📈 **Strokes Used** increases by 3000
- 📉 **Remaining** decreases by 3000
- %️ **Usage** percentage updates
- 🏷️ **Status** badge might animate

---

## Step 4️⃣: Expected Results

```
BEFORE Production Entry:
┌─────────────────────────────────────────────────────┐
│ Tool │ Strokes │ Max │ Remaining │ Usage % │ Status │
│ g3   │   0     │50k  │  50,000   │   0%    │ GOOD   │
└─────────────────────────────────────────────────────┘

AFTER Producing 3000 with g3:
┌─────────────────────────────────────────────────────┐
│ Tool │ Strokes │ Max │ Remaining │ Usage % │ Status │
│ g3   │  3,000  │50k  │  47,000   │   6%    │ GOOD   │  ← UPDATED!
└─────────────────────────────────────────────────────┘
                      ↑ Yellow highlight for 1 second
```

**Math Verification:**
- ✅ Strokes Used: 0 + 3,000 = 3,000 ✓
- ✅ Remaining: 50,000 - 3,000 = 47,000 ✓
- ✅ Usage %: (3,000 ÷ 50,000) × 100 = 6% ✓

---

## Step 5️⃣: Repeat to See Accumulation

Do the test again with **another 2000 units**:

```
SECOND Production Entry (2000 units with g3):
┌─────────────────────────────────────────────────────┐
│ Tool │ Strokes │ Max │ Remaining │ Usage % │ Status │
│ g3   │  5,000  │50k  │  45,000   │   10%   │ GOOD   │  ← UPDATED!
└─────────────────────────────────────────────────────┘
```

**Values accumulate:**
- Strokes Used: 3,000 + 2,000 = 5,000 ✓
- Remaining: 47,000 - 2,000 = 45,000 ✓

---

## 🔍 How to Verify in Console

Press **F12** to open Developer Tools → **Console** tab

**You should see messages like:**
```
✓ Tool ID captured: 2
✓ Produced Qty captured: 3000
=== FORM DATA BEING SENT ===
  tool_id: 2
  produced_qty: 3000
  ... (more fields)

✓ Maintenance page refresh triggered via localStorage

🔔 Production entry detected, refreshing tool data immediately...

✅ Tool data updated at 14:35:22
```

---

## 🔍 How to Verify in Network Tab

Press **F12** → **Network** tab

**Watch for two requests:**

1. **POST api.php** (Save production entry)
   - Status: 200 ✓
   - Response: `{"success": true, ...}`

2. **GET api.php?action=get_tool_data** (Fetch updated tool data)
   - Status: 200 ✓
   - Response: Contains g3 with updated `current_usage`

---

## 🔍 How to Verify in Database

Run this SQL query to confirm data was saved:

```sql
-- Check tool current usage
SELECT id, label, current_usage, life_limit, 
       (life_limit - current_usage) as remaining
FROM field_options 
WHERE label = 'g3' 
LIMIT 1;

-- Expected: current_usage = 3000 (or higher if you did multiple tests)
```

---

## ✅ Success Checklist

When the test is complete, verify:

- [x] Production entry was saved successfully (green message)
- [x] Maintenance page showed yellow highlight
- [x] g3 Strokes Used increased by 3000
- [x] g3 Remaining decreased by 3000
- [x] Usage % updated correctly
- [x] Console showed success messages
- [x] Network tab showed successful requests
- [x] Database shows updated current_usage

---

## 🚨 If Something Goes Wrong

| Issue | Solution |
|-------|----------|
| No yellow highlight | Wait 3 seconds for auto-refresh |
| Numbers didn't change | Hard refresh maintenance page (Ctrl+F5) |
| Form didn't save | Check console for errors (F12) |
| Can't find g3 tool | Make sure it's in the Tool dropdown |
| API error | Check if database connection is working |

---

## ⏱️ Timeline of What Happens

```
00:00 - You click "Save Entry to Log"
00:01 - API validates and saves production entry
00:02 - API updates field_options.current_usage += 3000
00:03 - localStorage event triggers
00:04 - Maintenance page detects change
00:05 - Calls get_tool_data API
00:06 - Receives updated tool data
00:07 - Updates g3 row in table
00:08 - Highlights cells yellow
00:09 - User sees visual update! ✅
01:00 - Yellow highlight fades away
```

**Total time: Less than 1 second in most cases!**

---

## 🎨 Visual Indicators

| Visual | Meaning | Duration |
|--------|---------|----------|
| 🟡 Yellow cell | Value just changed | 1 second |
| 📳 Pulsing badge | Status changed | 0.6 seconds |
| 🔵 Blue % box | Usage % updated | Instant |
| 🔄 Spinning icon | Data loading | While loading |

---

## 📱 Pro Tips

1. **Open both tabs side-by-side** for best viewing
2. **Keep F12 open** to see console messages in real-time
3. **Try different quantities** to see accumulation
4. **Test quickly after save** to see auto-refresh
5. **Click Refresh Now button** to manually trigger update

---

## ✨ Expected Behavior Summary

When you **select g3 tool and produce 3000 units**:

1. ✅ System automatically captures both values
2. ✅ Increases g3's stroke counter by 3000
3. ✅ Maintenance dashboard auto-refreshes
4. ✅ Shows yellow highlight on changed cells
5. ✅ Updates all related calculations
6. ✅ Changes status if needed
7. ✅ Everything happens automatically - NO manual updates needed!

---

**Ready to test? Let's go!** 🚀

Test with g3 tool and 3000 units now and watch the maintenance dashboard update in real-time!
