# Analytics Dashboard - Quick Reference Guide

## 🚀 Quick Start

### Access Analytics
```
1. Login to system
2. Click "Analytics" in sidebar
3. See dashboard with stats and charts
```

---

## 📅 Date-Wise Statistics (NEW)

### How to Use
```
1. Click "Load Date-Wise Report" button
2. Dates auto-populate (last 30 days)
3. Optionally change date range
4. Click "Filter Report"
5. View heatmap and detailed table
```

### What You See

**Heatmap Chart:**
- 📊 Blue bars = Total records per day
- 👥 Pink bars = Active employees per day
- Track correlation between records and employees

**Detailed Table:**
```
Date    Day   Total Records   Employees   Avg/Emp   Peak Hour
────────────────────────────────────────────────────────────
2026-01-30  Wed   312         12         26.0      14
2026-01-29  Tue   295         11         26.8      15
```

### Key Metrics
- **Date:** Calendar date
- **Day:** Mon, Tue, Wed, etc.
- **Total Records:** Production logs count
- **Employees:** How many unique employees worked
- **Avg/Emp:** Average records per employee
- **Peak Hour:** Busiest hour (0-23, military time)

### Interpretation
```
High Records + Few Employees = Employees working hard
High Records + Many Employees = Team effort
Low Records = Slow day
Peak Hour 14 = 2:00 PM is busiest
```

---

## 🔄 Field Comparison (ENHANCED)

### Quick Start
```
1. Select "Field 1" from dropdown
2. Select "Field 2" from dropdown
3. Click "Compare Fields"
4. View comparison results
```

### Viewing Results

#### Insight Cards (Top)
```
┌─────────────────────────────────────────┐
│ Field 1 Insights          Field 2 Insights │
│ 🟦 45 Unique Values       🟪 3 Unique Values │
│ • 2,340 total records     • 156 total records │
│ • 156 max frequency       • 45 max frequency  │
└─────────────────────────────────────────┘
```
**What it means:**
- Shows summary statistics at a glance
- Compares quantity and frequency metrics
- Helps identify which field is more varied

#### Comparative Chart
**Chart Types:**
1. **[Bar]** - Best for comparing top values
   - Side-by-side bars
   - Easy to read differences
   - Shows top items

2. **[Radar]** - Best for distribution patterns
   - 360° view of all values
   - Spot shape/pattern differences
   - Compare overall distributions

3. **[Pie]** - Best for understanding proportions
   - Percentage breakdown
   - Visual size comparison
   - Good for "part of whole" view

**How to Switch:**
```
Click buttons in chart title:
[Bar] [Radar] [Pie]
Active button = Teal (Blue)
Inactive button = Gray
```

#### Comparison Statistics Table
```
Metric              Field 1     Field 2     Difference    % Variance    Winner
─────────────────────────────────────────────────────────────────────────────
Unique Values       45          3           +42          +1400%         🟦 Field 1
Total Records       2,340       156         +2,184       +1400%         🟦 Field 1
Max Frequency       156         45          +111         +246%          🟦 Field 1
Avg Frequency       52.0        52.0        0            0%             ⚖️ Equal
Diversity Index     1.9%        1.9%        0            0%             ⚖️ Equal
```

**Understanding Results:**

| Symbol | Meaning | Color |
|--------|---------|-------|
| 🟦 Field 1 | Field 1 is higher/better | Blue |
| 🟪 Field 2 | Field 2 is higher/better | Pink |
| ⚖️ Equal | Both are the same | Gray |
| 🟢 +10% | Increase (good) | Green |
| 🔴 -10% | Decrease (bad) | Red |

**Metric Explanations:**

1. **Unique Values**
   - How many different values exist
   - Higher = More variety
   - Lower = More consistent

2. **Total Records**
   - Total count of entries
   - Higher = More data points
   - Indicates usage level

3. **Max Frequency**
   - Highest occurrence of any value
   - Lower = More balanced
   - Higher = Dominated by one value

4. **Avg Frequency**
   - Average count per value
   - Equals: Total Records ÷ Unique Values
   - Shows how spread out data is

5. **Diversity Index**
   - Percentage: Unique Values ÷ Total Records × 100
   - Higher = More diverse
   - Lower = Less diverse

---

## 📊 Chart Interpretation Guide

### Bar Chart
```
When to use: Comparing exact values
Example:    Machine A: 150 | Machine B: 120 | Machine C: 180

Reading:
• Taller bar = More occurrences
• Shorter bar = Fewer occurrences
• Compare heights visually
```

### Radar Chart
```
When to use: Comparing distributions and patterns
Example:    Field 1 forms star shape, Field 2 forms circle

Reading:
• Outer points = Higher values
• Inner points = Lower values
• Compare overall shapes
• Spot pattern differences
```

### Pie Chart
```
When to use: Understanding percentages and proportions
Example:    Machine A: 35% | Machine B: 40% | Machine C: 25%

Reading:
• Bigger slice = Larger percentage
• Smaller slice = Smaller percentage
• Add to 100%
• Good for "whole" understanding
```

---

## ⚡ Common Use Cases

### Use Case 1: Identify Busiest Days
```
1. Load Date-Wise Report
2. Look at "Total Records" column
3. Highest numbers = Busiest days
4. Use for: Scheduling, staffing decisions
```

### Use Case 2: Compare Employee Activity
```
1. Compare two employee fields
2. Check "Total Records" metric
3. Higher value = More active
4. Use for: Performance analysis, workload
```

### Use Case 3: Analyze Peak Hours
```
1. Load Date-Wise Report
2. Look at "Peak Hour" column
3. Most frequent hours = Bottlenecks
4. Use for: Resource planning, optimization
```

### Use Case 4: Compare Machine Usage
```
1. Select two machine fields for comparison
2. View "Total Records" metric
3. Higher usage = More popular machine
4. Use for: Maintenance scheduling, upgrades
```

### Use Case 5: Identify Data Patterns
```
1. Use Radar Chart for field comparison
2. Compare shapes between two fields
3. Similar shapes = Similar patterns
4. Use for: Data quality, anomaly detection
```

---

## 🛠️ Troubleshooting

### Problem: Date-Wise Report Shows "No data"
```
Solution:
1. Check start date < end date
2. Verify dates are in YYYY-MM-DD format
3. Try recent date range (last 90 days)
4. Check if production_logs has data for that period
```

### Problem: Comparison Chart Not Rendering
```
Solution:
1. Ensure Field 1 ≠ Field 2 (different fields)
2. Both fields must have data
3. Try Bar chart first (simpler)
4. Check browser console (F12) for errors
5. Refresh page and retry
```

### Problem: Statistics Show Wrong Numbers
```
Solution:
1. Verify data in production_logs table
2. Check database connection
3. Ensure emp_id and log_date are populated
4. Try different date range
```

### Problem: Slow Performance
```
Solution:
1. Use smaller date range (7-30 days)
2. Check internet speed
3. Close other browser tabs
4. Clear browser cache
5. Try different chart type
```

---

## 📱 Mobile Usage

**Responsive Features:**
✅ Date pickers work on mobile
✅ Charts adjust to screen size
✅ Tables scroll horizontally
✅ Buttons remain touchable
✅ Touch-friendly controls

**Mobile Tips:**
1. Use landscape orientation for charts
2. Pinch to zoom into charts
3. Swipe to scroll tables
4. Double-tap for details

---

## 🔑 Keyboard Shortcuts

| Shortcut | Action |
|----------|--------|
| Enter | Submit form |
| Tab | Move between fields |
| Escape | Close modals |
| Ctrl+R | Refresh page |
| F12 | Open developer console |

---

## 📈 Data Export Tips

**For Analysis:**
1. Use Radar chart to understand patterns
2. Use Bar chart to find top items
3. Use Pie chart to understand proportions
4. Take screenshots for reports
5. Note the timestamps for reference

**For Presentations:**
1. Bar chart: Best for executive view
2. Pie chart: Best for proportion story
3. Date-wise: Best for trends over time
4. Statistics table: Best for detailed comparison

---

## ⚙️ Settings & Customization

### Date Range Presets
```
• Last 7 days: Quick weekly view
• Last 30 days: Standard monthly (DEFAULT)
• Last 90 days: Quarterly view
• Custom: Set your own range
```

### Chart Display Options
```
• Bar Chart: Simplest, most readable
• Radar Chart: Shows distributions
• Pie Chart: Shows percentages
```

### Table Sorting (if available)
```
Click column header to sort:
• Date: Sort chronologically
• Total Records: Sort by volume
• Employees: Sort by team size
```

---

## 💡 Pro Tips

**Tip 1: Compare Seasonal Data**
```
Compare Jan vs Feb date-wise reports to spot trends
```

**Tip 2: Use Radar Chart for Quality Check**
```
Similar shapes between fields = Good data quality
Different shapes = Data quality issues
```

**Tip 3: Peak Hour Analysis**
```
List peak hours daily to find:
• Bottlenecks
• Staffing needs
• Maintenance windows
```

**Tip 4: Track Employee Trends**
```
Use date-wise report to:
• Monitor employee count changes
• Spot absence patterns
• Plan for holidays/leaves
```

**Tip 5: Machine Comparison**
```
Compare two machines:
• Similar total records = Equal usage
• Different totals = Unequal load
• Use for: Load balancing
```

---

## 📞 Support

**Common Questions:**

Q: How often is data updated?
A: Real-time from production_logs table

Q: Can I export this data?
A: Screenshot or copy table data to Excel

Q: How many days back can I view?
A: All historical data available (no limit)

Q: Why is chart not showing?
A: Check if both fields have data

Q: Can I compare more than 2 fields?
A: Use multiple comparisons or radar chart

---

## 📚 Related Documentation

- [ANALYTICS_IMPROVEMENTS.md](ANALYTICS_IMPROVEMENTS.md) - Complete technical guide
- [ANALYTICS_BEFORE_AFTER.md](ANALYTICS_BEFORE_AFTER.md) - Feature comparison
- [analytics.php](analytics.php) - Source code
- [api.php](api.php) - API endpoints

---

**Version:** 2.0 | **Last Updated:** January 30, 2026 | **Status:** ✅ Live

---

## Quick Navigation

- [Date-Wise Statistics](#📅-date-wise-statistics-new)
- [Field Comparison](#🔄-field-comparison-enhanced)
- [Chart Guide](#📊-chart-interpretation-guide)
- [Troubleshooting](#🛠️-troubleshooting)
- [Pro Tips](#💡-pro-tips)
