# Admin Norm Configuration - Updated UI Overview

## Visual Workflow

```
┌─────────────────────────────────────────────────────────┐
│         ADMIN: Manage Fields Page                       │
├─────────────────────────────────────────────────────────┤
│                                                          │
│  📋 Form Fields Configuration                           │
│  ┌────────────────────────────────────────────────────┐ │
│  │  [Add Field Inputs...] [Save Order Button]         │ │
│  └────────────────────────────────────────────────────┘ │
│                                                          │
│  FIELD LIST:                                            │
│  ┌────────────────────────────────────────────────────┐ │
│  │ ≡  M/C NO          [TEXT INPUT]  [ON/OFF] [✏️][🗑️] │ │
│  ├────────────────────────────────────────────────────┤ │
│  │ ≡  TOOL NO    [DATA] [ON/OFF] [✏️][🗑️]            │ │ ← CLICK "DATA"
│  │              ⬇️                                     │ │
│  │    Opens Modal Below...                            │ │
│  ├────────────────────────────────────────────────────┤ │
│  │ ≡  PART NAME       [TEXT INPUT]  [ON/OFF] [✏️][🗑️] │ │
│  └────────────────────────────────────────────────────┘ │
│                                                          │
└─────────────────────────────────────────────────────────┘
                           ⬇️
                    CLICK "DATA" BUTTON
                           ⬇️
┌──────────────────────────────────────────────────────────┐
│  MODAL: Manage Dropdown Data for TOOL NO               │ ✕
├──────────────────────────────────────────────────────────┤
│                                                          │
│  📋 Manage Dropdown Data                                │
│  Adding options for: TOOL NO                            │
│                                                          │
│  ┌─ 🟢 Tool Norm Configuration ───────────────────────┐ │
│  │ For TOOL fields: Set the norm/rate value for      │ │
│  │ each tool below. This rate will be used to         │ │
│  │ automatically calculate production norms in the    │ │
│  │ entry form.                                        │ │
│  │ Example: If "Drilling" tool has norm rate of 5,   │ │
│  │ and duration is 2 hours → Norms = 2 × 5 = 10      │ │
│  └────────────────────────────────────────────────────┘ │
│                                                          │
│  ┌─ ➕ Add New Option ────────────────────────────────┐ │
│  │                                                    │ │
│  │  Option Name        Norm/Rate *    [+ Add]        │ │
│  │  [Drilling________] [5________]    [Button]       │ │
│  │                                                    │ │
│  └────────────────────────────────────────────────────┘ │
│                                                          │
│  📊 Existing Options:                                   │
│  ┌────────────────────────────────────────────────────┐ │
│  │ Drilling                              [Edit Rate]  │ │
│  │ 📊 Norm/Rate: 5 per hour              [Delete]     │ │
│  │                                                    │ │
│  │ Milling                               [Edit Rate]  │ │
│  │ 📊 Norm/Rate: 8 per hour              [Delete]     │ │
│  │                                                    │ │
│  │ Turning                               [Edit Rate]  │ │
│  │ 📊 Norm/Rate: 6 per hour              [Delete]     │ │
│  └────────────────────────────────────────────────────┘ │
│                                                          │
└──────────────────────────────────────────────────────────┘
```

---

## Detailed View: Adding a New Tool

```
Step 1: Type Tool Name
┌─────────────────────────────────┐
│ Option Name                     │
│ [Grinding________________]      │
└─────────────────────────────────┘

Step 2: Enter Norm/Rate Value
┌─────────────────────────────────┐
│ Norm/Rate *                     │
│ [12_____]                       │
│ (number, can use decimals)      │
└─────────────────────────────────┘

Step 3: Click Add Button
[✚ Add] → Tool is added to list below
```

---

## Detailed View: Editing Existing Tool

```
Current Tool in List:
┌──────────────────────────────────────────┐
│ Drilling                                 │
│ 📊 Norm/Rate: 5 per hour                 │
│ [✏️ Edit Rate]  [🗑️ Delete]              │
└──────────────────────────────────────────┘
                 ⬇️
Click "Edit Rate" → Prompt appears:

    ┌─ Edit Norm/Rate ─┐
    │ Enter new rate   │
    │ (Current: 5)     │
    │ [7________]      │
    │ [OK] [Cancel]    │
    └──────────────────┘
                 ⬇️
Value updated → List refreshes
```

---

## Key UI Improvements Made

### ✅ **1. Tool Norm Configuration Box**
- Green background (matches tool theme)
- Only shows for TOOL fields
- Explains what norms are
- Shows calculation example

### ✅ **2. Better Section Organization**
- "Add New Option" in a highlighted box
- Clear labels above each input field
- Required fields marked with *
- Descriptive placeholder text

### ✅ **3. Improved Option Display**
- Each tool on its own card
- Shows norm rate prominently
- "per hour" label for clarity
- Buttons are clearly labeled:
  - "Edit Rate" (not just "Edit")
  - Better delete button styling

### ✅ **4. User-Friendly Layout**
- All info is grouped logically
- Icons to make sections clear
- Better spacing and visual hierarchy
- Error handling with prompts

---

## Usage Summary

| Action | Where | How |
|--------|-------|-----|
| **Add new tool** | Admin → Manage Fields | Click Tool Field "Data" → Type name & rate → Click "Add" |
| **Edit tool rate** | Admin → Manage Fields | Click Tool Field "Data" → Find tool → Click "Edit Rate" |
| **Delete tool** | Admin → Manage Fields | Click Tool Field "Data" → Find tool → Click "Delete" |
| **Auto-calculate norms** | Production Entry Form | Select tool → Set duration → Norms auto-fill |

---

## Database Updates

The system uses:
- **Table**: `field_options`
- **Column**: `norm_value` (stores the norm rate)
- **Updated API Actions**:
  - `add_option` - Now accepts norm_value
  - `update_option_norm` - New action to edit norms
  - `get_options` - Returns norm_value for each option

