<?php
/**
 * SESSION SECURITY CHECK
 * Include this file at the START of every protected page (after session_start)
 * This prevents:
 * 1. Access to protected pages without login
 * 2. Back button showing logged-out pages (cache prevention)
 * 3. Session hijacking by checking session validity
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Set strict cache headers to prevent browser caching of protected pages
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0, private");
header("Pragma: no-cache");
header("Expires: Thu, 19 Nov 1981 08:52:00 GMT");

// Check if user is logged in
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role'])) {
    // User is not logged in - redirect to login page
    header("Location: login.php");
    exit();
}

// Validate session data
if (empty($_SESSION['user_id']) || empty($_SESSION['role'])) {
    // Invalid session - destroy and redirect
    session_destroy();
    header("Location: login.php");
    exit();
}

// Optional: Set session timeout (30 minutes of inactivity)
$timeout_duration = 1800; // 30 minutes
if (isset($_SESSION['last_activity'])) {
    $elapsed = time() - $_SESSION['last_activity'];
    if ($elapsed > $timeout_duration) {
        session_destroy();
        header("Location: login.php?timeout=1");
        exit();
    }
}
$_SESSION['last_activity'] = time();

// Session is valid - continue

// ------------------------------------------------------------
// ROLE-WISE PAGE ACCESS CHECK (uses role_permissions when available)
// ------------------------------------------------------------
if (!function_exists('mapPageToPermissionKey')) {
    function mapPageToPermissionKey($pageFile) {
        $mapping = [
            'index.php' => 'tools_dashboard',
            'admin_dashboard.php' => 'admin_dashboard',
            'admin_fields.php' => 'admin_fields',
            'all_employees.php' => 'all_employees',
            'analytics.php' => 'analytics',
            'analytics_advanced.php' => 'analytics',
            'analytics_old_backup.php' => 'analytics',
            'entry_log.php' => 'entry_log',
            'maintenance.php' => 'maintenance',
            'register_emp.php' => 'register_emp',
            'search_emp.php' => 'search_emp',
            'view_log.php' => 'view_log'
        ];
        return $mapping[$pageFile] ?? null;
    }
}

if (!function_exists('isLegacyBlockedPage')) {
    function isLegacyBlockedPage($role, $pageKey) {
        $role = strtolower(trim((string)$role));
        if ($role === 'controller') {
            return in_array($pageKey, ['register_emp', 'admin_fields', 'admin_dashboard'], true);
        }
        if ($role === 'supervisor') {
            return $pageKey === 'admin_dashboard';
        }
        return false;
    }
}

if (!function_exists('denyPageAccess')) {
    function denyPageAccess($message) {
        $_SESSION['access_denied_notice'] = $message;
        $currentPage = basename($_SERVER['SCRIPT_NAME'] ?? '');

        if ($currentPage === 'index.php') {
            http_response_code(403);
            echo '<!doctype html><html><head><meta charset="UTF-8"><title>Access Denied</title></head><body style="font-family:Segoe UI,Arial,sans-serif;padding:24px;">'
                . '<h2 style="color:#c0392b;margin:0 0 12px 0;">Access Denied</h2>'
                . '<p style="color:#333;">' . htmlspecialchars($message, ENT_QUOTES, 'UTF-8') . '</p>'
                . '<p><a href="login.php">Back to Login</a></p>'
                . '</body></html>';
            exit();
        }

        header("Location: index.php?access_denied=1");
        exit();
    }
}

$currentRoleRaw = trim((string)($_SESSION['role'] ?? ''));
$currentRole = strtolower($currentRoleRaw);
$currentPage = basename($_SERVER['SCRIPT_NAME'] ?? '');

// Page removed from system: block direct URL access for everyone.
if ($currentPage === 'machines_tools_admin.php') {
    denyPageAccess('Machines & Tools page has been removed.');
}

$permissionKey = mapPageToPermissionKey($currentPage);

if ($permissionKey !== null && !in_array($currentRole, ['administrator', 'admin'], true)) {
    $isAllowed = null; // null means not resolved from DB

    try {
          $host = 'localhost'; 
    $db = 'zemaraim_mektron_db'; 
    $user = 'zemaraim'; 
    $pass = '8wwxk]-X3Kx]CJ]5';

        $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]);

        $tableStmt = $pdo->query("SHOW TABLES LIKE 'role_permissions'");
        $hasPermissionTable = $tableStmt && $tableStmt->fetchColumn();

        if ($hasPermissionTable) {
            $permStmt = $pdo->prepare("SELECT is_allowed FROM role_permissions WHERE role = ? AND page_name = ? LIMIT 1");
            $permStmt->execute([$currentRoleRaw, $permissionKey]);
            $permRow = $permStmt->fetch();

            if ($permRow) {
                $isAllowed = intval($permRow['is_allowed']) === 1;
            }
        }
    } catch (Exception $e) {
        $isAllowed = null;
    }

    if ($isAllowed === null) {
        $isAllowed = !isLegacyBlockedPage($currentRole, $permissionKey);
    }

    if (!$isAllowed) {
        denyPageAccess('You do not have permission to access this page.');
    }
}
?>
