<?php
// ==========================================
// CPANEL CONFIGURATION & DEBUGGING
// ==========================================
// 1. Enable Error Reporting (Turn off in production by changing 1 to 0)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 2. Safe Session Start
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 3. Safe Include for Session Check
// This prevents the page from crashing if the file is missing
if (file_exists('session_check.php')) {
    include 'session_check.php';
} else {
    // Fallback: If you haven't created session_check.php yet, 
    // we ensure the user is logged in manually or redirect.
    if (!isset($_SESSION['user_id'])) {
        // Uncomment the line below to force redirect if session_check.php is missing
        // header("Location: index.php"); 
        // exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Employee - Mektron</title>
    
    <link rel="stylesheet" href="style.css">
    
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        /* Your CSS is preserved perfectly here */
        .search-container {
            background: white; 
            padding: 25px; 
            border-radius: 8px; 
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 20px;
        }
        .filter-row { display: flex; gap: 15px; align-items: flex-end; flex-wrap: wrap; }
        .filter-group { flex: 1; min-width: 200px; }
        .filter-group label { font-weight: 700; font-size: 12px; color: #555; display: block; margin-bottom: 5px; text-transform: uppercase; }
        .search-input { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; transition: 0.3s; }
        .search-input:focus { border-color: #3498db; outline: none; }
        
        .btn-search {
            background: #2980b9; color: white; border: none; padding: 11px 25px; border-radius: 5px; cursor: pointer; font-weight: 600;
        }
        .btn-search:hover { background: #1c5980; }

        .profile-card {
            background: #f8f9fa; border-left: 5px solid #2ecc71; padding: 20px; border-radius: 4px; display: none; margin-bottom: 30px;
        }
        .profile-card h3 { margin-top: 0; color: #2c3e50; }
        .profile-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 10px; }
        .profile-item span { color: #7f8c8d; font-size: 13px; font-weight: bold; }
        .profile-item strong { display: block; font-size: 16px; color: #333; }

        /* Table Styles */
        .log-table { width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 13px; }
        .log-table th { background: #34495e; color: white; padding: 10px; text-align: left; white-space: nowrap; }
        .log-table td { border-bottom: 1px solid #eee; padding: 8px; }
        .log-table tr:hover { background: #f1f1f1; }

        /* Analytics Table */
        .analytics-table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        .analytics-table thead { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
        .analytics-table th { padding: 15px; text-align: left; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.5px; }
        .analytics-table td { padding: 12px 15px; border-bottom: 1px solid #eee; font-size: 14px; color: #666; }
        .analytics-table tbody tr:hover { background: #f5f5ff; }

        .summary-cards { display: grid; grid-template-columns: repeat(auto-fit, minmax(140px, 1fr)); gap: 15px; margin-bottom: 30px; }
        .summary-card { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 8px; text-align: center; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        .summary-card.alt1 { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
        .summary-card.alt2 { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); }
        .summary-card.alt3 { background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); }
        .summary-card.alt4 { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); }
        .card-label { font-size: 12px; opacity: 0.9; text-transform: uppercase; letter-spacing: 0.5px; margin-bottom: 10px; }
        .card-value { font-size: 22px; font-weight: bold; }
    </style>
</head>
<body>

    <script src="sidebar.js"></script>
    <script src="script.js"></script>

    <div class="main-content">
        <div class="container">
            <h2>Search Employee Record</h2>
            
            <div class="search-container">
                <div class="filter-row">
                    <div class="filter-group">
                        <label>Search by ID</label>
                        <input type="text" id="searchIdInput" class="search-input" placeholder="e.g. EMP101" oninput="if(typeof autoFillEmployeeName === 'function') autoFillEmployeeName()" onkeypress="if(event.key==='Enter' && typeof performEmployeeSearch === 'function') performEmployeeSearch()">
                    </div>
                    <div class="filter-group">
                        <label>Search by Name</label>
                        <input type="text" id="searchNameInput" class="search-input" placeholder="e.g. Selva" oninput="if(typeof autoFillEmployeeId === 'function') autoFillEmployeeId()" onkeypress="if(event.key==='Enter' && typeof performEmployeeSearch === 'function') performEmployeeSearch()">
                    </div>
                    <button onclick="if(typeof performEmployeeSearch === 'function') { performEmployeeSearch() } else { alert('Error: script.js not loaded'); }" class="btn-search">Search</button>
                </div>
            </div>

            <div id="debugInfo" style="background:#f0f8ff; border:1px solid #3498db; padding:10px; margin-bottom:15px; border-radius:5px; font-size:12px; display:none;">
                <strong>Debug Info:</strong>
                <div>Employees Loaded: <span id="debugEmpCount">0</span></div>
                <div>Fields Loaded: <span id="debugFieldCount">0</span></div>
                <button onclick="showDebugInfo()" style="margin-top:5px; padding:5px 10px; background:#3498db; color:white; border:none; border-radius:3px; cursor:pointer;">Refresh Debug</button>
            </div>

            <div id="loadingSpinner" style="display:none; text-align:center; padding:20px;">
                <i class="fas fa-spinner fa-spin fa-2x" style="color:#3498db;"></i><br>Searching...
            </div>

            <div id="searchResult" style="display:none;">
                
                <div class="profile-card" style="display:block;">
                    <h3>Employee Profile</h3>
                    <div class="profile-grid">
                        <div class="profile-item"><span>EMPLOYEE ID</span><strong id="resId">-</strong></div>
                        <div class="profile-item"><span>FULL NAME</span><strong id="resName">-</strong></div>
                        <div class="profile-item"><span>DESIGNATION</span><strong id="resRole">-</strong></div>
                        <div class="profile-item"><span>JOIN DATE</span><strong id="resDate">-</strong></div>
                    </div>
                </div>

                <h3 style="color:#2c3e50; border-bottom:2px solid #eee; padding-bottom:10px;">Recent Work History</h3>
                <div style="overflow-x: auto; background:white; padding:10px; border-radius:8px; box-shadow:0 2px 10px rgba(0,0,0,0.05); margin-bottom:30px;">
                    <table class="log-table">
                        <thead id="searchTableHead">
                        </thead>
                        <tbody id="searchTableBody">
                        </tbody>
                    </table>
                </div>

                <h3 style="color:#2c3e50; border-bottom:2px solid #eee; padding-bottom:10px; margin-top:30px;">Production Analysis (Last 7 Days)</h3>
                
                <div style="background:white; padding:20px; border-radius:8px; box-shadow:0 2px 10px rgba(0,0,0,0.05); margin-bottom:30px;">
                    <div style="position: relative; height: 350px; width: 100%; background: #fafafa; border-radius: 8px; padding: 10px;">
                        <canvas id="employeeLast7DaysChart"></canvas>
                    </div>
                </div>

                <h3 style="color:#2c3e50; border-bottom:2px solid #eee; padding-bottom:10px; margin-top:30px;">Efficiency Trend</h3>
                <div style="background:white; padding:20px; border-radius:8px; box-shadow:0 2px 10px rgba(0,0,0,0.05); margin-bottom:30px;">
                    <div style="position: relative; height: 300px; width: 100%; background: #fafafa; border-radius: 8px; padding: 10px;">
                        <canvas id="employeeEfficiencyChart"></canvas>
                    </div>
                </div>

                <h3 style="color:#2c3e50; border-bottom:2px solid #eee; padding-bottom:10px; margin-top:30px;">Quality & Productivity</h3>
                <div style="background:white; padding:20px; border-radius:8px; box-shadow:0 2px 10px rgba(0,0,0,0.05); margin-bottom:30px;">
                    <div style="position: relative; height: 300px; width: 100%; background: #fafafa; border-radius: 8px; padding: 10px;">
                        <canvas id="employeeProductivityChart"></canvas>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
        // Check if main scripts loaded successfully
        document.addEventListener("DOMContentLoaded", function() {
            console.log('Search Employee Page Loaded');
            
            if (typeof performEmployeeSearch !== 'function') {
                console.error("Warning: script.js is not loaded correctly. Search will not work.");
            }
        });
    </script>
</body>
</html>