<?php
// Protect this page with session check
include 'session_check.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register Employee - Mektron</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        /* --- YOUR EXISTING STYLES --- */
        .main-content {
            background-color: #ffffff;
            background-image: radial-gradient(#e0e0e0 1px, transparent 1px);
            background-size: 20px 20px; 
            position: relative;
            z-index: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            overflow: hidden;
        }
        .container-transparent {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            border: 1px solid rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 450px;
            padding: 40px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
        }
        .form-header h2 { color: #2c3e50; font-size: 26px; text-align: center; margin-bottom: 5px; text-transform: uppercase; }
        .form-header p { color: #7f8c8d; font-size: 13px; text-align: center; margin-bottom: 30px; }
        .dark-group { margin-bottom: 20px; }
        .dark-group label { color: #34495e; font-size: 11px; font-weight: 700; text-transform: uppercase; display: block; margin-bottom: 8px; }
        .dark-input { width: 100%; padding: 12px; border: 2px solid #ecf0f1; border-radius: 6px; box-sizing: border-box; }
        #autoEmpId { background: #eafaf1; color: #27ae60; font-weight: bold; text-align: center; }
        .btn-glow { width: 100%; padding: 14px; background: #2c3e50; color: white; border: none; border-radius: 6px; font-weight: 600; cursor: pointer; text-transform: uppercase; }
        .btn-glow:hover { background: #34495e; }
    </style>
</head>
<body>

    <script src="sidebar.js"></script>

    <div class="main-content">
        <div class="container-transparent">
            <div class="form-header">
                <h2>Register Staff</h2>
                <p>New Employee Profile</p>
            </div>
            
            <form id="registerForm">
                <div class="dark-group">
                    <label>Employee ID</label>
                    <input type="text" id="autoEmpId" name="emp_unique_id" class="dark-input" placeholder="Generating..." readonly>
                </div>

                <div class="dark-group">
                    <label>Full Name</label>
                    <input type="text" id="empName" name="name" class="dark-input" placeholder="Enter full name" maxlength="25" required>
                    <small style="font-size: 11px; color: #7f8c8d; margin-top: 5px; display: block;">Maximum 25 characters</small>
                </div>

                <div class="dark-group">
                    <label>Designation</label>
                    <select id="empDesignation" name="designation" class="dark-input">
                        <option value="Operator">Operator</option>
                        <option value="Supervisor">Supervisor</option>
                        <option value="Helper">Helper</option>
                        <option value="Quality Inspector">Quality Inspector</option>
                        <option value="Maintenance">Maintenance</option>
                    </select>
                </div>

                <div class="dark-group">
                    <label>Date of Joining</label>
                    <input type="date" id="joinDate" name="join_date" class="dark-input" required>
                </div>

                <button type="submit" class="btn-glow">Submit Registration</button>
            </form>
        </div>
    </div>

    <script>
        // ===== MODERN CENTERED MODAL SYSTEM =====
        function showModal(title, message = '', type = 'alert', callback = null) {
            let overlay = document.getElementById('modalOverlay');
            if (!overlay) {
                overlay = document.createElement('div');
                overlay.id = 'modalOverlay';
                overlay.className = 'modal-overlay';
                document.body.appendChild(overlay);
                
                if (!document.querySelector('style[data-modals]')) {
                    const style = document.createElement('style');
                    style.setAttribute('data-modals', 'true');
                    style.textContent = `
                        .modal-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.55); display: flex; align-items: center; justify-content: center; padding: 20px; z-index: 10000; animation: fadeIn 0.3s cubic-bezier(0.4, 0, 0.2, 1); backdrop-filter: blur(2px); }
                        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
                        @keyframes zoomIn { from { transform: scale(0.85) translateY(-30px); opacity: 0; } to { transform: scale(1) translateY(0); opacity: 1; } }
                        .modal-content { background: white; border-radius: 16px; box-shadow: 0 25px 80px rgba(0, 0, 0, 0.35); max-width: 540px; width: 100%; max-height: 85vh; padding: 0; overflow: auto; animation: zoomIn 0.35s cubic-bezier(0.34, 1.56, 0.64, 1); font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif; display: flex; flex-direction: column; }
                        .modal-header { padding: 32px 32px 24px; border-bottom: 1px solid #f0f0f0; display: flex; align-items: flex-start; gap: 16px; flex-shrink: 0; }
                        .modal-icon { font-size: 28px; flex-shrink: 0; width: 44px; height: 44px; display: flex; align-items: center; justify-content: center; border-radius: 50%; margin-top: 2px; }
                        .modal-icon.success { color: #00a65a; background: rgba(0, 166, 90, 0.1); }
                        .modal-icon.error { color: #dd4b39; background: rgba(221, 75, 57, 0.1); }
                        .modal-icon.warning { color: #f39c12; background: rgba(243, 156, 18, 0.1); }
                        .modal-icon.info { color: #3c8dbc; background: rgba(60, 141, 188, 0.1); }
                        .modal-title { font-size: 20px; font-weight: 700; color: #1a1a1a; margin: 0; line-height: 1.4; flex: 1; }
                        .modal-body { padding: 24px 32px; color: #555; font-size: 14px; line-height: 1.7; flex: 1; overflow-y: auto; }
                        .modal-input { width: 100%; padding: 12px 14px; border: 1.5px solid #e0e0e0; border-radius: 8px; font-size: 14px; font-family: inherit; box-sizing: border-box; margin-top: 12px; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); background: #fafafa; }
                        .modal-input:focus { outline: none; border-color: #3c8dbc; background: white; box-shadow: 0 0 0 4px rgba(60, 141, 188, 0.12); }
                        .modal-footer { padding: 24px 32px; border-top: 1px solid #f0f0f0; display: flex; gap: 12px; justify-content: flex-end; background: #fafafa; flex-shrink: 0; }
                        .modal-btn { padding: 12px 32px; border: none; border-radius: 8px; font-size: 14px; font-weight: 600; cursor: pointer; transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1); min-width: 110px; display: inline-flex; align-items: center; justify-content: center; white-space: nowrap; }
                        .modal-btn-ok { background: linear-gradient(135deg, #00a65a 0%, #008c47 100%); color: white; box-shadow: 0 4px 15px rgba(0, 166, 90, 0.25); }
                        .modal-btn-ok:hover { transform: translateY(-2px); box-shadow: 0 6px 25px rgba(0, 166, 90, 0.35); }
                        .modal-btn-ok:active { transform: translateY(0); }
                        .modal-btn-cancel { background: #f5f5f5; color: #444; border: 1px solid #e0e0e0; }
                        .modal-btn-cancel:hover { background: #efefef; border-color: #d0d0d0; transform: translateY(-2px); }
                        .modal-btn-cancel:active { transform: translateY(0); }
                        @media (max-width: 600px) { .modal-overlay { padding: 16px; } .modal-content { max-width: 100%; max-height: 90vh; border-radius: 14px; } .modal-header { padding: 24px 20px 18px; gap: 12px; } .modal-icon { width: 40px; height: 40px; } .modal-title { font-size: 18px; } .modal-body { padding: 20px; } .modal-footer { padding: 20px; } .modal-btn { flex: 1; min-width: auto; padding: 11px 20px; } }
                    `;
                    document.head.appendChild(style);
                }
            }
            
            const icons = { success: 'fas fa-check-circle', error: 'fas fa-exclamation-circle', warning: 'fas fa-warning', alert: 'fas fa-info-circle' };
            const modal = document.createElement('div');
            modal.className = 'modal-content';
            
            modal.innerHTML = `
                <div class="modal-header">
                    <div class="modal-icon ${type}"><i class="fas ${icons[type]}"></i></div>
                    <h2 class="modal-title">${title}</h2>
                </div>
                <div class="modal-body">${message}</div>
                <div class="modal-footer">
                    <button class="modal-btn modal-btn-ok" onclick="this.closest('.modal-overlay').remove()">OK</button>
                </div>
            `;
            
            overlay.innerHTML = '';
            overlay.appendChild(modal);
            overlay.onclick = (e) => { if (e.target === overlay) overlay.remove(); };
        }

        document.addEventListener('DOMContentLoaded', function() {
            // 1. Auto-fill Date with Today
            const today = new Date().toISOString().split('T')[0];
            document.getElementById('joinDate').value = today;

            // 2. Capitalize First Letter of Employee Name
            const empNameInput = document.getElementById('empName');
            empNameInput.addEventListener('input', function() {
                if (this.value.length > 0) {
                    this.value = this.value.charAt(0).toUpperCase() + this.value.slice(1);
                }
            });

            // 3. Fetch Next ID
            fetch('api.php?action=get_next_id')
                .then(r => r.json())
                .then(d => { if(d.next_id) document.getElementById('autoEmpId').value = d.next_id; });

            // 4. Submit Handler
            document.getElementById('registerForm').addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Create FormData
                const formData = new FormData(this);
                
                // FORCE ADD MISSING DATA
                const idVal = document.getElementById('autoEmpId').value;
                const dateVal = document.getElementById('joinDate').value || today;

                formData.set('emp_unique_id', idVal);
                formData.set('join_date', dateVal);

                // Send
                fetch('api.php?action=register_employee', { method: 'POST', body: formData })
                .then(res => res.json())
                .then(data => {
                    if(data.success) {
                        showModal('✓ Success', 'Employee registered successfully!', 'success');
                        setTimeout(() => location.reload(), 2000);
                    } else {
                        showModal('✗ Error', 'Failed to register: ' + (data.error || 'Database Error'), 'error');
                    }
                })
                .catch(err => showModal('✗ Error', 'Network error - please check connection', 'error'));
            });
        });
    </script>
</body>
</html>
