<?php
/**
 * Notification System - Database Initialization
 * Automatically creates notification_settings table if it doesn't exist
 */

  $host = 'localhost'; 
    $db = 'zemaraim_mektron_db'; 
    $user = 'zemaraim'; 
    $pass = '8wwxk]-X3Kx]CJ]5';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);

    // Check if notification_settings table exists
    $tableCheck = $pdo->query("SHOW TABLES LIKE 'notification_settings'");
    $tableExists = $tableCheck->rowCount() > 0;

    if (!$tableExists) {
        // Create notification_settings table
        $createTableSQL = "CREATE TABLE IF NOT EXISTS `notification_settings` (
            `id` INT AUTO_INCREMENT PRIMARY KEY,
            `setting_key` VARCHAR(100) UNIQUE NOT NULL,
            `setting_value` VARCHAR(255) NOT NULL,
            `description` TEXT,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

        $pdo->exec($createTableSQL);

        // Insert default settings
        $insertSQL = "INSERT INTO `notification_settings` (`setting_key`, `setting_value`, `description`) VALUES 
        (?, ?, ?),
        (?, ?, ?),
        (?, ?, ?),
        (?, ?, ?)";

        $stmt = $pdo->prepare($insertSQL);
        $stmt->execute([
            'machine_days_threshold', '15', 'Number of days before machine maintenance due to trigger alert',
            'tool_strokes_threshold', '1000', 'Number of remaining strokes before tool alert is triggered',
            'notification_enabled', '1', 'Enable/disable notification system',
            'alert_email_admin', '0', 'Send email alerts to admin'
        ]);

        error_log("[✓] Notification database initialized successfully");
        return ['success' => true, 'message' => 'Database initialized'];
    } else {
        // Table already exists, verify it has the required columns
        $columnCheck = $pdo->query("SHOW COLUMNS FROM notification_settings");
        $columns = $columnCheck->fetchAll(PDO::FETCH_COLUMN, 0);

        if (!in_array('setting_key', $columns)) {
            error_log("[!] notification_settings table exists but missing required columns");
        }

        // Ensure default settings exist
        $countStmt = $pdo->query("SELECT COUNT(*) as count FROM notification_settings");
        $count = $countStmt->fetch();

        if ($count['count'] == 0) {
            // Table exists but is empty - insert defaults
            $insertSQL = "INSERT INTO `notification_settings` (`setting_key`, `setting_value`, `description`) VALUES 
            (?, ?, ?),
            (?, ?, ?)";

            $stmt = $pdo->prepare($insertSQL);
            $stmt->execute([
                'machine_days_threshold', '15', 'Number of days before machine maintenance due to trigger alert',
                'tool_strokes_threshold', '1000', 'Number of remaining strokes before tool alert is triggered'
            ]);

            error_log("[✓] Default notification settings inserted");
        }

        return ['success' => true, 'message' => 'Database already initialized'];
    }

} catch (PDOException $e) {
    error_log("[✗] Database initialization failed: " . $e->getMessage());
    return ['success' => false, 'error' => $e->getMessage()];
}
?>
