-- ============================================================
-- UPDATE USERS TABLE ROLE COLUMN TO ONLY TWO ROLES
-- Administrator and Controller (no User role)
-- ============================================================

-- Step 1: Modify the role column to only accept Administrator and Controller
ALTER TABLE users MODIFY COLUMN role ENUM('Administrator', 'Controller') NOT NULL DEFAULT 'Controller';

-- Step 2: Verify the change
DESCRIBE users;

-- All done! The users table now only accepts:
-- - Administrator (can create controllers, access admin dashboard)
-- - Controller (intermediate user, no admin dashboard access)
