-- ========================================
-- Notification System Database Setup
-- ========================================

-- Table: notification_settings
-- Stores configurable thresholds for alerts
CREATE TABLE IF NOT EXISTS `notification_settings` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `setting_key` VARCHAR(100) UNIQUE NOT NULL,
  `setting_value` VARCHAR(255) NOT NULL,
  `description` TEXT,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default settings if not exist
INSERT IGNORE INTO `notification_settings` (`setting_key`, `setting_value`, `description`) VALUES 
('machine_days_threshold', '15', 'Number of days before machine maintenance due to trigger alert'),
('tool_strokes_threshold', '1000', 'Number of remaining strokes before tool alert is triggered'),
('notification_enabled', '1', 'Enable/disable notification system'),
('alert_email_admin', '0', 'Send email alerts to admin');
