

// Test 1: Check if Chart.js is loaded
console.log('=== CHART.JS CHECK ===');
console.log('Chart.js loaded:', typeof Chart !== 'undefined');
console.log('Chart.js version:', Chart ? Chart.version : 'NOT FOUND');

// Test 2: Check if canvas exists
console.log('\n=== CANVAS CHECK ===');
const canvas = document.getElementById('comparisonDistributionChart');
console.log('Canvas element found:', canvas !== null);
if (canvas) {
    console.log('Canvas parent:', canvas.parentElement.className);
    console.log('Canvas container height:', canvas.parentElement.style.height);
}

// Test 3: Check if functions exist
console.log('\n=== FUNCTIONS CHECK ===');
console.log('switchComparisonChart exists:', typeof switchComparisonChart === 'function');
console.log('buildComparisonCharts exists:', typeof buildComparisonCharts === 'function');
console.log('buildDistributionComparison exists:', typeof buildDistributionComparison === 'function');
console.log('buildLineComparison exists:', typeof buildLineComparison === 'function');

// Test 4: Check comparison data storage
console.log('\n=== DATA STORAGE CHECK ===');
console.log('window.comparisonChartData:', window.comparisonChartData);

// Test 5: Check if buttons exist
console.log('\n=== BUTTONS CHECK ===');
const btnBar = document.getElementById('btnComparisonBar');
const btnLine = document.getElementById('btnComparisonLine');
console.log('Bar button found:', btnBar !== null);
console.log('Line button found:', btnLine !== null);

// Test 6: Create sample data and test chart rendering
console.log('\n=== TESTING CHART RENDERING ===');
const sampleData = {
    data: [
        {value: 'Item 1', count: 45},
        {value: 'Item 2', count: 38},
        {value: 'Item 3', count: 52},
        {value: 'Item 4', count: 29},
        {value: 'Item 5', count: 67}
    ]
};

// This will only work if you have the functions
if (typeof buildComparisonCharts === 'function') {
    console.log('📊 To test the chart, run:');
    console.log('buildComparisonCharts(sampleData, sampleData, "Field 1", "Field 2")');
    console.log('Then try: switchComparisonChart("line")');
}

console.log('\n✅ DEBUG CHECK COMPLETE');
